/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.exporter;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.table.TableModel;
import pt.webdetails.cda.exporter.AbstractExporter;
import pt.webdetails.cda.exporter.ExporterException;

public class BinaryExporter
extends AbstractExporter {
    public static final String MYMETYPE_SETTING = "mimeType";
    private String attachmentName;
    private String mimeType;

    public BinaryExporter() {
    }

    public BinaryExporter(Map<String, String> extraSettings) {
        super(extraSettings);
        this.mimeType = this.getSetting(MYMETYPE_SETTING, "octet-stream");
        this.attachmentName = extraSettings.get("attachmentName");
    }

    @Override
    public void export(OutputStream out, TableModel tableModel) throws ExporterException {
        byte[] file = this.getBinaryFromFile(tableModel);
        if (file != null) {
            try {
                out.write(file);
            }
            catch (IOException ioe) {
                logger.error((Object)"Exception while writing blob to ouput stream", (Throwable)ioe);
            }
        }
    }

    private byte[] getBinaryFromFile(TableModel tableModel) throws ExporterException {
        int columnCount = tableModel.getColumnCount();
        int colIdx = -1;
        int fileNameColIdx = -1;
        for (int i = 0; i < columnCount; ++i) {
            Class<?> columnClass = tableModel.getColumnClass(i);
            if (this.getColType(columnClass).equals("Blob")) {
                colIdx = i;
            }
            if (!tableModel.getColumnName(i).equals("file_name")) continue;
            fileNameColIdx = i;
        }
        int rowCount = tableModel.getRowCount();
        if (rowCount > 0 && fileNameColIdx >= 0) {
            this.attachmentName = (String)tableModel.getValueAt(0, fileNameColIdx);
        }
        if (colIdx >= 0) {
            if (rowCount > 0) {
                Object value = tableModel.getValueAt(0, colIdx);
                if (value instanceof Blob) {
                    Blob v = (Blob)value;
                    try {
                        return v.getBytes(0L, (int)v.length());
                    }
                    catch (SQLException se) {
                        logger.error((Object)"Exception caught while trying to read blob", (Throwable)se);
                        return null;
                    }
                }
                return (byte[])value;
            }
        } else {
            logger.warn((Object)"Did not find a blob column in the tableModel");
        }
        return null;
    }

    @Override
    public String getMimeType() {
        return "application/" + this.mimeType;
    }

    @Override
    public String getAttachmentName() {
        return this.attachmentName;
    }
}

