/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.exporter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import pt.webdetails.cda.exporter.Exporter;
import pt.webdetails.cda.exporter.ExporterEngine;
import pt.webdetails.cda.exporter.ExporterException;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.utils.MimeTypes;

public abstract class ExportedQueryResult {
    private Exporter exporter;

    public ExportedQueryResult(Exporter exporter) {
        assert (exporter != null);
        this.exporter = exporter;
    }

    public Exporter getExporter() {
        return this.exporter;
    }

    public void writeHeaders(HttpServletResponse response) throws IOException {
        ExportedQueryResult.setResponseHeaders(response, this.exporter.getMimeType(), this.exporter.getAttachmentName());
    }

    public void writeResponse(HttpServletResponse response) throws ExporterException, IOException {
        ExportedQueryResult.setResponseHeaders(response, this.exporter.getMimeType(), this.exporter.getAttachmentName());
        ServletOutputStream out = response.getOutputStream();
        this.writeOut((OutputStream)out);
    }

    public abstract void writeOut(OutputStream var1) throws ExporterException;

    public String asString() throws ExporterException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeOut(out);
        return Util.toString((byte[])out.toByteArray());
    }

    public String getContentType() {
        String mimeType = this.exporter.getMimeType();
        String attachmentName = this.exporter.getAttachmentName();
        return ExportedQueryResult.getContentType(mimeType, attachmentName);
    }

    private static String getContentType(String mimeType, String attachmentName) {
        if (StringUtils.isEmpty((String)mimeType) && !StringUtils.isEmpty((String)attachmentName)) {
            return MimeTypes.getMimeType((String)attachmentName);
        }
        return mimeType;
    }

    public String getContentDisposition() {
        String attachmentName = this.exporter.getAttachmentName();
        String contentType = this.getContentType();
        return ExportedQueryResult.getContentDisposition(contentType, attachmentName);
    }

    private static String getContentDisposition(String mimeType, String attachmentName) {
        String extension;
        if (attachmentName != null) {
            return "attachment; filename=" + attachmentName;
        }
        switch (mimeType) {
            case "text/csv": {
                extension = "." + ExporterEngine.OutputType.CSV.toString();
                break;
            }
            case "application/json": {
                extension = "." + ExporterEngine.OutputType.JSON.toString();
                break;
            }
            case "application/msexcel": {
                extension = "." + ExporterEngine.OutputType.XLS.toString();
                break;
            }
            case "text/xml": {
                extension = "." + ExporterEngine.OutputType.XML.toString();
                break;
            }
            case "text/html": {
                extension = "." + ExporterEngine.OutputType.HTML.toString();
                break;
            }
            default: {
                extension = "";
            }
        }
        return "inline; filename=doQuery" + extension;
    }

    private static void setResponseHeaders(HttpServletResponse response, String mimeType, String attachmentName) {
        String contentType = ExportedQueryResult.getContentType(mimeType, attachmentName);
        response.setContentType(contentType);
        String contentDisposition = ExportedQueryResult.getContentDisposition(mimeType, attachmentName);
        response.setHeader("content-disposition", contentDisposition);
    }
}

