/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.exporter;

import java.util.Map;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.exceloutput.ExcelOutputMeta;
import pt.webdetails.cda.exporter.AbstractKettleExporter;

public class XlsExporter
extends AbstractKettleExporter {
    public static final String TEMPLATE_NAME_SETTING = "templateName";
    private String attachmentName = this.getSetting("attachmentName", "cda-export." + this.getType());
    private String templateName = this.getSetting("templateName", null);
    private boolean includeHeader = Boolean.parseBoolean(this.getSetting("columnHeaders", "true"));

    public XlsExporter(Map<String, String> extraSettings) {
        super(extraSettings);
    }

    @Override
    protected StepMeta getExportStepMeta(String name) {
        ExcelOutputMeta excelOutput = new ExcelOutputMeta();
        excelOutput.setDefault();
        excelOutput.setFileName("${java.io.tmpdir}/" + this.getFileName());
        excelOutput.setHeaderEnabled(this.includeHeader);
        if (this.templateName != null) {
            excelOutput.setTemplateEnabled(true);
            excelOutput.setTemplateFileName(this.templateName);
            excelOutput.setTemplateAppend(true);
        }
        StepMeta stepMeta = new StepMeta(name, (StepMetaInterface)excelOutput);
        stepMeta.setCopies(1);
        return stepMeta;
    }

    @Override
    public String getMimeType() {
        return "application/vnd.ms-excel";
    }

    @Override
    public String getType() {
        return "xls";
    }

    @Override
    public String getAttachmentName() {
        return this.attachmentName;
    }
}

