/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.exporter;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import pt.webdetails.cda.exporter.AbstractExporter;
import pt.webdetails.cda.exporter.ExporterException;

public class XmlExporter
extends AbstractExporter {
    private static final String MIME_TYPE = "text/xml";
    private static final Log logger = LogFactory.getLog(XmlExporter.class);
    private String attachmentName = this.getSetting("attachmentName", null);

    public XmlExporter(Map<String, String> extraSettings) {
        super(extraSettings);
        logger.debug((Object)("Initialized XmlExporter with attachement filename '" + this.attachmentName + "'"));
    }

    @Override
    public void export(OutputStream out, TableModel tableModel) throws ExporterException {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("CdaExport");
        Element metadata = root.addElement("MetaData");
        int columnCount = tableModel.getColumnCount();
        int rowCount = tableModel.getRowCount();
        for (int i = 0; i < columnCount; ++i) {
            Element columnInfo = metadata.addElement("ColumnMetaData");
            columnInfo.addAttribute("index", String.valueOf(i));
            columnInfo.addAttribute("type", this.getColType(tableModel.getColumnClass(i)));
            columnInfo.addAttribute("name", tableModel.getColumnName(i));
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
        Element resultSet = root.addElement("ResultSet");
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            Element row = resultSet.addElement("Row");
            for (int colIdx = 0; colIdx < columnCount; ++colIdx) {
                Element col = row.addElement("Col");
                Object value = tableModel.getValueAt(rowIdx, colIdx);
                if (value instanceof Date) {
                    col.setText(format.format(value));
                    continue;
                }
                if (value != null) {
                    col.setText(value.toString());
                    continue;
                }
                col.addAttribute("isNull", "true");
            }
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
            document.setXMLEncoding("UTF-8");
            document.write((Writer)writer);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new ExporterException("IO Exception converting to utf-8", e);
        }
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public String getAttachmentName() {
        return this.attachmentName;
    }
}

