/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.formula;

import pt.webdetails.cda.formula.ICdaParameterProvider;
import pt.webdetails.cpf.session.ISessionUtils;
import pt.webdetails.cpf.session.IUserSession;

public class CdaSecurityParameterProvider
implements ICdaParameterProvider {
    private ISessionUtils sessionUtils;
    private static String principalName = "principalName";
    private static String principalRoles = "principalRoles";
    private static String systemRoleNames = "systemRoleNames";
    private static String systemUserNames = "systemUserNames";

    public CdaSecurityParameterProvider(ISessionUtils sessionUtils) {
        this.sessionUtils = sessionUtils;
    }

    @Override
    public Object getParameter(String name) {
        if (name != null) {
            IUserSession session = this.sessionUtils.getCurrentSession();
            if (session != null) {
                if (principalName.equals(name)) {
                    return session.getUserName();
                }
                if (principalRoles.equals(name)) {
                    return this.convertArray(session.getAuthorities());
                }
            } else {
                if (systemUserNames.equals(name)) {
                    return this.convertArray(this.sessionUtils.getSystemPrincipals());
                }
                if (systemRoleNames.equals(name)) {
                    return this.convertArray(this.sessionUtils.getSystemAuthorities());
                }
            }
        }
        return null;
    }

    private String convertArray(Object[] array) {
        if (array != null && array.length > 0) {
            String output = "";
            for (int i = 0; i < array.length; ++i) {
                output = output + (i > 0 ? "," + array[i] : array[i]);
            }
            return output;
        }
        return null;
    }
}

