/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils.kettle;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicMarkableReference;
import java.util.function.Function;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.reporting.engine.classic.core.states.datarow.EmptyTableModel;
import org.pentaho.reporting.engine.classic.core.util.TypedTableModel;

public class RowMetaToTableModel
implements RowListener {
    private static final Log logger = LogFactory.getLog(RowMetaToTableModel.class);
    private boolean recordRowsRead;
    private final AtomicMarkableReference<RowMetaInterface> rowsReadMeta = new AtomicMarkableReference<Object>(null, false);
    private List<Object[]> rowsRead;
    private boolean recordRowsWritten;
    private final AtomicMarkableReference<RowMetaInterface> rowsWrittenMeta = new AtomicMarkableReference<Object>(null, false);
    private List<Object[]> rowsWritten;
    private boolean recordRowsError;
    private final AtomicMarkableReference<RowMetaInterface> rowsErrorMeta = new AtomicMarkableReference<Object>(null, false);
    private List<Object[]> rowsError;

    public RowMetaToTableModel(boolean recordRowsRead, boolean recordRowsWritten, boolean recordRowsError) {
        if (!(recordRowsWritten || recordRowsRead || recordRowsError)) {
            throw new IllegalArgumentException("Not recording any output. Must listen to something.");
        }
        if (recordRowsRead) {
            this.recordRowsRead = true;
            this.rowsRead = new ArrayList<Object[]>();
        }
        if (recordRowsWritten) {
            this.recordRowsWritten = true;
            this.rowsWritten = new ArrayList<Object[]>();
        }
        if (recordRowsError) {
            this.recordRowsError = true;
            this.rowsError = new ArrayList<Object[]>();
        }
    }

    public void rowReadEvent(RowMetaInterface rowMeta, Object[] row) {
        if (this.recordRowsRead) {
            this.rowsReadMeta.weakCompareAndSet(null, rowMeta, false, true);
            this.rowsRead.add(row);
        }
    }

    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) {
        if (this.recordRowsWritten) {
            this.rowsWrittenMeta.weakCompareAndSet(null, rowMeta, false, true);
            this.rowsWritten.add(row);
        }
    }

    public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] row) {
        if (this.recordRowsError) {
            this.rowsErrorMeta.weakCompareAndSet(null, rowMeta, false, true);
            this.rowsError.add(row);
        }
    }

    public TableModel getRowsRead() {
        return this.asTableModel(this.rowsReadMeta.getReference(), this.rowsRead);
    }

    public TableModel getRowsWritten() {
        return this.asTableModel(this.rowsWrittenMeta.getReference(), this.rowsWritten);
    }

    public TableModel getRowsError() {
        return this.asTableModel(this.rowsErrorMeta.getReference(), this.rowsError);
    }

    private TableModel asTableModel(RowMetaInterface rowMeta, List<Object[]> rows) {
        if (rowMeta == null) {
            return null;
        }
        TypedTableModel output = new TypedTableModel(rowMeta.getFieldNames(), (Class[])RowMetaToTableModel.getClassesForFields(rowMeta), rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            Object[] row = rows.get(i);
            for (int j = 0; j < row.length; ++j) {
                output.setValueAt(row[j], i, j);
            }
        }
        return output;
    }

    private static Class<?>[] getClassesForFields(RowMetaInterface rowMeta) throws IllegalArgumentException {
        List valueMetas = rowMeta.getValueMetaList();
        Class[] types = new Class[valueMetas.size()];
        block9: for (int i = 0; i < valueMetas.size(); ++i) {
            ValueMetaInterface valueMeta = (ValueMetaInterface)valueMetas.get(i);
            switch (valueMeta.getType()) {
                case 2: {
                    types[i] = String.class;
                    continue block9;
                }
                case 1: {
                    types[i] = Double.class;
                    continue block9;
                }
                case 5: {
                    types[i] = Long.class;
                    continue block9;
                }
                case 3: {
                    types[i] = Date.class;
                    continue block9;
                }
                case 6: {
                    types[i] = BigDecimal.class;
                    continue block9;
                }
                case 4: {
                    types[i] = Boolean.class;
                    continue block9;
                }
                case 8: {
                    types[i] = byte[].class;
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException(String.format("No type conversion found for Field %d %s", i, valueMeta.toString()));
                }
            }
        }
        return types;
    }

    public static Function<List<RowMetaAndData>, TableModel> getConverter() {
        return new Function<List<RowMetaAndData>, TableModel>(){
            private TableModelHeader header;

            @Override
            public TableModel apply(final List<RowMetaAndData> rowMetaAndData) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(" new list received, " + rowMetaAndData.size() + " items "));
                }
                if (rowMetaAndData.isEmpty()) {
                    return new EmptyTableModel();
                }
                if (this.header == null) {
                    this.header = new TableModelHeader(rowMetaAndData.get(0).getRowMeta());
                }
                return new AbstractTableModel(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public int getRowCount() {
                        return rowMetaAndData.size();
                    }

                    @Override
                    public int getColumnCount() {
                        return header.getColumnCount();
                    }

                    @Override
                    public String getColumnName(int column) {
                        return header.getColumnName(column);
                    }

                    @Override
                    public Class<?> getColumnClass(int columnIndex) {
                        return header.getColumnClass(columnIndex);
                    }

                    @Override
                    public Object getValueAt(int rowIndex, int columnIndex) {
                        RowMetaAndData rowMetaData = (RowMetaAndData)rowMetaAndData.get(rowIndex);
                        Object value = rowMetaData.getData()[columnIndex];
                        if (value != null && value instanceof Date && rowMetaData.getValueMeta(columnIndex).getType() == 3) {
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime((Date)value);
                            return new Timestamp(calendar.getTimeInMillis());
                        }
                        return value;
                    }
                };
            }
        };
    }

    private static class TableModelHeader {
        private final String[] columnNames;
        private final Class<?>[] columnClasses;

        public TableModelHeader(RowMetaInterface rowMeta) {
            this.columnNames = rowMeta.getFieldNames();
            this.columnClasses = RowMetaToTableModel.getClassesForFields(rowMeta);
        }

        public Class<?> getColumnClass(int column) {
            return this.columnClasses[column];
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }
    }
}

