/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils.kettle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.utils.kettle.RowMetaToTableModel;
import pt.webdetails.cda.utils.kettle.SortException;
import pt.webdetails.cda.utils.kettle.SortableTableModel;
import pt.webdetails.robochef.DynamicTransConfig;
import pt.webdetails.robochef.DynamicTransMetaConfig;
import pt.webdetails.robochef.DynamicTransformation;
import pt.webdetails.robochef.RowProductionManager;
import pt.webdetails.robochef.TableModelInput;

public class SortTableModel
implements RowProductionManager {
    private static final Log logger = LogFactory.getLog(SortTableModel.class);
    private ExecutorService executorService = CdaEngine.getInstance().getExecutorService();
    private static final long DEFAULT_ROW_PRODUCTION_TIMEOUT = 120L;
    private static final TimeUnit DEFAULT_ROW_PRODUCTION_TIMEOUT_UNIT = TimeUnit.SECONDS;

    public TableModel doSort(TableModel unsorted, List<String> sortBy) throws SortException {
        String sortType = CdaEngine.getInstance().getConfigProperty("pt.webdetails.cda.SortingType");
        if ("DEFAULT".equals(sortType) || StringUtils.isEmpty((String)sortType)) {
            return this.defaultSort(unsorted, sortBy);
        }
        return this.customSort(unsorted, sortBy, sortType);
    }

    public TableModel customSort(TableModel unsorted, List<String> sortBy, String comparatorClass) throws SortException {
        try {
            Class<?> comp = Class.forName(comparatorClass);
            SortableTableModel sortable = new SortableTableModel(unsorted);
            sortable.sort(comp, sortBy);
            return sortable;
        }
        catch (Exception e) {
            throw new SortException("Exception during sorting ", e);
        }
    }

    public TableModel defaultSort(TableModel unsorted, List<String> sortBy) throws SortException {
        if (unsorted == null || unsorted.getRowCount() == 0) {
            return unsorted;
        }
        TableModel output = null;
        ArrayList<Callable<Boolean>> inputCallables = new ArrayList<Callable<Boolean>>();
        try {
            String sort = this.getSortXmlStep(unsorted, sortBy);
            DynamicTransMetaConfig transMetaConfig = new DynamicTransMetaConfig(DynamicTransMetaConfig.Type.EMPTY, "JoinCompoundData", null, null);
            DynamicTransConfig transConfig = new DynamicTransConfig();
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.STEP, "input", "<step><name>input</name><type>Injector</type><copies>1</copies></step>");
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.STEP, "sort", sort);
            transConfig.addConfigEntry(DynamicTransConfig.EntryType.HOP, "input", "sort");
            TableModelInput input = new TableModelInput();
            transConfig.addInput("input", input);
            inputCallables.add(input.getCallableRowProducer(unsorted, true));
            RowMetaToTableModel outputListener = new RowMetaToTableModel(false, true, false);
            transConfig.addOutput("sort", outputListener);
            DynamicTransformation trans = new DynamicTransformation(transConfig, transMetaConfig, inputCallables);
            trans.executeCheckedSuccess(null, null, this);
            logger.info((Object)trans.getReadWriteThroughput());
            output = outputListener.getRowsWritten();
            return output;
        }
        catch (Exception e) {
            throw new SortException("Exception during sorting ", e);
        }
    }

    @Override
    public void startRowProduction(Collection<Callable<Boolean>> inputCallables) {
        String timeoutStr = CdaEngine.getInstance().getConfigProperty("pt.webdetails.cda.DefaultRowProductionTimeout");
        long timeout = StringUtils.isEmpty((String)timeoutStr) ? 120L : Long.parseLong(timeoutStr);
        String unitStr = CdaEngine.getInstance().getConfigProperty("pt.webdetails.cda.DefaultRowProductionTimeoutTimeUnit");
        TimeUnit unit = StringUtils.isEmpty((String)unitStr) ? DEFAULT_ROW_PRODUCTION_TIMEOUT_UNIT : TimeUnit.valueOf(unitStr);
        this.startRowProduction(timeout, unit, inputCallables);
    }

    @Override
    public void startRowProduction(long timeout, TimeUnit unit, Collection<Callable<Boolean>> inputCallables) {
        try {
            List<Future<Boolean>> results = this.executorService.invokeAll(inputCallables, timeout, unit);
            for (Future<Boolean> result : results) {
                result.get();
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e);
        }
        catch (ExecutionException e) {
            logger.error((Object)e);
        }
    }

    private String getSortXmlStep(TableModel unsorted, List<String> sortBy) throws SortException {
        StringBuilder sortXML = new StringBuilder("  <step>\n    <name>sort</name>\n    <type>SortRows</type>\n    <description/>\n    <distribute>Y</distribute>\n    <copies>1</copies>\n         <partitioning>\n           <method>none</method>\n           <schema_name/>\n           </partitioning>\n      <directory>%%java.io.tmpdir%%</directory>\n      <prefix>out</prefix>\n      <sort_size>1000000</sort_size>\n      <free_memory>25</free_memory>\n      <compress>N</compress>\n      <compress_variable/>\n      <unique_rows>N</unique_rows>\n    <fields>\n");
        for (String s : sortBy) {
            SortDescriptor sort = new SortDescriptor(s);
            sortXML.append("      <field>\n" + XMLHandler.addTagValue((String)"name", (String)unsorted.getColumnName(sort.getIndex())) + XMLHandler.addTagValue((String)"ascending", (String)sort.getIsAscendingString()) + "        <case_sensitive>N</case_sensitive>\n      </field>\n");
        }
        sortXML.append("    </fields>\n     <cluster_schema/>\n <remotesteps>   <input>   </input>   <output>   </output> </remotesteps>    <GUI>\n      <xloc>615</xloc>\n      <yloc>188</yloc>\n      <draw>Y</draw>\n      </GUI>\n    </step>\n");
        return sortXML.toString();
    }

    private class SortDescriptor {
        private Integer index;
        private String direction;
        private static final String REGEXP = "^(\\d+)([AD]?)$";
        Pattern p = Pattern.compile("^(\\d+)([AD]?)$");

        public SortDescriptor(String sortBy) throws SortException {
            Matcher m = this.p.matcher(sortBy);
            if (m.matches()) {
                this.index = Integer.parseInt(m.group(1));
                if (m.group(2).equals("D")) {
                    this.setDirection("DESC");
                } else {
                    this.setDirection("ASC");
                }
            } else {
                throw new SortException("Invalid searchBy option: " + sortBy, null);
            }
        }

        public String getIsAscendingString() {
            if (this.getDirection().equals("ASC")) {
                return "Y";
            }
            return "N";
        }

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String direction) {
            this.direction = direction;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }
    }
}

