/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils.mondrian;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Dimension;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Result;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.util.CloseableTableModel;
import org.pentaho.reporting.engine.classic.core.util.IntList;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultConceptQueryMapper;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MDXMetaDataCellAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MDXMetaDataMemberAttributes;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.util.ResultSetProcessingLib;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import pt.webdetails.cda.utils.mondrian.MDXTableModelUtils;

public class ExtDenormalizedMDXTableModel
extends AbstractTableModel
implements CloseableTableModel,
MetaTableModel {
    private int[] axesSize;
    private IntList columnToAxisPosition;
    private int columnCount;
    private List<Member> columnToMemberMapping;
    private List<String> columnNames;
    private Result resultSet;
    private int rowCount;

    public ExtDenormalizedMDXTableModel(Result resultSet, int rowLimit, boolean membersOnAxisSorted) {
        ArgumentNullException.validate((String)"resultSet", (Object)resultSet);
        this.resultSet = resultSet;
        Axis[] axes = this.resultSet.getAxes();
        this.axesSize = ResultSetProcessingLib.computeItemsPerAxis((Axis[])axes);
        this.rowCount = this.computeRowCount(this.axesSize);
        int[] axesMembers = ResultSetProcessingLib.computeTotalColumnsPerAxis((Axis[])axes, (int)0, (boolean)membersOnAxisSorted);
        this.columnCount = this.computeColumnCount(axesMembers);
        this.columnToAxisPosition = ResultSetProcessingLib.computeColumnToAxisMapping((Axis[])axes, (int[])axesMembers, (int)this.columnCount, (int)0);
        this.columnToMemberMapping = Collections.unmodifiableList(ResultSetProcessingLib.computeColumnToMemberMapping((Axis[])axes, (int[])axesMembers, (int)0, (boolean)membersOnAxisSorted));
        this.columnNames = this.computeColumnNames(this.columnToMemberMapping);
        if (rowLimit > 0) {
            this.rowCount = Math.min(rowLimit, this.rowCount);
        }
    }

    private List<String> computeColumnNames(List<Member> columnToMemberMapper) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Member member : columnToMemberMapper) {
            columnNames.add(member.getLevel().getUniqueName());
        }
        Member measureName = this.computeMeasureName(this.resultSet);
        if (measureName != null) {
            columnNames.add(MDXTableModelUtils.getProperMemberName(measureName, measureName.getUniqueName()));
        } else {
            columnNames.add("Measure");
        }
        return columnNames;
    }

    private int computeColumnCount(int[] axesMembers) {
        if (axesMembers.length == 0) {
            return 1;
        }
        boolean emptyAxisFound = false;
        int columnCount = 0;
        for (int i = 0; i < axesMembers.length; ++i) {
            columnCount += axesMembers[i];
            if (axesMembers[i] != 0) continue;
            emptyAxisFound = true;
        }
        if (!emptyAxisFound) {
            ++columnCount;
        }
        return columnCount;
    }

    private int computeRowCount(int[] axesSize) {
        int rowCount = 1;
        for (int i = 0; i < axesSize.length; ++i) {
            int size = axesSize[i];
            rowCount *= size;
        }
        return Math.max(1, rowCount);
    }

    private Member computeMeasureName(Result resultSet) {
        List positionList = resultSet.getSlicerAxis().getPositions();
        for (int i = 0; i < positionList.size(); ++i) {
            Position position = (Position)positionList.get(i);
            for (int positionIndex = 0; positionIndex < position.size(); ++positionIndex) {
                for (Member m = (Member)position.get(positionIndex); m != null; m = m.getParentMember()) {
                    if (!m.isMeasure()) continue;
                    return m;
                }
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.getRowCount() == 0) {
            return Object.class;
        }
        try {
            Object targetClassObj = this.getValueAt(0, columnIndex);
            if (targetClassObj == null) {
                return Object.class;
            }
            return targetClassObj.getClass();
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Member candidateMember;
        int[] cellKey;
        if (columnIndex >= this.columnNames.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isMeasureColumn(columnIndex)) {
            cellKey = this.computeCellKey(rowIndex);
            try {
                Cell cell = this.resultSet.getCell(cellKey);
                if (cell.isNull()) {
                    return null;
                }
                return cell.getValue();
            }
            catch (NullPointerException pe) {
                pe.printStackTrace();
            }
        }
        if ((candidateMember = this.getCandidateMembers(columnIndex, cellKey = this.computeCellKey(rowIndex))) != null) {
            return MDXTableModelUtils.getProperMemberName(candidateMember, candidateMember.getName());
        }
        return null;
    }

    private Member getCandidateMembers(int columnIndex, int[] cellKey) {
        int axisIndex = this.columnToAxisPosition.get(columnIndex);
        Axis[] axes = this.resultSet.getAxes();
        Axis axis = axes[axisIndex];
        List positionList = axis.getPositions();
        if (positionList.isEmpty()) {
            return null;
        }
        int posIndex = cellKey[axisIndex];
        Position position = (Position)positionList.get(posIndex);
        Member memberByName = this.findMemberByName((List<Member>)position, columnIndex);
        if (memberByName != null) {
            return memberByName;
        }
        return this.findRootMember((List<Member>)position, columnIndex);
    }

    private Member findRootMember(List<Member> position, int columnIndex) {
        Dimension dimension = this.columnToMemberMapping.get(columnIndex).getDimension();
        for (int i = 0; i < position.size(); ++i) {
            Member member = position.get(i);
            if (!dimension.equals(member.getDimension()) || member.getParentMember() != null) continue;
            return member;
        }
        return null;
    }

    private Member findMemberByName(List<Member> position, int columnIndex) {
        Dimension dimension = this.columnToMemberMapping.get(columnIndex).getDimension();
        for (int i = 0; i < position.size(); ++i) {
            Member match;
            Member member = position.get(i);
            if (!dimension.equals(member.getDimension()) || (match = this.searchContextMemberOfParents(member, columnIndex)) == null) continue;
            return match;
        }
        return null;
    }

    private Member searchContextMemberOfParents(Member member, int columnIndex) {
        String columnName = this.getColumnName(columnIndex);
        for (Member candidate = member; candidate != null; candidate = candidate.getParentMember()) {
            if (!candidate.getLevel().getUniqueName().equals(columnName)) continue;
            return candidate;
        }
        return null;
    }

    public void close() {
        this.resultSet.close();
    }

    public DataAttributes getCellDataAttributes(int rowIndex, int columnIndex) {
        if (columnIndex >= this.columnNames.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.isMeasureColumn(columnIndex)) {
            int[] cellKey = this.computeCellKey(rowIndex);
            Cell cell = this.resultSet.getCell(cellKey);
            return new MDXMetaDataCellAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, cell);
        }
        int[] cellKey = this.computeCellKey(rowIndex);
        Member contextMember = this.getCandidateMembers(columnIndex, cellKey);
        if (contextMember != null) {
            return new MDXMetaDataMemberAttributes((DataAttributes)EmptyDataAttributes.INSTANCE, contextMember);
        }
        return EmptyDataAttributes.INSTANCE;
    }

    private boolean isMeasureColumn(int columnIndex) {
        return columnIndex >= this.columnToMemberMapping.size();
    }

    private int[] computeCellKey(int rowIndex) {
        int[] cellKey = new int[this.axesSize.length];
        int tmpRowIdx = rowIndex;
        for (int i = 0; i < this.axesSize.length; ++i) {
            int pos;
            int axisSize = this.axesSize[i];
            if (axisSize == 0) {
                cellKey[i] = 0;
                continue;
            }
            cellKey[i] = pos = tmpRowIdx % axisSize;
            tmpRowIdx /= axisSize;
        }
        return cellKey;
    }

    public boolean isCellDataAttributesSupported() {
        return true;
    }

    public DataAttributes getColumnAttributes(int column) {
        return EmptyDataAttributes.INSTANCE;
    }

    public DataAttributes getTableAttributes() {
        DefaultDataAttributes dataAttributes = new DefaultDataAttributes();
        dataAttributes.setMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "crosstab-mode", DefaultConceptQueryMapper.INSTANCE, (Object)"normalized");
        return dataAttributes;
    }
}

