/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils.streaming;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.pentaho.di.trans.dataservice.client.api.IDataServiceClientService;
import org.pentaho.di.trans.dataservice.jdbc.api.IThinPreparedStatement;
import org.pentaho.di.trans.dataservice.jdbc.api.IThinStatement;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SQLReportDataFactory;

public class SQLStreamingReportDataFactory
extends SQLReportDataFactory {
    private static final long serialVersionUID = 1L;
    private final IDataServiceClientService.StreamingMode windowMode;
    private final long windowSize;
    private final long windowEvery;
    private final long windowLimit;

    protected IDataServiceClientService.StreamingMode getWindowMode() {
        return this.windowMode;
    }

    protected long getWindowSize() {
        return this.windowSize;
    }

    protected long getWindowEvery() {
        return this.windowEvery;
    }

    protected long getWindowLimit() {
        return this.windowLimit;
    }

    public SQLStreamingReportDataFactory(ConnectionProvider connectionProvider, IDataServiceClientService.StreamingMode windowMode, long windowSize, long windowEvery, long windowLimit) {
        super(connectionProvider);
        this.windowMode = windowMode;
        this.windowSize = windowSize;
        this.windowEvery = windowEvery;
        this.windowLimit = windowLimit;
    }

    public ResultSet performQuery(Statement statement, String translatedQuery, String[] preparedParameterNames) throws SQLException {
        ResultSet res;
        if (preparedParameterNames.length == 0) {
            res = ((IThinStatement)statement).executeQuery(translatedQuery, this.windowMode, this.windowSize, this.windowEvery, this.windowLimit);
        } else {
            IThinPreparedStatement pstmt = (IThinPreparedStatement)statement;
            res = pstmt.executeQuery(this.windowMode, this.windowSize, this.windowEvery, this.windowLimit);
        }
        return res;
    }
}

