/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import pt.webdetails.cda.connections.Connection;
import pt.webdetails.cda.dataaccess.AbstractDataAccess;
import pt.webdetails.cda.dataaccess.ColumnDefinition;
import pt.webdetails.cda.dataaccess.CompoundDataAccess;
import pt.webdetails.cda.dataaccess.DataAccess;
import pt.webdetails.cda.dataaccess.MdxDataAccess;
import pt.webdetails.cda.dataaccess.Parameter;
import pt.webdetails.cda.settings.CdaSettings;
import pt.webdetails.cda.xml.DomVisitor;

public class DomTraversalHelper {
    private Element root;

    public Document traverse(CdaSettings cda) {
        Document doc = DocumentFactory.getInstance().createDocument("UTF-8");
        doc.addElement("CDADescriptor");
        this.root = doc.getRootElement();
        Element consEle = this.root.addElement("DataSources");
        for (Map.Entry<String, Connection> pairs : cda.getConnectionsMap().entrySet()) {
            Connection con = pairs.getValue();
            con.accept(new DomVisitor(), consEle);
        }
        for (Map.Entry<String, DataAccess> pairs : cda.getDataAccessMap().entrySet()) {
            ArrayList<Parameter> params;
            DataAccess da = pairs.getValue();
            String daType = "DataAccess";
            if (da instanceof CompoundDataAccess) {
                daType = "CompoundDataAccess";
            }
            Element daEle = this.root.addElement(daType);
            da.accept(new DomVisitor(), daEle);
            ArrayList<ColumnDefinition> columns = da.getColumnDefinitions();
            if (!columns.isEmpty()) {
                Element colsEle = daEle.addElement("Columns");
                for (ColumnDefinition columnDefinition : columns) {
                    columnDefinition.accept(new DomVisitor(), colsEle);
                }
            }
            if (da instanceof AbstractDataAccess && !(params = ((AbstractDataAccess)da).getParameters()).isEmpty()) {
                Element paramsEle = daEle.addElement("Parameters");
                for (Parameter param : params) {
                    param.accept(new DomVisitor(), paramsEle);
                }
            }
            if (da instanceof MdxDataAccess && ((MdxDataAccess)da).getBandedMode().equals((Object)MdxDataAccess.BANDED_MODE.COMPACT)) {
                daEle.addElement("BandedMode").addText(MdxDataAccess.BANDED_MODE.COMPACT.name().toLowerCase());
            }
            if (da.getOutputs().isEmpty()) continue;
            String idxs = StringUtils.join((Object[])da.getOutputs().toArray(), (String)",");
            Element output = daEle.addElement("Output");
            if (da.getOutputMode().equals((Object)DataAccess.OutputMode.EXCLUDE)) {
                output.addAttribute("mode", da.getOutputMode().name().toLowerCase());
            }
            output.addAttribute("indexes", idxs);
        }
        return doc;
    }

    public void writeToOutputStream(CdaSettings cda, OutputStream out) throws IOException {
        Document doc = this.traverse(cda);
        XMLWriter writer = new XMLWriter(out);
        writer.write(doc);
    }
}

