/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.xml;

import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XmlUtils {
    private static XmlFormatter formatter = new XmlFormatter(2, 80);

    public static String formatXml(String s) {
        return formatter.format(s, 0);
    }

    public static String formatXml(String s, int initialIndent) {
        return formatter.format(s, initialIndent);
    }

    private static String buildWhitespace(int numChars) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numChars; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String prettyPrint(String xml) {
        StringWriter sw = null;
        try {
            OutputFormat format = new OutputFormat("  ", true);
            Document document = DocumentHelper.parseText((String)xml);
            sw = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            writer.write(document);
        }
        catch (Exception e) {
            System.out.println("creating beautified xml failed, refer to exc : " + e.getMessage());
        }
        return sw.toString();
    }

    private static class XmlFormatter {
        private int indentNumChars;
        private boolean singleLine;

        public XmlFormatter(int indentNumChars, int lineLength) {
            this.indentNumChars = indentNumChars;
        }

        public synchronized String format(String s, int initialIndent) {
            int indent = initialIndent;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                char currentChar = s.charAt(i);
                if (currentChar == '<') {
                    char nextChar = s.charAt(i + 1);
                    if (nextChar == '/') {
                        indent -= this.indentNumChars;
                    }
                    if (!this.singleLine) {
                        sb.append(XmlUtils.buildWhitespace(indent));
                    }
                    if (nextChar != '?' && nextChar != '!' && nextChar != '/') {
                        indent += this.indentNumChars;
                    }
                    this.singleLine = false;
                }
                sb.append(currentChar);
                if (currentChar != '>') continue;
                if (s.charAt(i - 1) == '/') {
                    indent -= this.indentNumChars;
                    sb.append("\n");
                    continue;
                }
                int nextStartElementPos = s.indexOf(60, i);
                if (nextStartElementPos > i + 1) {
                    String textBetweenElements = s.substring(i + 1, nextStartElementPos);
                    if (textBetweenElements.replaceAll("\n", "").length() == 0) {
                        sb.append(textBetweenElements + "\n");
                    }
                    sb.append(textBetweenElements);
                    i = nextStartElementPos - 1;
                    continue;
                }
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

