/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.robochef;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.Const;
import org.pentaho.di.trans.step.RowListener;
import pt.webdetails.robochef.RowProducerBridge;

public class DynamicTransConfig {
    private static final Log logger = LogFactory.getLog(DynamicTransConfig.class);
    private final Map<String, RowProducerBridge> inputs;
    private final Map<String, RowListener> outputs;
    private final EnumMap<EntryType, Map<String, String>> configEntries;
    private final AtomicBoolean frozen = new AtomicBoolean(false);

    public DynamicTransConfig() {
        this.inputs = new HashMap<String, RowProducerBridge>(2);
        this.outputs = new HashMap<String, RowListener>(1);
        this.configEntries = new EnumMap(EntryType.class);
        for (EntryType entryType : EntryType.values()) {
            this.configEntries.put(entryType, new HashMap());
        }
    }

    protected Map<String, RowProducerBridge> getFrozenInputs() {
        if (!this.frozen.get()) {
            throw new IllegalAccessError("Config is not yet frozen");
        }
        return Collections.unmodifiableMap(this.inputs);
    }

    public void addInput(String targetStepName, RowProducerBridge input) {
        if (this.frozen.get()) {
            throw new IllegalAccessError("Config is frozen");
        }
        if (Const.isEmpty((String)Const.trim((String)targetStepName))) {
            throw new IllegalArgumentException("targetStepName is null");
        }
        if (input == null) {
            throw new IllegalArgumentException("inputRowProducer is null");
        }
        this.inputs.put(targetStepName, input);
    }

    public void addInputs(Map<String, RowProducerBridge> inputs) {
        if (inputs == null) {
            throw new IllegalArgumentException("input mappings is null");
        }
        for (Map.Entry<String, RowProducerBridge> entry : inputs.entrySet()) {
            this.addInput(entry.getKey(), entry.getValue());
        }
    }

    protected Map<String, RowListener> getFrozenOutputs() {
        if (!this.frozen.get()) {
            throw new IllegalAccessError("Config is not yet frozen");
        }
        return Collections.unmodifiableMap(this.outputs);
    }

    public void addOutput(String targetStepName, RowListener output) {
        if (this.frozen.get()) {
            throw new IllegalAccessError("Config is frozen");
        }
        if (Const.isEmpty((String)Const.trim((String)targetStepName))) {
            throw new IllegalArgumentException("targetStepName is null");
        }
        if (output == null) {
            throw new IllegalArgumentException("outputListener is null");
        }
        this.outputs.put(targetStepName, output);
    }

    public void addOutputs(Map<String, RowListener> outputs) {
        if (outputs == null) {
            throw new IllegalArgumentException("output mappings is null");
        }
        for (Map.Entry<String, RowListener> entry : outputs.entrySet()) {
            this.addOutput(entry.getKey(), entry.getValue());
        }
    }

    protected Map<EntryType, Map<String, String>> getFrozenConfigEntries() {
        if (!this.frozen.get()) {
            throw new IllegalAccessError("Config is not yet frozen");
        }
        Object clone = this.configEntries.clone();
        for (Map.Entry entry : clone.entrySet()) {
            entry.setValue(Collections.unmodifiableMap((Map)entry.getValue()));
        }
        return Collections.unmodifiableMap(clone);
    }

    protected Map<String, String> getFrozenStepConfigEntries() {
        if (!this.frozen.get()) {
            throw new IllegalAccessError("Config is not yet frozen");
        }
        return Collections.unmodifiableMap(this.configEntries.get((Object)EntryType.STEP));
    }

    protected Map<String, String> getFrozenHopConfigEntries() {
        if (!this.frozen.get()) {
            throw new IllegalAccessError("Config is not yet frozen");
        }
        return Collections.unmodifiableMap(this.configEntries.get((Object)EntryType.HOP));
    }

    protected Map<String, String> getFrozenStepErrorHandlingConfigEntries() {
        if (!this.frozen.get()) {
            throw new IllegalAccessError("Config is not yet frozen");
        }
        return Collections.unmodifiableMap(this.configEntries.get((Object)EntryType.STEP_ERROR_HANDLING));
    }

    protected Map<String, String> getFrozenVariableConfigEntries() {
        if (!this.frozen.get()) {
            throw new IllegalAccessError("Config is not yet frozen");
        }
        return Collections.unmodifiableMap(this.configEntries.get((Object)EntryType.VARIABLE));
    }

    protected Map<String, String> getFrozenParameterConfigEntries() {
        if (!this.frozen.get()) {
            throw new IllegalAccessError("Config is not yet frozen");
        }
        return Collections.unmodifiableMap(this.configEntries.get((Object)EntryType.PARAMETER));
    }

    public void addConfigEntry(EntryType entryType, String key, String value) {
        if (this.frozen.get()) {
            throw new IllegalAccessError("Config is frozen");
        }
        if (entryType == null) {
            throw new IllegalArgumentException("entryType is null");
        }
        if (Const.isEmpty((String)Const.trim((String)key))) {
            throw new IllegalArgumentException(String.format("%s key is null for value %s", new Object[]{entryType, value}));
        }
        if (Const.isEmpty((String)Const.trim((String)value)) && entryType != EntryType.VARIABLE && entryType != EntryType.PARAMETER) {
            throw new IllegalArgumentException(String.format("value is required for %s key %s", new Object[]{entryType, key}));
        }
        this.configEntries.get((Object)entryType).put(key, value);
    }

    public void addConfigEntries(Map<EntryType, Map<String, String>> configEntries) {
        if (configEntries == null) {
            throw new IllegalArgumentException("configEntries is null");
        }
        for (Map.Entry<EntryType, Map<String, String>> typeEntry : configEntries.entrySet()) {
            for (Map.Entry<String, String> entry : typeEntry.getValue().entrySet()) {
                this.addConfigEntry(typeEntry.getKey(), entry.getKey(), entry.getValue());
            }
        }
    }

    public boolean freeze() {
        boolean wasUnfrozen = this.frozen.compareAndSet(false, true);
        this.validate();
        return wasUnfrozen;
    }

    private void validate() {
        if (this.inputs.size() == 0) {
            logger.warn((Object)"No inputs specified. If the transformation has no input defined elsewhere, the transformation could hang.");
        }
        if (this.outputs.size() == 0) {
            logger.warn((Object)"No outputs specified.");
        }
    }

    public static enum EntryType {
        STEP,
        HOP,
        STEP_ERROR_HANDLING,
        VARIABLE,
        PARAMETER;

    }
}

