/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsendnsca;

import com.googlecode.jsendnsca.encryption.Encryption;
import com.googlecode.jsendnsca.encryption.Encryptor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.math.IntRange;

public class NagiosSettings {
    private static final int MIN_PORT = 1;
    private static final int MAX_PORT = 65535;
    private static final String INVALID_PORT_MESSAGE = String.format("port must be between %s and %s inclusive", 1, 65535);
    private String nagiosHost = "localhost";
    private String password = "";
    private int port = 5667;
    private int timeout = 10000;
    private int connectTimeout = 5000;
    private Encryptor encryptor = Encryption.NONE.getEncryptor();

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }

    public String getNagiosHost() {
        return this.nagiosHost;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setEncryption(Encryption encryption) {
        this.encryptor = encryption.getEncryptor();
    }

    public void setEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public void setNagiosHost(String nagiosHost) {
        Validate.notEmpty((String)nagiosHost, (String)"nagiosHost cannot be null or empty");
        this.nagiosHost = nagiosHost;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        Validate.isTrue((boolean)this.validPortRange(port), (String)INVALID_PORT_MESSAGE);
        this.port = port;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 55).append((Object)this.nagiosHost).append(this.port).append((Object)this.password).append(this.timeout).append(this.connectTimeout).append((Object)this.encryptor).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NagiosSettings)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        NagiosSettings rhs = (NagiosSettings)obj;
        return new EqualsBuilder().append((Object)this.nagiosHost, (Object)rhs.nagiosHost).append(this.port, rhs.port).append((Object)this.password, (Object)rhs.password).append(this.timeout, rhs.timeout).append(this.connectTimeout, rhs.connectTimeout).append((Object)this.encryptor, (Object)rhs.encryptor).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("nagiosHost", (Object)this.nagiosHost).append("port", this.port).append("password", (Object)this.password).append("timeout", this.timeout).append("connectTimeout", this.connectTimeout).append("encryptor", (Object)StringUtils.defaultIfEmpty((String)this.encryptor.getClass().getSimpleName(), (String)"none")).toString();
    }

    private boolean validPortRange(int port) {
        return new IntRange(1, 65535).containsInteger(port);
    }
}

