/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.googledrive.vfs.ui;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class GoogleDriveFileChooserDialog
extends CustomVfsUiPanel {
    public GoogleDriveFileChooserDialog(String vfsScheme, String vfsSchemeDisplayText, VfsFileChooserDialog vfsFileChooserDialog, int flags) {
        super(vfsScheme, vfsSchemeDisplayText, vfsFileChooserDialog, flags);
    }

    public void activate() {
        try {
            this.getVfsFileChooserDialog().setRootFile(null);
            this.getVfsFileChooserDialog().setInitialFile(null);
            this.getVfsFileChooserDialog().openFileCombo.setText("googledrive://");
            this.getVfsFileChooserDialog().vfsBrowser.fileSystemTree.removeAll();
            super.activate();
            FileObject newRoot = this.resolveFile(this.getVfsFileChooserDialog().openFileCombo.getText());
            this.getVfsFileChooserDialog().vfsBrowser.resetVfsRoot(newRoot);
        }
        catch (FileSystemException e) {
            System.out.println((Object)e);
        }
    }

    public FileObject resolveFile(String fileUri) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)this.getFileSystemOptions());
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    protected FileSystemOptions getFileSystemOptions() throws FileSystemException {
        FileSystemOptions opts = new FileSystemOptions();
        return opts;
    }

    private VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }
}

