/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMap
implements Iterable<Property> {
    public static final String ACCESS_VERSION_PROP = "AccessVersion";
    public static final String TITLE_PROP = "Title";
    public static final String AUTHOR_PROP = "Author";
    public static final String COMPANY_PROP = "Company";
    public static final String DEFAULT_VALUE_PROP = "DefaultValue";
    public static final String REQUIRED_PROP = "Required";
    public static final String ALLOW_ZERO_LEN_PROP = "AllowZeroLength";
    public static final String DECIMAL_PLACES_PROP = "DecimalPlaces";
    public static final String FORMAT_PROP = "Format";
    public static final String INPUT_MASK_PROP = "InputMask";
    public static final String CAPTION_PROP = "Caption";
    public static final String VALIDATION_RULE_PROP = "ValidationRule";
    public static final String VALIDATION_TEXT_PROP = "ValidationText";
    public static final String GUID_PROP = "GUID";
    public static final String DESCRIPTION_PROP = "Description";
    private final String _mapName;
    private final short _mapType;
    private final Map<String, Property> _props = new LinkedHashMap<String, Property>();

    PropertyMap(String name, short type) {
        this._mapName = name;
        this._mapType = type;
    }

    public String getName() {
        return this._mapName;
    }

    public short getType() {
        return this._mapType;
    }

    public int getSize() {
        return this._props.size();
    }

    public boolean isEmpty() {
        return this._props.isEmpty();
    }

    public Property get(String name) {
        return this._props.get(Database.toLookupName(name));
    }

    public Object getValue(String name) {
        return this.getValue(name, null);
    }

    public Object getValue(String name, Object defaultValue) {
        Property prop = this.get(name);
        Object value = defaultValue;
        if (prop != null && prop.getValue() != null) {
            value = prop.getValue();
        }
        return value;
    }

    public void put(String name, DataType type, byte flag, Object value) {
        this._props.put(Database.toLookupName(name), new Property(name, type, flag, value));
    }

    @Override
    public Iterator<Property> iterator() {
        return this._props.values().iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("".equals(this.getName()) ? "<DEFAULT>" : this.getName()).append(" {");
        Iterator<Property> iter = this.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static final class Property {
        private final String _name;
        private final DataType _type;
        private final byte _flag;
        private final Object _value;

        private Property(String name, DataType type, byte flag, Object value) {
            this._name = name;
            this._type = type;
            this._flag = flag;
            this._value = value;
        }

        public String getName() {
            return this._name;
        }

        public DataType getType() {
            return this._type;
        }

        public Object getValue() {
            return this._value;
        }

        public String toString() {
            Object val = this.getValue();
            if (val instanceof byte[]) {
                val = ByteUtil.toHexString((byte[])val);
            }
            return this.getName() + "[" + (Object)((Object)this.getType()) + ":" + this._flag + "]=" + val;
        }
    }
}

