/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.sql.DateToStrFunction;
import org.pentaho.di.core.sql.IifFunction;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.core.sql.SQLAggregation;
import org.pentaho.di.core.sql.SQLField;
import org.pentaho.di.core.sql.SQLFields;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepAttributesInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.calculator.CalculatorMeta;
import org.pentaho.di.trans.steps.calculator.CalculatorMetaFunction;
import org.pentaho.di.trans.steps.constant.ConstantMeta;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.filterrows.FilterRowsMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByMeta;
import org.pentaho.di.trans.steps.samplerows.SampleRowsMeta;
import org.pentaho.di.trans.steps.selectvalues.SelectMetadataChange;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;
import org.pentaho.di.trans.steps.sort.SortRowsMeta;

public class SqlTransGenerator {
    private SQL sql;
    private RowMetaInterface serviceFields;
    private String injectorStepName;
    private String resultStepName;
    private int xLocation;
    private int rowLimit;
    private int serviceLimit;

    public SqlTransGenerator(SQL sql, int rowLimit) {
        this.sql = sql;
        this.rowLimit = rowLimit;
        this.serviceFields = sql.getRowMeta();
    }

    public SqlTransGenerator(SQL sql, int rowLimit, int serviceLimit) {
        this(sql, rowLimit);
        this.serviceLimit = serviceLimit;
    }

    public TransMeta generateTransMeta() throws KettleException {
        StepMeta filterStep;
        TransMeta transMeta = new TransMeta();
        StringBuilder sbsql = new StringBuilder(this.sql.getServiceName());
        sbsql.append(" - SQL - ").append(this.sql.getSqlString());
        for (int i = sbsql.length() - 1; i >= 0; --i) {
            if (sbsql.charAt(i) != '\n' && sbsql.charAt(i) != '\r') continue;
            sbsql.setCharAt(i, ' ');
        }
        transMeta.setName(sbsql.toString());
        this.xLocation = 50;
        StepMeta firstStep = this.generateInjectorStep();
        transMeta.addStep(firstStep);
        this.injectorStepName = firstStep.getName();
        StepMeta lastStep = firstStep;
        if (this.serviceLimit > 0) {
            StepMeta serviceLimitStep = this.generateLimitStep("Limit input rows", 0, this.serviceLimit);
            lastStep = this.addToTrans(serviceLimitStep, transMeta, lastStep);
        }
        lastStep = this.addToTrans(this.generateConversionStep(), transMeta, lastStep);
        List constFields = this.sql.getSelectFields().getConstantFields();
        if (!constFields.isEmpty()) {
            StepMeta constStep = this.generateConstStep(constFields);
            lastStep = this.addToTrans(constStep, transMeta, lastStep);
        }
        List iifFields = this.sql.getSelectFields().getIifFunctionFields();
        for (SQLField iifField : iifFields) {
            lastStep = this.generateIifStep(iifField, transMeta, lastStep);
        }
        if (this.sql.getWhereCondition() != null && !this.sql.getWhereCondition().isEmpty()) {
            Collection dateToStrFunctions = this.sql.getWhereCondition().getDateToStrFunctions();
            if (!dateToStrFunctions.isEmpty()) {
                StepMeta fieldCloneStep = this.generateDateToStrStep(dateToStrFunctions);
                lastStep = this.addToTrans(fieldCloneStep, transMeta, lastStep);
            }
            StepMeta filterStep2 = this.generateFilterStep(this.sql.getWhereCondition().getCondition(), false);
            lastStep = this.addToTrans(filterStep2, transMeta, lastStep);
            if (!dateToStrFunctions.isEmpty()) {
                StepMeta cleanupStep = this.generateRemoveStep(dateToStrFunctions);
                lastStep = this.addToTrans(cleanupStep, transMeta, lastStep);
            }
        }
        List aggFields = this.sql.getSelectFields().getAggregateFields();
        if (this.sql.getHavingCondition() != null) {
            List havingFields = this.sql.getHavingCondition().extractHavingFields(this.sql.getSelectFields().getFields(), aggFields, transMeta.getStepFields(lastStep));
            aggFields.addAll(havingFields);
        }
        List groupFields = this.sql.getGroupFields().getFields();
        if (aggFields.size() > 0 || groupFields.size() > 0) {
            StepMeta groupStep = this.generateGroupByStep(aggFields, groupFields, transMeta.getStepFields(lastStep));
            lastStep = this.addToTrans(groupStep, transMeta, lastStep);
        }
        if (this.sql.getOrderFields() != null) {
            iifFields = this.sql.getOrderFields().getIifFunctionFields();
            for (SQLField iifField : iifFields) {
                lastStep = this.generateIifStep(iifField, transMeta, lastStep);
            }
        }
        if (this.sql.getHavingCondition() != null && !this.sql.getHavingCondition().isEmpty()) {
            filterStep = this.generateFilterStep(this.sql.getHavingCondition().getCondition(), true);
            lastStep = this.addToTrans(filterStep, transMeta, lastStep);
        }
        if (this.sql.getSelectFields().isDistinct()) {
            filterStep = this.generateUniqueStep(transMeta.getStepFields(lastStep));
            lastStep = this.addToTrans(filterStep, transMeta, lastStep);
        }
        if (this.sql.getOrderFields() != null && !this.sql.getOrderFields().isEmpty()) {
            StepMeta sortStep = this.generateSortStep(transMeta.getStepFields(lastStep));
            lastStep = this.addToTrans(sortStep, transMeta, lastStep);
        }
        if (this.sql.getSelectFields().getFields().size() > 0) {
            lastStep = this.addToTrans(this.generateSelectStep(), transMeta, lastStep);
        }
        if (this.sql.getLimitClause() != null) {
            int limit = this.sql.getLimitValues().getLimit();
            int offset = this.sql.getLimitValues().getOffset();
            StepMeta limitStep = this.generateLimitStep("Limit rows", offset, limit);
            lastStep = this.addToTrans(limitStep, transMeta, lastStep);
        }
        if (this.rowLimit > 0) {
            StepMeta sampleStep = this.generateSampleStep();
            lastStep = this.addToTrans(sampleStep, transMeta, lastStep);
        }
        StepMeta resultStep = this.generateResultStep();
        this.resultStepName = resultStep.getName();
        lastStep = this.addToTrans(resultStep, transMeta, lastStep);
        return transMeta;
    }

    private StepMeta generateConversionStep() {
        SelectValuesMeta meta = new SelectValuesMeta();
        meta.allocate(0, 0, this.serviceFields.size());
        meta.setMeta(this.serviceFields.getValueMetaList().stream().map(valueMeta -> this.getSelectMetadataChange(meta, (ValueMetaInterface)valueMeta)).collect(Collectors.toList()).toArray(new SelectMetadataChange[this.serviceFields.size()]));
        StepMeta stepMeta = new StepMeta("Set Conversion", (StepMetaInterface)meta);
        stepMeta.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        stepMeta.setDraw(true);
        return stepMeta;
    }

    private SelectMetadataChange getSelectMetadataChange(SelectValuesMeta meta, ValueMetaInterface valueMeta) {
        SelectMetadataChange metadataChange = new SelectMetadataChange((StepAttributesInterface)meta);
        metadataChange.setName(valueMeta.getName());
        metadataChange.setConversionMask(valueMeta.getConversionMask());
        metadataChange.setType(this.getType(valueMeta));
        return metadataChange;
    }

    private int getType(ValueMetaInterface valueMeta) {
        return this.sql.getSelectFields().getAggregateFields().stream().filter(aggField -> valueMeta == aggField.getValueMeta() && valueMeta.getType() == 5 && aggField.getAggregation().equals((Object)SQLAggregation.AVG)).findFirst().map(avgSqlField -> 1).orElse(0);
    }

    private StepMeta addToTrans(StepMeta sortStep, TransMeta transMeta, StepMeta lastStep) {
        transMeta.addStep(sortStep);
        transMeta.addTransHop(new TransHopMeta(lastStep, sortStep));
        return sortStep;
    }

    private StepMeta generateIifStep(SQLField iifField, TransMeta transMeta, StepMeta lastStep) {
        CalculatorMeta falseMetaInterface;
        CalculatorMeta falseMeta;
        CalculatorMeta trueMetaInterface;
        CalculatorMeta trueMeta;
        IifFunction iif = iifField.getIif();
        FilterRowsMeta filterMeta = new FilterRowsMeta();
        filterMeta.setCondition(iifField.getIif().getSqlCondition().getCondition());
        StepMeta filterStep = new StepMeta(iifField.getExpression(), (StepMetaInterface)filterMeta);
        filterStep.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        filterStep.setDraw(true);
        lastStep = this.addToTrans(filterStep, transMeta, lastStep);
        ValueMetaInterface valueMeta = iif.getTrueValue().getValueMeta();
        if (iif.isTrueField()) {
            trueMetaInterface = trueMeta = new CalculatorMeta();
            trueMeta.allocate(1);
            CalculatorMetaFunction function = new CalculatorMetaFunction();
            function.setFieldName(Const.NVL((String)iifField.getAlias(), (String)iifField.getField()));
            function.setCalcType(2);
            function.setValueType(valueMeta.getType());
            function.setValueLength(valueMeta.getLength());
            function.setValuePrecision(valueMeta.getPrecision());
            function.setFieldA(iif.getTrueValueString());
            function.setConversionMask(valueMeta.getConversionMask());
            trueMeta.getCalculation()[0] = function;
        } else {
            trueMetaInterface = trueMeta = new ConstantMeta();
            trueMeta.allocate(1);
            trueMeta.getFieldName()[0] = Const.NVL((String)iifField.getAlias(), (String)iifField.getField());
            trueMeta.getFieldType()[0] = iif.getTrueValue().getValueMeta().getTypeDesc();
            trueMeta.getValue()[0] = iif.getTrueValue().toString();
            trueMeta.getFieldFormat()[0] = valueMeta.getConversionMask();
        }
        StepMeta trueStep = new StepMeta("TRUE: " + iifField.getExpression(), (StepMetaInterface)trueMetaInterface);
        trueStep.setLocation(this.xLocation, 50);
        trueStep.setDraw(true);
        lastStep = this.addToTrans(trueStep, transMeta, filterStep);
        valueMeta = iif.getFalseValue().getValueMeta();
        if (iif.isFalseField()) {
            falseMetaInterface = falseMeta = new CalculatorMeta();
            falseMeta.allocate(1);
            CalculatorMetaFunction function = new CalculatorMetaFunction();
            function.setFieldName(Const.NVL((String)iifField.getAlias(), (String)iifField.getField()));
            function.setCalcType(2);
            function.setValueType(valueMeta.getType());
            function.setValueLength(valueMeta.getLength());
            function.setValuePrecision(valueMeta.getPrecision());
            function.setFieldA(iif.getFalseValueString());
            function.setConversionMask(valueMeta.getConversionMask());
            falseMeta.getCalculation()[0] = function;
        } else {
            falseMetaInterface = falseMeta = new ConstantMeta();
            falseMeta.allocate(1);
            falseMeta.getFieldName()[0] = Const.NVL((String)iifField.getAlias(), (String)iifField.getField());
            falseMeta.getFieldType()[0] = iif.getFalseValue().getValueMeta().getTypeDesc();
            falseMeta.getFieldFormat()[0] = valueMeta.getConversionMask();
            falseMeta.getValue()[0] = iif.getFalseValue().toString();
        }
        StepMeta falseStep = new StepMeta("FALSE: " + iifField.getExpression(), (StepMetaInterface)falseMetaInterface);
        falseStep.setLocation(this.xLocation, 150);
        this.xLocation += 100;
        falseStep.setDraw(true);
        lastStep = this.addToTrans(falseStep, transMeta, filterStep);
        List targetStreams = filterMeta.getStepIOMeta().getTargetStreams();
        ((StreamInterface)targetStreams.get(0)).setSubject((Object)trueStep.getName());
        ((StreamInterface)targetStreams.get(1)).setSubject((Object)falseStep.getName());
        filterMeta.searchInfoAndTargetSteps(transMeta.getSteps());
        DummyTransMeta dummyMeta = new DummyTransMeta();
        StepMeta dummyStep = new StepMeta("Collect: " + iifField.getExpression(), (StepMetaInterface)dummyMeta);
        dummyStep.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        dummyStep.setDraw(true);
        lastStep = this.addToTrans(dummyStep, transMeta, trueStep);
        transMeta.addTransHop(new TransHopMeta(falseStep, dummyStep));
        return lastStep;
    }

    private StepMeta generateInjectorStep() {
        InjectorMeta meta = new InjectorMeta();
        meta.allocate(this.serviceFields.size());
        for (int i = 0; i < this.serviceFields.size(); ++i) {
            ValueMetaInterface valueMeta = this.serviceFields.getValueMeta(i);
            meta.getFieldname()[i] = valueMeta.getName();
            meta.getType()[i] = valueMeta.getType();
            meta.getLength()[i] = valueMeta.getLength();
            meta.getPrecision()[i] = valueMeta.getPrecision();
        }
        StepMeta stepMeta = new StepMeta("Injector", (StepMetaInterface)meta);
        stepMeta.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        stepMeta.setDraw(true);
        return stepMeta;
    }

    private StepMeta generateResultStep() {
        DummyTransMeta meta = new DummyTransMeta();
        StepMeta stepMeta = new StepMeta("RESULT", (StepMetaInterface)meta);
        stepMeta.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        stepMeta.setDraw(true);
        return stepMeta;
    }

    private StepMeta generateUniqueStep(RowMetaInterface rowMeta) {
        SQLFields fields = this.sql.getSelectFields();
        MemoryGroupByMeta meta = new MemoryGroupByMeta();
        meta.allocate(fields.getFields().size(), 0);
        for (int i = 0; i < fields.getFields().size(); ++i) {
            SQLField field = (SQLField)fields.getFields().get(i);
            meta.getGroupField()[i] = !Utils.isEmpty((CharSequence)field.getAlias()) && rowMeta.searchValueMeta(field.getAlias()) != null ? field.getAlias() : field.getField();
        }
        StepMeta stepMeta = new StepMeta("DISTINCT", (StepMetaInterface)meta);
        stepMeta.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        stepMeta.setDraw(true);
        return stepMeta;
    }

    private StepMeta generateSampleStep() {
        SampleRowsMeta meta = new SampleRowsMeta();
        meta.setLinesRange("1.." + this.rowLimit);
        StepMeta stepMeta = new StepMeta("Sample rows", (StepMetaInterface)meta);
        stepMeta.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        stepMeta.setDraw(true);
        return stepMeta;
    }

    private StepMeta generateLimitStep(String name, int offset, int limit) {
        SampleRowsMeta meta = new SampleRowsMeta();
        meta.setLinesRange(offset + 1 + ".." + (offset + limit));
        StepMeta stepMeta = new StepMeta(name, (StepMetaInterface)meta);
        stepMeta.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        stepMeta.setDraw(true);
        return stepMeta;
    }

    private StepMeta generateDateToStrStep(Collection<DateToStrFunction> dateToStrFunctions) {
        CalculatorMeta meta = new CalculatorMeta();
        meta.setCalculation(dateToStrFunctions.stream().map(function -> this.getDateToStrCloneMetaFunction(meta, (DateToStrFunction)function)).collect(Collectors.toList()).toArray(new CalculatorMetaFunction[dateToStrFunctions.size()]));
        StepMeta stepMeta = new StepMeta("DateToStr", (StepMetaInterface)meta);
        stepMeta.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        stepMeta.setDraw(true);
        return stepMeta;
    }

    private CalculatorMetaFunction getDateToStrCloneMetaFunction(CalculatorMeta meta, DateToStrFunction function) {
        CalculatorMetaFunction calcFunction = new CalculatorMetaFunction();
        calcFunction.setFieldName(function.getResultName());
        calcFunction.setFieldA(function.getFieldName());
        calcFunction.setConversionMask(function.getDateMask());
        calcFunction.setValueType(2);
        calcFunction.setRemovedFromResult(false);
        calcFunction.setCalcType(2);
        return calcFunction;
    }

    private StepMeta generateRemoveStep(Collection<DateToStrFunction> dateToStrFunctions) {
        SelectValuesMeta selectMeta = new SelectValuesMeta();
        String[] fieldsToDelete = dateToStrFunctions.stream().map(function -> function.getResultName()).collect(Collectors.toList()).toArray(new String[dateToStrFunctions.size()]);
        selectMeta.setDeleteName(fieldsToDelete);
        StepMeta stepMetaSelect = new StepMeta("DateToStr - Remove temporary fields", (StepMetaInterface)selectMeta);
        stepMetaSelect.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        stepMetaSelect.setDraw(true);
        return stepMetaSelect;
    }

    private StepMeta generateFilterStep(Condition condition, boolean isHaving) {
        FilterRowsMeta meta = new FilterRowsMeta();
        meta.setCondition(condition);
        StepMeta stepMeta = new StepMeta(isHaving ? "Having filter" : "Where filter", (StepMetaInterface)meta);
        stepMeta.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        stepMeta.setDraw(true);
        return stepMeta;
    }

    private StepMeta generateConstStep(List<SQLField> fields) throws KettleException {
        ConstantMeta meta = new ConstantMeta();
        meta.allocate(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            SQLField field = fields.get(i);
            ValueMetaInterface valueMeta = field.getValueMeta();
            meta.getFieldName()[i] = "Constant_" + field.getFieldIndex() + "_" + field.getField();
            meta.getFieldFormat()[i] = valueMeta.getConversionMask();
            meta.getFieldType()[i] = valueMeta.getTypeDesc();
            meta.getFieldLength()[i] = valueMeta.getLength();
            meta.getFieldPrecision()[i] = valueMeta.getPrecision();
            meta.getDecimal()[i] = valueMeta.getDecimalSymbol();
            meta.getGroup()[i] = valueMeta.getGroupingSymbol();
            meta.getValue()[i] = valueMeta.getString(field.getValueData());
        }
        StepMeta stepMeta = new StepMeta("Constants", (StepMetaInterface)meta);
        stepMeta.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        stepMeta.setDraw(true);
        return stepMeta;
    }

    private StepMeta generateGroupByStep(List<SQLField> aggFields, List<SQLField> groupFields, RowMetaInterface inputFields) throws KettleException {
        SQLField field;
        int i;
        MemoryGroupByMeta meta = new MemoryGroupByMeta();
        meta.allocate(groupFields.size(), aggFields.size());
        boolean returnRow = false;
        for (i = 0; i < groupFields.size(); ++i) {
            field = groupFields.get(i);
            meta.getGroupField()[i] = field.getField();
        }
        for (i = 0; i < aggFields.size(); ++i) {
            String subjectField;
            field = aggFields.get(i);
            ValueMetaInterface valueMeta = field.getValueMeta();
            meta.getAggregateField()[i] = Const.NVL((String)field.getAlias(), (String)field.getField());
            if (field.getValueData() == null) {
                if (valueMeta == null) {
                    if (inputFields.size() == 0) {
                        throw new KettleException("No field fields found to aggregate on.");
                    }
                    subjectField = inputFields.getValueMeta(0).getName();
                } else {
                    subjectField = valueMeta.getName();
                }
            } else {
                subjectField = "Constant_" + field.getFieldIndex() + "_" + field.getField();
            }
            meta.getSubjectField()[i] = subjectField;
            int agg = 0;
            switch (field.getAggregation()) {
                case SUM: {
                    agg = 1;
                    break;
                }
                case MIN: {
                    agg = 5;
                    break;
                }
                case MAX: {
                    agg = 6;
                    break;
                }
                case COUNT: {
                    agg = field.isCountStar() ? 16 : (field.isCountDistinct() ? 15 : 7);
                    returnRow = true;
                    break;
                }
                case AVG: {
                    agg = 2;
                    break;
                }
                default: {
                    throw new KettleException("Unhandled aggregation method [" + field.getAggregation() + "]");
                }
            }
            meta.getAggregateType()[i] = agg;
        }
        meta.setAlwaysGivingBackOneRow(returnRow);
        StepMeta stepMeta = new StepMeta("Group by", (StepMetaInterface)meta);
        stepMeta.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        stepMeta.setDraw(true);
        return stepMeta;
    }

    private StepMeta generateSortStep(RowMetaInterface rowMeta) throws KettleException {
        List fields = this.sql.getOrderFields().getFields();
        List selectFields = this.sql.getSelectFields().getFields();
        SortRowsMeta meta = new SortRowsMeta();
        meta.allocate(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            SQLField sqlField = (SQLField)fields.get(i);
            ValueMetaInterface valueMeta = rowMeta.searchValueMeta(sqlField.getField());
            if (valueMeta == null) {
                SQLField selectField = SQLField.searchSQLFieldByFieldOrAlias((List)selectFields, (String)sqlField.getField());
                valueMeta = selectField != null ? rowMeta.searchValueMeta(selectField.getField()) : rowMeta.searchValueMeta(sqlField.getAlias());
            }
            if (valueMeta == null) {
                throw new KettleException("Unable to find field to sort on: " + sqlField.getField() + " nor the alias: " + sqlField.getAlias());
            }
            meta.getFieldName()[i] = valueMeta.getName();
            meta.getAscending()[i] = sqlField.isAscending();
            meta.getCaseSensitive()[i] = true;
        }
        meta.setSortSize("1000000");
        StepMeta stepMeta = new StepMeta("Sort rows", (StepMetaInterface)meta);
        stepMeta.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        stepMeta.setDraw(true);
        return stepMeta;
    }

    private StepMeta generateSelectStep() {
        List fields = this.sql.getSelectFields().getFields();
        SelectValuesMeta meta = new SelectValuesMeta();
        meta.allocate(fields.size(), 0, 0);
        String[] selectNames = new String[fields.size()];
        String[] selectRename = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            SQLField sqlField = (SQLField)fields.get(i);
            if (sqlField.getAggregation() == null) {
                selectNames[i] = sqlField.getField();
                selectRename[i] = sqlField.getAlias();
                continue;
            }
            selectNames[i] = Const.NVL((String)sqlField.getAlias(), (String)sqlField.getField());
        }
        meta.setSelectName(selectNames);
        meta.setSelectRename(selectRename);
        StepMeta stepMeta = new StepMeta("Select values", (StepMetaInterface)meta);
        stepMeta.setLocation(this.xLocation, 50);
        this.xLocation += 100;
        stepMeta.setDraw(true);
        return stepMeta;
    }

    public SQL getSql() {
        return this.sql;
    }

    public String getInjectorStepName() {
        return this.injectorStepName;
    }

    public void setInjectorStepName(String injectorStepName) {
        this.injectorStepName = injectorStepName;
    }

    public String getResultStepName() {
        return this.resultStepName;
    }

    public void setResultStepName(String resultStepName) {
        this.resultStepName = resultStepName;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public int getServiceRowLimit() {
        return this.serviceLimit;
    }
}

