/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.serialization;

import java.util.List;
import javax.cache.Cache;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.PushDownFactory;
import org.pentaho.di.trans.dataservice.serialization.DataServiceMetaObjectFactory;
import org.pentaho.di.trans.dataservice.serialization.DataServiceMetaStoreUtil;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;

public class EmbeddedMetaStoreFactory
extends MetaStoreFactory<DataServiceMeta> {
    private final TransMeta transMeta;
    private final Cache<Integer, String> stepCache;

    public EmbeddedMetaStoreFactory(TransMeta transMeta, List<PushDownFactory> factories, Cache<Integer, String> stepCache) {
        super(DataServiceMeta.class, (IMetaStore)transMeta.getEmbeddedMetaStore(), "pentaho");
        this.transMeta = transMeta;
        this.stepCache = stepCache;
        this.setObjectFactory(new DataServiceMetaObjectFactory(factories));
    }

    public DataServiceMeta loadElement(String name) throws MetaStoreException {
        DataServiceMeta dataServiceMeta = (DataServiceMeta)super.loadElement(name);
        if (dataServiceMeta != null) {
            dataServiceMeta.setServiceTrans(this.transMeta);
            this.saveToCache(dataServiceMeta);
        }
        return dataServiceMeta;
    }

    public List<DataServiceMeta> getElements() throws MetaStoreException {
        List elements = super.getElements();
        for (DataServiceMeta dataServiceMeta : elements) {
            dataServiceMeta.setServiceTrans(this.transMeta);
            this.saveToCache(dataServiceMeta);
        }
        return elements;
    }

    public void saveElement(DataServiceMeta dataServiceMeta) throws MetaStoreException {
        super.saveElement((Object)dataServiceMeta);
        this.saveToCache(dataServiceMeta);
    }

    private void saveToCache(DataServiceMeta meta) {
        if (this.stepCache != null) {
            this.stepCache.putAll(DataServiceMetaStoreUtil.createCacheEntries(meta));
        }
    }
}

