/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.DataNodeVolumeMetrics;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.util.Time;

@InterfaceAudience.Private
class ProfilingFileIoEvents {
    static final Log LOG = LogFactory.getLog(ProfilingFileIoEvents.class);
    private final boolean isEnabled;
    private final int sampleRangeMax;

    public ProfilingFileIoEvents(@Nullable Configuration conf) {
        if (conf != null) {
            double fileIOSamplingFraction = conf.getDouble("dfs.datanode.fileio.profiling.sampling.fraction", 0.0);
            this.isEnabled = Util.isDiskStatsEnabled(fileIOSamplingFraction);
            if (fileIOSamplingFraction > 1.0) {
                LOG.warn((Object)"dfs.datanode.fileio.profiling.sampling.fraction value cannot be more than 1. Setting value to 1");
                fileIOSamplingFraction = 1.0;
            }
            this.sampleRangeMax = (int)(fileIOSamplingFraction * 2.147483647E9);
        } else {
            this.isEnabled = false;
            this.sampleRangeMax = 0;
        }
    }

    public long beforeMetadataOp(@Nullable FsVolumeSpi volume, FileIoProvider.OPERATION op) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && (metrics = this.getVolumeMetrics(volume)) != null) {
            return Time.monotonicNow();
        }
        return 0L;
    }

    public void afterMetadataOp(@Nullable FsVolumeSpi volume, FileIoProvider.OPERATION op, long begin) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && (metrics = this.getVolumeMetrics(volume)) != null) {
            metrics.addMetadastaOperationLatency(Time.monotonicNow() - begin);
        }
    }

    public long beforeFileIo(@Nullable FsVolumeSpi volume, FileIoProvider.OPERATION op, long len) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && ThreadLocalRandom.current().nextInt() < this.sampleRangeMax && (metrics = this.getVolumeMetrics(volume)) != null) {
            return Time.monotonicNow();
        }
        return 0L;
    }

    public void afterFileIo(@Nullable FsVolumeSpi volume, FileIoProvider.OPERATION op, long begin, long len) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && begin != 0L && (metrics = this.getVolumeMetrics(volume)) != null) {
            long latency = Time.monotonicNow() - begin;
            metrics.addDataFileIoLatency(latency);
            switch (op) {
                case SYNC: {
                    metrics.addSyncIoLatency(latency);
                    break;
                }
                case FLUSH: {
                    metrics.addFlushIoLatency(latency);
                    break;
                }
                case READ: {
                    metrics.addReadIoLatency(latency);
                    break;
                }
                case WRITE: {
                    metrics.addWriteIoLatency(latency);
                    break;
                }
            }
        }
    }

    public void onFailure(@Nullable FsVolumeSpi volume, long begin) {
        DataNodeVolumeMetrics metrics;
        if (this.isEnabled && (metrics = this.getVolumeMetrics(volume)) != null) {
            metrics.addFileIoError(Time.monotonicNow() - begin);
        }
    }

    private DataNodeVolumeMetrics getVolumeMetrics(FsVolumeSpi volume) {
        if (this.isEnabled && volume != null) {
            return volume.getMetrics();
        }
        return null;
    }
}

