/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;

public class ZipKieModule
extends AbstractKieModule
implements InternalKieModule {
    private final File file;
    private Map<String, byte[]> zipEntries;

    public ZipKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file) {
        super(releaseId, kieProject);
        this.file = file;
        this.zipEntries = IoUtils.indexZipFile((File)file);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isAvailable(String name) {
        return this.zipEntries.containsKey(name);
    }

    @Override
    public byte[] getBytes(String name) {
        return this.zipEntries.get(name);
    }

    @Override
    public Collection<String> getFileNames() {
        return this.zipEntries.keySet();
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getCreationTimestamp() {
        return this.file.lastModified();
    }

    public String toString() {
        return "ZipKieModule[releaseId=" + this.getReleaseId() + ",file=" + this.file + "]";
    }
}

