/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans;

import java.util.HashSet;
import java.util.Set;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class MRIntermediateDataVisitor
extends MROpPlanVisitor {
    private final Set<String> intermediate = new HashSet<String>();

    public MRIntermediateDataVisitor(MROperPlan plan) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DepthFirstWalker<MapReduceOper, MROperPlan>(plan));
    }

    public Set<String> getIntermediate() {
        return this.intermediate;
    }

    @Override
    public void visitMROp(MapReduceOper mr) throws VisitorException {
        StoreFinder finder;
        if (mr.mapPlan != null && mr.mapPlan.size() > 0) {
            finder = new StoreFinder(mr.mapPlan);
            finder.visit();
        }
        if (mr.combinePlan != null && mr.combinePlan.size() > 0) {
            finder = new StoreFinder(mr.combinePlan);
            finder.visit();
        }
        if (mr.reducePlan != null && mr.reducePlan.size() > 0) {
            finder = new StoreFinder(mr.reducePlan);
            finder.visit();
        }
    }

    class StoreFinder
    extends PhyPlanVisitor {
        protected StoreFinder(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        @Override
        public void visitStore(POStore store) {
            if (store.isTmpStore()) {
                MRIntermediateDataVisitor.this.intermediate.add(store.getSFile().getFileName());
            }
        }
    }
}

