/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util.avro;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataType;
import org.mortbay.log.Log;

public class AvroStorageSchemaConversionUtilities {
    public static byte getPigType(Schema s) throws ExecException {
        switch (s.getType()) {
            case ARRAY: {
                return 120;
            }
            case BOOLEAN: {
                return 5;
            }
            case BYTES: {
                return 50;
            }
            case DOUBLE: {
                return 25;
            }
            case ENUM: {
                return 55;
            }
            case FIXED: {
                return 50;
            }
            case FLOAT: {
                return 20;
            }
            case INT: {
                return 10;
            }
            case LONG: {
                return 15;
            }
            case MAP: {
                return 100;
            }
            case NULL: {
                return 1;
            }
            case RECORD: {
                return 110;
            }
            case STRING: {
                return 55;
            }
            case UNION: {
                List types = s.getTypes();
                if (types.size() == 1) {
                    return AvroStorageSchemaConversionUtilities.getPigType((Schema)types.get(0));
                }
                if (types.size() == 2 && ((Schema)types.get(0)).getType() == Schema.Type.NULL) {
                    return AvroStorageSchemaConversionUtilities.getPigType((Schema)types.get(1));
                }
                if (types.size() == 2 && ((Schema)types.get(1)).getType() == Schema.Type.NULL) {
                    return AvroStorageSchemaConversionUtilities.getPigType((Schema)types.get(0));
                }
                if (AvroStorageSchemaConversionUtilities.isUnionOfSimpleTypes(s)) {
                    return 50;
                }
                throw new ExecException("Currently only supports element unions of a type and null (" + s.toString() + ")");
            }
        }
        throw new ExecException("Unknown type: " + s.getType().toString());
    }

    public static boolean isUnionOfSimpleTypes(Schema s) {
        List types = s.getTypes();
        if (types == null) {
            return false;
        }
        block3: for (Schema subSchema : types) {
            switch (subSchema.getType()) {
                case BOOLEAN: 
                case BYTES: 
                case DOUBLE: 
                case ENUM: 
                case FIXED: 
                case FLOAT: 
                case INT: 
                case LONG: 
                case NULL: 
                case STRING: {
                    continue block3;
                }
            }
            return false;
        }
        return true;
    }

    public static ResourceSchema avroSchemaToResourceSchema(Schema s, Boolean allowRecursiveSchema) throws IOException {
        return AvroStorageSchemaConversionUtilities.avroSchemaToResourceSchema(s, Sets.newHashSet(), Maps.newHashMap(), allowRecursiveSchema);
    }

    private static ResourceSchema.ResourceFieldSchema fieldToResourceFieldSchema(Schema.Field f, Set<Schema> schemasInStack, Map<String, ResourceSchema> alreadyDefinedSchemas, Boolean allowRecursiveSchema) throws IOException {
        ResourceSchema.ResourceFieldSchema rf = new ResourceSchema.ResourceFieldSchema();
        rf.setName(f.name());
        Schema fieldSchema = f.schema();
        if (AvroStorageSchemaConversionUtilities.isNullableUnion(fieldSchema)) {
            fieldSchema = AvroStorageSchemaConversionUtilities.removeSimpleUnion(fieldSchema);
        }
        if (fieldSchema.getType() == Schema.Type.FIXED) {
            rf.setDescription(fieldSchema.toString());
        } else {
            rf.setDescription(f.doc());
        }
        byte pigType = AvroStorageSchemaConversionUtilities.getPigType(fieldSchema);
        rf.setType(pigType);
        block0 : switch (pigType) {
            case 120: {
                ResourceSchema bagSchema = new ResourceSchema();
                ResourceSchema.ResourceFieldSchema[] bagSchemaFields = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema()};
                bagSchemaFields[0].setType((byte)110);
                bagSchemaFields[0].setDescription(fieldSchema.getDoc());
                ResourceSchema innerResourceSchema = null;
                Schema elementSchema = fieldSchema.getElementType();
                if (AvroStorageSchemaConversionUtilities.isNullableUnion(elementSchema)) {
                    elementSchema = AvroStorageSchemaConversionUtilities.removeSimpleUnion(elementSchema);
                }
                switch (elementSchema.getType()) {
                    case ARRAY: 
                    case MAP: 
                    case RECORD: {
                        innerResourceSchema = AvroStorageSchemaConversionUtilities.avroSchemaToResourceSchema(elementSchema, schemasInStack, alreadyDefinedSchemas, allowRecursiveSchema);
                        bagSchemaFields[0].setName(elementSchema.getName());
                        break;
                    }
                    case UNION: {
                        throw new IOException("Pig cannot translate avro schemas for complex unions");
                    }
                    default: {
                        innerResourceSchema = new ResourceSchema();
                        ResourceSchema.ResourceFieldSchema[] tupleSchemaFields = new ResourceSchema.ResourceFieldSchema[]{new ResourceSchema.ResourceFieldSchema()};
                        tupleSchemaFields[0].setType(AvroStorageSchemaConversionUtilities.getPigType(elementSchema));
                        innerResourceSchema.setFields(tupleSchemaFields);
                    }
                }
                bagSchemaFields[0].setSchema(innerResourceSchema);
                bagSchema.setFields(bagSchemaFields);
                rf.setSchema(bagSchema);
                break;
            }
            case 100: {
                Schema mapAvroSchema = fieldSchema.getValueType();
                if (AvroStorageSchemaConversionUtilities.isNullableUnion(mapAvroSchema)) {
                    mapAvroSchema = AvroStorageSchemaConversionUtilities.removeSimpleUnion(mapAvroSchema);
                }
                ResourceSchema mapSchema = new ResourceSchema();
                ResourceSchema.ResourceFieldSchema[] mapSchemaFields = new ResourceSchema.ResourceFieldSchema[1];
                switch (mapAvroSchema.getType()) {
                    case RECORD: {
                        ResourceSchema innerResourceSchemaRecord = AvroStorageSchemaConversionUtilities.avroSchemaToResourceSchema(fieldSchema.getValueType(), schemasInStack, alreadyDefinedSchemas, allowRecursiveSchema);
                        mapSchemaFields[0] = new ResourceSchema.ResourceFieldSchema();
                        mapSchemaFields[0].setType((byte)110);
                        mapSchemaFields[0].setName(mapAvroSchema.getName());
                        mapSchemaFields[0].setSchema(innerResourceSchemaRecord);
                        mapSchemaFields[0].setDescription(fieldSchema.getDoc());
                        mapSchema.setFields(mapSchemaFields);
                        rf.setSchema(mapSchema);
                        break block0;
                    }
                    case ARRAY: 
                    case MAP: {
                        ResourceSchema innerResourceSchema = AvroStorageSchemaConversionUtilities.avroSchemaToResourceSchema(fieldSchema.getValueType(), schemasInStack, alreadyDefinedSchemas, allowRecursiveSchema);
                        rf.setSchema(innerResourceSchema);
                        break block0;
                    }
                }
                mapSchemaFields[0] = new ResourceSchema.ResourceFieldSchema();
                mapSchemaFields[0].setType(AvroStorageSchemaConversionUtilities.getPigType(mapAvroSchema));
                mapSchema.setFields(mapSchemaFields);
                rf.setSchema(mapSchema);
                break;
            }
            case 110: {
                if (alreadyDefinedSchemas.containsKey(fieldSchema.getFullName())) {
                    rf.setSchema(alreadyDefinedSchemas.get(fieldSchema.getFullName()));
                    break;
                }
                ResourceSchema innerResourceSchema = AvroStorageSchemaConversionUtilities.avroSchemaToResourceSchema(fieldSchema, schemasInStack, alreadyDefinedSchemas, allowRecursiveSchema);
                rf.setSchema(innerResourceSchema);
                alreadyDefinedSchemas.put(fieldSchema.getFullName(), innerResourceSchema);
            }
        }
        return rf;
    }

    private static ResourceSchema avroSchemaToResourceSchema(Schema s, Set<Schema> schemasInStack, Map<String, ResourceSchema> alreadyDefinedSchemas, Boolean allowRecursiveSchema) throws IOException {
        ResourceSchema.ResourceFieldSchema[] resourceFields = null;
        switch (s.getType()) {
            case RECORD: {
                if (schemasInStack.contains(s)) {
                    if (allowRecursiveSchema.booleanValue()) break;
                    throw new IOException("Pig found recursive schema definition while processing" + s.toString() + " encountered " + s.getFullName() + " which was already seen in this stack: " + schemasInStack.toString() + "\n");
                }
                schemasInStack.add(s);
                resourceFields = new ResourceSchema.ResourceFieldSchema[s.getFields().size()];
                for (Schema.Field f : s.getFields()) {
                    resourceFields[f.pos()] = AvroStorageSchemaConversionUtilities.fieldToResourceFieldSchema(f, schemasInStack, alreadyDefinedSchemas, allowRecursiveSchema);
                }
                schemasInStack.remove(s);
                break;
            }
            default: {
                resourceFields = new ResourceSchema.ResourceFieldSchema[1];
                Schema.Field f = new Schema.Field(s.getName(), s, s.getDoc(), null);
                resourceFields[0] = AvroStorageSchemaConversionUtilities.fieldToResourceFieldSchema(f, schemasInStack, alreadyDefinedSchemas, allowRecursiveSchema);
            }
        }
        ResourceSchema rs = new ResourceSchema();
        rs.setFields(resourceFields);
        return rs;
    }

    public static Schema resourceSchemaToAvroSchema(ResourceSchema rs, String recordName, String recordNameSpace, Map<String, List<Schema>> definedRecordNames, Boolean doubleColonsToDoubleUnderscores) throws IOException {
        if (rs == null) {
            return null;
        }
        recordName = AvroStorageSchemaConversionUtilities.toAvroName(recordName, doubleColonsToDoubleUnderscores);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        Schema newSchema = Schema.createRecord((String)recordName, null, (String)recordNameSpace, (boolean)false);
        if (rs.getFields() != null) {
            Integer i = 0;
            for (ResourceSchema.ResourceFieldSchema rfs : rs.getFields()) {
                String rfsName = AvroStorageSchemaConversionUtilities.toAvroName(rfs.getName(), doubleColonsToDoubleUnderscores);
                Schema fieldSchema = AvroStorageSchemaConversionUtilities.resourceFieldSchemaToAvroSchema(rfsName, recordNameSpace, rfs.getType(), rfs.getDescription().equals("autogenerated from Pig Field Schema") ? null : rfs.getDescription(), rfs.getSchema(), definedRecordNames, doubleColonsToDoubleUnderscores);
                fields.add(new Schema.Field(rfsName != null ? rfsName : recordName + "_" + i.toString(), fieldSchema, rfs.getDescription().equals("autogenerated from Pig Field Schema") ? null : rfs.getDescription(), null));
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            newSchema.setFields(fields);
        }
        return newSchema;
    }

    private static String toAvroName(String name, Boolean doubleColonsToDoubleUnderscores) throws IOException {
        if (name == null) {
            return null;
        }
        if (doubleColonsToDoubleUnderscores.booleanValue()) {
            name = name.replace("::", "__");
        }
        if (name.matches("[A-Za-z_][A-Za-z0-9_]*")) {
            return name;
        }
        throw new IOException("Pig Schema contains a name that is not allowed in Avro");
    }

    private static Schema createNullableUnion(Schema in) {
        return Schema.createUnion((List)Lists.newArrayList((Object[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), in}));
    }

    private static Schema createNullableUnion(Schema.Type t) {
        return AvroStorageSchemaConversionUtilities.createNullableUnion(Schema.create((Schema.Type)t));
    }

    private static Schema resourceFieldSchemaToAvroSchema(String name, String nameSpace, byte type, String description, ResourceSchema schema, Map<String, List<Schema>> definedRecordNames, Boolean doubleColonsToDoubleUnderscores) throws IOException {
        switch (type) {
            case 120: {
                Schema innerBagSchema = AvroStorageSchemaConversionUtilities.resourceSchemaToAvroSchema(schema.getFields()[0].getSchema(), name, null, definedRecordNames, doubleColonsToDoubleUnderscores);
                return AvroStorageSchemaConversionUtilities.createNullableUnion(Schema.createArray((Schema)innerBagSchema));
            }
            case 60: {
                return AvroStorageSchemaConversionUtilities.createNullableUnion(Schema.Type.STRING);
            }
            case 5: {
                return AvroStorageSchemaConversionUtilities.createNullableUnion(Schema.Type.BOOLEAN);
            }
            case 50: {
                Schema fixedSchema;
                try {
                    fixedSchema = new Schema.Parser().parse(description);
                }
                catch (Exception e) {
                    fixedSchema = null;
                }
                if (fixedSchema == null) {
                    return AvroStorageSchemaConversionUtilities.createNullableUnion(Schema.Type.BYTES);
                }
                return AvroStorageSchemaConversionUtilities.createNullableUnion(fixedSchema);
            }
            case 55: {
                return AvroStorageSchemaConversionUtilities.createNullableUnion(Schema.Type.STRING);
            }
            case 30: {
                return AvroStorageSchemaConversionUtilities.createNullableUnion(Schema.Type.LONG);
            }
            case 25: {
                return AvroStorageSchemaConversionUtilities.createNullableUnion(Schema.Type.DOUBLE);
            }
            case 20: {
                return AvroStorageSchemaConversionUtilities.createNullableUnion(Schema.Type.FLOAT);
            }
            case 10: {
                return AvroStorageSchemaConversionUtilities.createNullableUnion(Schema.Type.INT);
            }
            case 15: {
                return AvroStorageSchemaConversionUtilities.createNullableUnion(Schema.Type.LONG);
            }
            case 100: {
                byte innerType = schema.getFields()[0].getType();
                String desc = schema.getFields()[0].getDescription();
                if (desc.equals("autogenerated from Pig Field Schema")) {
                    desc = null;
                }
                Schema innerSchema = DataType.isComplex(innerType) ? AvroStorageSchemaConversionUtilities.createNullableUnion(Schema.createMap((Schema)AvroStorageSchemaConversionUtilities.resourceSchemaToAvroSchema(schema.getFields()[0].getSchema(), name, nameSpace, definedRecordNames, doubleColonsToDoubleUnderscores))) : AvroStorageSchemaConversionUtilities.createNullableUnion(Schema.createMap((Schema)AvroStorageSchemaConversionUtilities.resourceFieldSchemaToAvroSchema(name, nameSpace, innerType, desc, null, definedRecordNames, doubleColonsToDoubleUnderscores)));
                return innerSchema;
            }
            case 1: {
                return Schema.create((Schema.Type)Schema.Type.NULL);
            }
            case 110: {
                Schema returnSchema = AvroStorageSchemaConversionUtilities.createNullableUnion(AvroStorageSchemaConversionUtilities.resourceSchemaToAvroSchema(schema, name, null, definedRecordNames, doubleColonsToDoubleUnderscores));
                if (definedRecordNames.containsKey(name)) {
                    Schema cachedSchema;
                    List<Schema> schemaList = definedRecordNames.get(name);
                    boolean notfound = true;
                    Iterator<Schema> i$ = schemaList.iterator();
                    if (i$.hasNext() && returnSchema.equals((Object)(cachedSchema = i$.next()))) {
                        notfound = false;
                    }
                    if (notfound) {
                        returnSchema = AvroStorageSchemaConversionUtilities.createNullableUnion(AvroStorageSchemaConversionUtilities.resourceSchemaToAvroSchema(schema, name + "_" + new Integer(schemaList.size()).toString(), null, definedRecordNames, doubleColonsToDoubleUnderscores));
                        definedRecordNames.get(name).add(returnSchema);
                    }
                } else {
                    definedRecordNames.put(name, Lists.newArrayList((Object[])new Schema[]{returnSchema}));
                }
                return returnSchema;
            }
        }
        throw new IOException("Don't know how to encode type " + DataType.findTypeName(type) + " in schema " + (schema == null ? "" : schema.toString()) + "\n");
    }

    public static boolean isNullableUnion(Schema s) {
        return s.getType() == Schema.Type.UNION && (s.getTypes().size() == 1 || s.getTypes().size() == 2 && (((Schema)s.getTypes().get(0)).getType() == Schema.Type.NULL || ((Schema)s.getTypes().get(1)).getType() == Schema.Type.NULL));
    }

    public static Schema removeSimpleUnion(Schema s) {
        if (s.getType() == Schema.Type.UNION) {
            List types = s.getTypes();
            for (Schema t : types) {
                if (t.getType() == Schema.Type.NULL) continue;
                return t;
            }
        }
        return s;
    }

    public static Schema newSchemaFromRequiredFieldList(Schema oldSchema, LoadPushDown.RequiredFieldList rfl) {
        return AvroStorageSchemaConversionUtilities.newSchemaFromRequiredFieldList(oldSchema, rfl.getFields());
    }

    public static Schema newSchemaFromRequiredFieldList(Schema oldSchema, List<LoadPushDown.RequiredField> rfl) {
        ArrayList fields = Lists.newArrayList();
        for (LoadPushDown.RequiredField rf : rfl) {
            try {
                Schema.Field f = oldSchema.getField(rf.getAlias());
                if (f == null) {
                    return null;
                }
                try {
                    if (AvroStorageSchemaConversionUtilities.getPigType(f.schema()) != rf.getType()) {
                        return null;
                    }
                }
                catch (ExecException e) {
                    Log.warn((String)"ExecException caught in newSchemaFromRequiredFieldList", (Throwable)e);
                    return null;
                }
                if (rf.getSubFields() == null) {
                    fields.add(new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultValue()));
                    continue;
                }
                Schema innerSchema = AvroStorageSchemaConversionUtilities.newSchemaFromRequiredFieldList(f.schema(), rf.getSubFields());
                if (innerSchema == null) {
                    return null;
                }
                fields.add(new Schema.Field(f.name(), innerSchema, f.doc(), f.defaultValue()));
            }
            catch (AvroRuntimeException e) {
                return oldSchema;
            }
        }
        Schema newSchema = Schema.createRecord((String)oldSchema.getName(), (String)("subset of fields from " + oldSchema.getName() + "; " + oldSchema.getDoc()), (String)oldSchema.getNamespace(), (boolean)false);
        newSchema.setFields((List)fields);
        return newSchema;
    }
}

