/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util.avro;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.Utf8;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.avro.AvroBagWrapper;
import org.apache.pig.impl.util.avro.AvroMapWrapper;
import org.apache.pig.impl.util.avro.AvroStorageSchemaConversionUtilities;

public final class AvroTupleWrapper<T extends IndexedRecord>
implements Tuple {
    private T avroObject;

    public AvroTupleWrapper(T o) {
        this.avroObject = o;
    }

    public void write(DataOutput o) throws IOException {
        throw new IOException(this.getClass().toString() + ".write called, but not implemented yet");
    }

    public int compareTo(Object o) {
        if (o instanceof AvroTupleWrapper) {
            return GenericData.get().compare(this.avroObject, ((AvroTupleWrapper)o).avroObject, this.avroObject.getSchema());
        }
        return -1;
    }

    @Override
    public void append(Object o) {
        List fields = this.avroObject.getSchema().getFields();
        this.avroObject.put(fields.size(), o);
        Schema fieldSchema = null;
        if (o instanceof String) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.STRING);
        } else if (o instanceof Integer) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.INT);
        } else if (o instanceof Long) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.LONG);
        } else if (o instanceof Double) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.DOUBLE);
        } else if (o instanceof Float) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.FLOAT);
        } else if (o == null) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.NULL);
        } else if (o instanceof Boolean) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
        } else if (o instanceof Map) {
            fieldSchema = Schema.create((Schema.Type)Schema.Type.MAP);
        }
        Schema.Field newField = new Schema.Field("FIELD_" + fields.size(), fieldSchema, "", null);
        fields.add(newField);
        this.avroObject.getSchema().setFields(fields);
    }

    @Override
    public Object get(int pos) throws ExecException {
        Schema s = ((Schema.Field)this.avroObject.getSchema().getFields().get(pos)).schema();
        Object o = this.avroObject.get(pos);
        switch (s.getType()) {
            case STRING: {
                return o.toString();
            }
            case MAP: {
                return new AvroMapWrapper((Map)o);
            }
            case RECORD: {
                return new AvroTupleWrapper<IndexedRecord>((IndexedRecord)o);
            }
            case ENUM: {
                return o.toString();
            }
            case ARRAY: {
                return new AvroBagWrapper((GenericArray)o);
            }
            case FIXED: {
                return new DataByteArray(((GenericData.Fixed)o).bytes());
            }
            case BYTES: {
                return new DataByteArray(((ByteBuffer)o).array());
            }
            case UNION: {
                return AvroTupleWrapper.unionResolver(o);
            }
        }
        return o;
    }

    public static Object unionResolver(Object o) {
        if (o instanceof Utf8) {
            return o.toString();
        }
        if (o instanceof IndexedRecord) {
            return new AvroTupleWrapper<IndexedRecord>((IndexedRecord)o);
        }
        if (o instanceof GenericArray) {
            return new AvroBagWrapper((GenericArray)o);
        }
        if (o instanceof Map) {
            return new AvroMapWrapper((Map)o);
        }
        if (o instanceof GenericData.Fixed) {
            return new DataByteArray(((GenericData.Fixed)o).bytes());
        }
        if (o instanceof ByteBuffer) {
            return new DataByteArray(((ByteBuffer)o).array());
        }
        if (o instanceof GenericEnumSymbol) {
            return o.toString();
        }
        return o;
    }

    @Override
    public List<Object> getAll() {
        ArrayList all = Lists.newArrayList();
        for (Schema.Field f : this.avroObject.getSchema().getFields()) {
            try {
                all.add(this.get(f.pos()));
            }
            catch (ExecException e) {
                LogFactory.getLog(this.getClass()).error((Object)("could not process tuple with contents " + this.avroObject), (Throwable)e);
                return null;
            }
        }
        return all;
    }

    @Override
    public long getMemorySize() {
        return this.getMemorySize((IndexedRecord)this.avroObject);
    }

    private long getMemorySize(IndexedRecord r) {
        int total = 0;
        int bitsPerByte = 8;
        for (Schema.Field f : r.getSchema().getFields()) {
            switch (f.schema().getType()) {
                case ENUM: 
                case BOOLEAN: 
                case INT: {
                    total += 8192;
                    break;
                }
                case DOUBLE: {
                    total += 16384;
                    break;
                }
                case FLOAT: {
                    total += 8192;
                    break;
                }
                case NULL: {
                    break;
                }
                case STRING: {
                    total += ((String)r.get(f.pos())).length() * 4096;
                    break;
                }
                case BYTES: {
                    total += ((Byte[])r.get(f.pos())).length;
                    break;
                }
                case RECORD: {
                    total = (int)((long)total + new AvroTupleWrapper<IndexedRecord>((IndexedRecord)r.get(f.pos())).getMemorySize());
                    break;
                }
                case ARRAY: {
                    total = (int)((long)total + new AvroBagWrapper((GenericArray)r.get(f.pos())).getMemorySize());
                }
            }
        }
        return total;
    }

    @Override
    public byte getType(int arg0) throws ExecException {
        Schema s = ((Schema.Field)this.avroObject.getSchema().getFields().get(arg0)).schema();
        return AvroStorageSchemaConversionUtilities.getPigType(s);
    }

    @Override
    public boolean isNull(int arg0) throws ExecException {
        return this.avroObject == null || this.avroObject.get(arg0) == null;
    }

    @Override
    public void reference(Tuple arg0) {
        this.avroObject = ((AvroTupleWrapper)arg0).avroObject;
    }

    @Override
    public void set(int arg0, Object arg1) throws ExecException {
        this.avroObject.put(arg0, arg1);
    }

    @Override
    public int size() {
        return this.avroObject.getSchema().getFields().size();
    }

    @Override
    public String toDelimitedString(String arg0) throws ExecException {
        StringBuffer delimitedString = new StringBuffer();
        boolean notfirst = false;
        for (Schema.Field f : this.avroObject.getSchema().getFields()) {
            Object val;
            if (notfirst) {
                delimitedString.append(arg0);
                notfirst = true;
            }
            if ((val = this.avroObject.get(f.pos())) == null) {
                delimitedString.append("");
                continue;
            }
            delimitedString.append(val.toString());
        }
        return delimitedString.toString();
    }

    public void readFields(DataInput d) throws IOException {
        throw new IOException(this.getClass().toString() + ".readFields called but not implemented yet");
    }

    @Override
    public Iterator<Object> iterator() {
        return Iterators.transform(this.avroObject.getSchema().getFields().iterator(), (Function)new Function<Schema.Field, Object>(){

            public Object apply(Schema.Field f) {
                return AvroTupleWrapper.this.avroObject.get(f.pos());
            }
        });
    }
}

