/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.EqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanEqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanExpression;
import org.apache.pig.newplan.logical.expression.IsNullExpression;
import org.apache.pig.newplan.logical.expression.LessThanEqualExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.NotEqualExpression;
import org.apache.pig.newplan.logical.expression.NotExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.expression.RegexExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;

class NOTConversionVisitor
extends LogicalExpressionVisitor {
    boolean not = false;

    NOTConversionVisitor(OperatorPlan plan) throws FrontendException {
        super(plan, new NotConversionWalker(plan));
    }

    public void flip() {
        this.not = !this.not;
    }

    private void reset(Operator newOp, Operator oldOp) throws FrontendException {
        List<Operator> s;
        List<Operator> p = this.plan.getPredecessors(oldOp);
        if (p != null) {
            Operator[] preds;
            for (Operator pred : preds = p.toArray(new Operator[0])) {
                Pair<Integer, Integer> pos = this.plan.disconnect(pred, oldOp);
                this.plan.connect(pred, (Integer)pos.first, newOp, (Integer)pos.second);
            }
        }
        if ((s = this.plan.getSuccessors(oldOp)) != null) {
            Operator[] sucs;
            for (Operator suc : sucs = s.toArray(new Operator[0])) {
                this.plan.disconnect(oldOp, suc);
            }
        }
        this.plan.remove(oldOp);
    }

    private void insert(Operator before, Operator after) throws FrontendException {
        List<Operator> p = this.plan.getPredecessors(after);
        if (p != null) {
            Operator[] preds;
            for (Operator pred : preds = p.toArray(new Operator[0])) {
                if (pred == before) continue;
                Pair<Integer, Integer> pos = this.plan.disconnect(pred, after);
                this.plan.connect(pred, (Integer)pos.first, before, (Integer)pos.second);
            }
        }
    }

    private void remove(Operator op) throws FrontendException {
        List<Operator> s;
        List<Operator> p = this.plan.getPredecessors(op);
        if (p != null) {
            Operator[] preds;
            for (Operator pred : preds = p.toArray(new Operator[0])) {
                Pair<Integer, Integer> pos = this.plan.disconnect(pred, op);
                List<Operator> s2 = this.plan.getSuccessors(op);
                if (s2 == null) continue;
                Operator[] sucs = s2.toArray(new Operator[0]);
                for (int i = 0; i < sucs.length; ++i) {
                    this.plan.connect(pred, (Integer)pos.first + i, sucs[i], (Integer)pos.second + i);
                }
            }
        }
        if ((s = this.plan.getSuccessors(op)) != null) {
            Operator[] sucs;
            for (Operator suc : sucs = s.toArray(new Operator[0])) {
                this.plan.disconnect(op, suc);
            }
        }
        this.plan.remove(op);
    }

    @Override
    public void visit(NotExpression not) throws FrontendException {
        this.remove(not);
    }

    @Override
    public void visit(AndExpression andExpr) throws FrontendException {
        if (this.not) {
            OrExpression newExp = new OrExpression(this.plan, andExpr.getLhs(), andExpr.getRhs());
            this.reset(newExp, andExpr);
        }
    }

    @Override
    public void visit(OrExpression orExpr) throws FrontendException {
        if (this.not) {
            AndExpression newExp = new AndExpression(this.plan, orExpr.getLhs(), orExpr.getRhs());
            this.reset(newExp, orExpr);
        }
    }

    @Override
    public void visit(EqualExpression equal) throws FrontendException {
        if (this.not) {
            NotEqualExpression newExp = new NotEqualExpression(this.plan, equal.getLhs(), equal.getRhs());
            this.reset(newExp, equal);
        }
    }

    @Override
    public void visit(NotEqualExpression op) throws FrontendException {
        if (this.not) {
            EqualExpression newExp = new EqualExpression(this.plan, op.getLhs(), op.getRhs());
            this.reset(newExp, op);
        }
    }

    @Override
    public void visit(IsNullExpression op) throws FrontendException {
        if (this.not) {
            NotExpression newExp = new NotExpression(this.plan, op);
            this.insert(newExp, op);
        }
    }

    @Override
    public void visit(RegexExpression op) throws FrontendException {
        if (this.not) {
            NotExpression newExp = new NotExpression(this.plan, op);
            this.insert(newExp, op);
        }
    }

    @Override
    public void visit(UserFuncExpression op) throws FrontendException {
        if (this.not) {
            NotExpression newExp = new NotExpression(this.plan, op);
            this.insert(newExp, op);
        }
    }

    @Override
    public void visit(GreaterThanExpression greaterThanExpression) throws FrontendException {
        if (this.not) {
            this.reset(new LessThanEqualExpression(this.plan, greaterThanExpression.getLhs(), greaterThanExpression.getRhs()), greaterThanExpression);
        }
    }

    @Override
    public void visit(GreaterThanEqualExpression greaterThanEqualExpression) throws FrontendException {
        if (this.not) {
            this.reset(new LessThanExpression(this.plan, greaterThanEqualExpression.getLhs(), greaterThanEqualExpression.getRhs()), greaterThanEqualExpression);
        }
    }

    @Override
    public void visit(LessThanExpression lessThanExpression) throws FrontendException {
        if (this.not) {
            this.reset(new GreaterThanEqualExpression(this.plan, lessThanExpression.getLhs(), lessThanExpression.getRhs()), lessThanExpression);
        }
    }

    @Override
    public void visit(LessThanEqualExpression lessThanEqualExpression) throws FrontendException {
        if (this.not) {
            this.reset(new GreaterThanExpression(this.plan, lessThanEqualExpression.getLhs(), lessThanEqualExpression.getRhs()), lessThanEqualExpression);
        }
    }

    private static class NotConversionWalker
    extends PlanWalker {
        public NotConversionWalker(OperatorPlan plan) {
            super(plan);
        }

        @Override
        public PlanWalker spawnChildWalker(OperatorPlan plan) {
            return new NotConversionWalker(plan);
        }

        @Override
        public void walk(PlanVisitor visitor) throws FrontendException {
            List<Operator> roots = this.plan.getSources();
            HashSet<Operator> seen = new HashSet<Operator>();
            this.depthFirst(null, roots, seen, visitor);
        }

        private void depthFirst(Operator node, Collection<Operator> successors, Set<Operator> seen, PlanVisitor visitor) throws FrontendException {
            Operator[] sucs;
            if (successors == null) {
                return;
            }
            for (Operator suc : sucs = successors.toArray(new Operator[0])) {
                if (!seen.add(suc)) continue;
                if (suc instanceof NotExpression) {
                    ((NOTConversionVisitor)visitor).flip();
                }
                if (suc instanceof AndExpression || suc instanceof NotExpression || suc instanceof OrExpression) {
                    Collection<Operator> newSuccessors = Utils.mergeCollection(this.plan.getSuccessors(suc), this.plan.getSoftLinkSuccessors(suc));
                    this.depthFirst(suc, newSuccessors, seen, visitor);
                }
                suc.accept(visitor);
                if (!(suc instanceof NotExpression)) continue;
                ((NOTConversionVisitor)visitor).flip();
            }
        }
    }
}

