/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.CatalogHelper;
import org.apache.camel.catalog.CollectionStringBuffer;
import org.apache.camel.catalog.EndpointValidationResult;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.apache.camel.catalog.SimpleValidationResult;
import org.apache.camel.catalog.SuggestionStrategy;
import org.apache.camel.catalog.TimePatternConverter;
import org.apache.camel.catalog.URISupport;
import org.apache.camel.catalog.VersionHelper;
import org.w3c.dom.Document;

public class DefaultCamelCatalog
implements CamelCatalog {
    private static final String MODELS_CATALOG = "org/apache/camel/catalog/models.properties";
    private static final String COMPONENTS_CATALOG = "org/apache/camel/catalog/components.properties";
    private static final String DATA_FORMATS_CATALOG = "org/apache/camel/catalog/dataformats.properties";
    private static final String LANGUAGE_CATALOG = "org/apache/camel/catalog/languages.properties";
    private static final String MODEL_JSON = "org/apache/camel/catalog/models";
    private static final String COMPONENTS_JSON = "org/apache/camel/catalog/components";
    private static final String DATA_FORMATS_JSON = "org/apache/camel/catalog/dataformats";
    private static final String LANGUAGE_JSON = "org/apache/camel/catalog/languages";
    private static final String ARCHETYPES_CATALOG = "org/apache/camel/catalog/archetypes/archetype-catalog.xml";
    private static final String SCHEMAS_XML = "org/apache/camel/catalog/schemas";
    private static final Pattern SYNTAX_PATTERN = Pattern.compile("(\\w+)");
    private final VersionHelper version = new VersionHelper();
    private final Map<String, String> extraComponents = new HashMap<String, String>();
    private final Map<String, String> extraDataFormats = new HashMap<String, String>();
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private boolean caching;
    private SuggestionStrategy suggestionStrategy;

    public DefaultCamelCatalog() {
    }

    public DefaultCamelCatalog(boolean caching) {
        this.caching = caching;
    }

    @Override
    public void enableCache() {
        this.caching = true;
    }

    @Override
    public void setSuggestionStrategy(SuggestionStrategy suggestionStrategy) {
        this.suggestionStrategy = suggestionStrategy;
    }

    @Override
    public void addComponent(String name, String className) {
        this.extraComponents.put(name, className);
        this.cache.remove("findComponentNames");
        this.cache.remove("findComponentLabels");
        this.cache.remove("listComponentsAsJson");
    }

    @Override
    public void addDataFormat(String name, String className) {
        this.extraDataFormats.put(name, className);
        this.cache.remove("findDataFormatNames");
        this.cache.remove("findDataFormatLabels");
        this.cache.remove("listDataFormatsAsJson");
    }

    @Override
    public String getCatalogVersion() {
        return this.version.getVersion();
    }

    @Override
    public List<String> findComponentNames() {
        ArrayList<String> names = null;
        if (this.caching) {
            names = (ArrayList<String>)this.cache.get("findComponentNames");
        }
        if (names == null) {
            names = new ArrayList<String>();
            InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(COMPONENTS_CATALOG);
            if (is != null) {
                try {
                    CatalogHelper.loadLines(is, names);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            for (Map.Entry<String, String> entry : this.extraComponents.entrySet()) {
                names.add(entry.getKey());
            }
            Collections.sort(names);
            if (this.caching) {
                this.cache.put("findComponentNames", names);
            }
        }
        return names;
    }

    @Override
    public List<String> findDataFormatNames() {
        ArrayList<String> names = null;
        if (this.caching) {
            names = (ArrayList<String>)this.cache.get("findDataFormatNames");
        }
        if (names == null) {
            names = new ArrayList<String>();
            InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(DATA_FORMATS_CATALOG);
            if (is != null) {
                try {
                    CatalogHelper.loadLines(is, names);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            for (Map.Entry<String, String> entry : this.extraDataFormats.entrySet()) {
                names.add(entry.getKey());
            }
            Collections.sort(names);
            if (this.caching) {
                this.cache.put("findDataFormatNames", names);
            }
        }
        return names;
    }

    @Override
    public List<String> findLanguageNames() {
        ArrayList<String> names = null;
        if (this.caching) {
            names = (ArrayList<String>)this.cache.get("findLanguageNames");
        }
        if (names == null) {
            names = new ArrayList<String>();
            InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(LANGUAGE_CATALOG);
            if (is != null) {
                try {
                    CatalogHelper.loadLines(is, names);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put("findLanguageNames", names);
            }
        }
        return names;
    }

    @Override
    public List<String> findModelNames() {
        ArrayList<String> names = null;
        if (this.caching) {
            names = (ArrayList<String>)this.cache.get("findModelNames");
        }
        if (names == null) {
            names = new ArrayList<String>();
            InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(MODELS_CATALOG);
            if (is != null) {
                try {
                    CatalogHelper.loadLines(is, names);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put("findModelNames", names);
            }
        }
        return names;
    }

    @Override
    public List<String> findModelNames(String filter) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = this.findModelNames();
        for (String name : names) {
            String json = this.modelJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    try {
                        if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard(part, filter) && !part.matches(filter)) continue;
                        answer.add(name);
                    }
                    catch (PatternSyntaxException e) {
                        // empty catch block
                    }
                }
            }
        }
        return answer;
    }

    @Override
    public List<String> findComponentNames(String filter) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = this.findComponentNames();
        for (String name : names) {
            String json = this.componentJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    try {
                        if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard(part, filter) && !part.matches(filter)) continue;
                        answer.add(name);
                    }
                    catch (PatternSyntaxException e) {
                        // empty catch block
                    }
                }
            }
        }
        return answer;
    }

    @Override
    public List<String> findDataFormatNames(String filter) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = this.findDataFormatNames();
        for (String name : names) {
            String json = this.dataFormatJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("dataformat", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    try {
                        if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard(part, filter) && !part.matches(filter)) continue;
                        answer.add(name);
                    }
                    catch (PatternSyntaxException e) {
                        // empty catch block
                    }
                }
            }
        }
        return answer;
    }

    @Override
    public List<String> findLanguageNames(String filter) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = this.findLanguageNames();
        for (String name : names) {
            String json = this.languageJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    try {
                        if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard(part, filter) && !part.matches(filter)) continue;
                        answer.add(name);
                    }
                    catch (PatternSyntaxException e) {
                        // empty catch block
                    }
                }
            }
        }
        return answer;
    }

    @Override
    public String modelJSonSchema(String name) {
        String file = "org/apache/camel/catalog/models/" + name + ".json";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("model-" + file);
        }
        if (answer == null) {
            InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put("model-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String componentJSonSchema(String name) {
        String file = "org/apache/camel/catalog/components/" + name + ".json";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("component-" + file);
        }
        if (answer == null) {
            InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException e) {}
            } else {
                String className = this.extraComponents.get(name);
                if (className != null) {
                    String packageName = className.substring(0, className.lastIndexOf(46));
                    packageName = packageName.replace('.', '/');
                    String path = packageName + "/" + name + ".json";
                    is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(path);
                    if (is != null) {
                        try {
                            answer = CatalogHelper.loadText(is);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.caching) {
                this.cache.put("component-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String dataFormatJSonSchema(String name) {
        String file = "org/apache/camel/catalog/dataformats/" + name + ".json";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("dataformat-" + file);
        }
        if (answer == null) {
            InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException e) {}
            } else {
                String className = this.extraDataFormats.get(name);
                if (className != null) {
                    String packageName = className.substring(0, className.lastIndexOf(46));
                    packageName = packageName.replace('.', '/');
                    String path = packageName + "/" + name + ".json";
                    is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(path);
                    if (is != null) {
                        try {
                            answer = CatalogHelper.loadText(is);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.caching) {
                this.cache.put("dataformat-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public String languageJSonSchema(String name) {
        if ("method".equals(name)) {
            name = "bean";
        }
        String file = "org/apache/camel/catalog/languages/" + name + ".json";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("language-" + file);
        }
        if (answer == null) {
            InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put("language-" + file, answer);
            }
        }
        return answer;
    }

    @Override
    public Set<String> findModelLabels() {
        TreeSet<String> answer = null;
        if (this.caching) {
            answer = (TreeSet<String>)this.cache.get("findModelLabels");
        }
        if (answer == null) {
            answer = new TreeSet<String>();
            List<String> names = this.findModelNames();
            for (String name : names) {
                String json = this.modelJSonSchema(name);
                if (json == null) continue;
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
                for (Map<String, String> row : rows) {
                    String[] parts;
                    if (!row.containsKey("label")) continue;
                    String label = row.get("label");
                    for (String part : parts = label.split(",")) {
                        answer.add(part);
                    }
                }
            }
            if (this.caching) {
                this.cache.put("findModelLabels", answer);
            }
        }
        return answer;
    }

    @Override
    public Set<String> findComponentLabels() {
        TreeSet<String> answer = null;
        if (this.caching) {
            answer = (TreeSet<String>)this.cache.get("findComponentLabels");
        }
        if (answer == null) {
            answer = new TreeSet<String>();
            List<String> names = this.findComponentNames();
            for (String name : names) {
                String json = this.componentJSonSchema(name);
                if (json == null) continue;
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
                for (Map<String, String> row : rows) {
                    String[] parts;
                    if (!row.containsKey("label")) continue;
                    String label = row.get("label");
                    for (String part : parts = label.split(",")) {
                        answer.add(part);
                    }
                }
            }
            if (this.caching) {
                this.cache.put("findComponentLabels", answer);
            }
        }
        return answer;
    }

    @Override
    public Set<String> findDataFormatLabels() {
        TreeSet<String> answer = null;
        if (this.caching) {
            answer = (TreeSet<String>)this.cache.get("findDataFormatLabels");
        }
        if (answer == null) {
            answer = new TreeSet<String>();
            List<String> names = this.findDataFormatNames();
            for (String name : names) {
                String json = this.dataFormatJSonSchema(name);
                if (json == null) continue;
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("dataformat", json, false);
                for (Map<String, String> row : rows) {
                    String[] parts;
                    if (!row.containsKey("label")) continue;
                    String label = row.get("label");
                    for (String part : parts = label.split(",")) {
                        answer.add(part);
                    }
                }
            }
            if (this.caching) {
                this.cache.put("findDataFormatLabels", answer);
            }
        }
        return answer;
    }

    @Override
    public Set<String> findLanguageLabels() {
        TreeSet<String> answer = null;
        if (this.caching) {
            answer = (TreeSet<String>)this.cache.get("findLanguageLabels");
        }
        if (answer == null) {
            answer = new TreeSet<String>();
            List<String> names = this.findLanguageNames();
            for (String name : names) {
                String json = this.languageJSonSchema(name);
                if (json == null) continue;
                List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", json, false);
                for (Map<String, String> row : rows) {
                    String[] parts;
                    if (!row.containsKey("label")) continue;
                    String label = row.get("label");
                    for (String part : parts = label.split(",")) {
                        answer.add(part);
                    }
                }
            }
            if (this.caching) {
                this.cache.put("findLanguageLabels", answer);
            }
        }
        return answer;
    }

    @Override
    public String archetypeCatalogAsXml() {
        String file = ARCHETYPES_CATALOG;
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get(file);
        }
        if (answer == null) {
            InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put(file, answer);
            }
        }
        return answer;
    }

    @Override
    public String springSchemaAsXml() {
        String file = "org/apache/camel/catalog/schemas/camel-spring.xsd";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get(file);
        }
        if (answer == null) {
            InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put(file, answer);
            }
        }
        return answer;
    }

    @Override
    public String blueprintSchemaAsXml() {
        String file = "org/apache/camel/catalog/schemas/camel-blueprint.xsd";
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get(file);
        }
        if (answer == null) {
            InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
            if (is != null) {
                try {
                    answer = CatalogHelper.loadText(is);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (this.caching) {
                this.cache.put(file, answer);
            }
        }
        return answer;
    }

    @Override
    public boolean validateTimePattern(String pattern) {
        return DefaultCamelCatalog.validateInteger(pattern);
    }

    @Override
    public EndpointValidationResult validateEndpointProperties(String uri) {
        return this.validateEndpointProperties(uri, false);
    }

    @Override
    public EndpointValidationResult validateEndpointProperties(String uri, boolean ignoreLenientProperties) {
        String string;
        List<Map<String, String>> dfRows;
        String dfName;
        Map<String, String> properties;
        boolean lenientProperties;
        List<Map<String, String>> rows;
        String scheme;
        EndpointValidationResult result = new EndpointValidationResult(uri);
        try {
            URI u = URISupport.normalizeUri(uri);
            scheme = u.getScheme();
            String string2 = this.componentJSonSchema(scheme);
            if (string2 == null) {
                if (uri.startsWith("{{")) {
                    result.addIncapable(uri);
                } else if (scheme != null) {
                    result.addUnknownComponent(scheme);
                } else {
                    result.addUnknownComponent(uri);
                }
                return result;
            }
            rows = JSonSchemaHelper.parseJsonSchema("component", string2, false);
            lenientProperties = !ignoreLenientProperties && JSonSchemaHelper.isComponentLenientProperties(rows);
            rows = JSonSchemaHelper.parseJsonSchema("properties", string2, true);
            properties = this.endpointProperties(uri);
        }
        catch (URISyntaxException e) {
            if (uri.startsWith("{{")) {
                result.addIncapable(uri);
            } else {
                result.addSyntaxError(e.getMessage());
            }
            return result;
        }
        if ("dataformat".equals(scheme) && (dfName = properties.get("name")) != null && (dfRows = JSonSchemaHelper.parseJsonSchema("properties", string = this.dataFormatJSonSchema(dfName), true)) != null && !dfRows.isEmpty()) {
            rows.addAll(dfRows);
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            boolean valid;
            boolean required;
            String value = entry.getValue();
            String originalName = entry.getKey();
            String name = entry.getKey();
            String propertyName = JSonSchemaHelper.getPropertyNameFromNameWithPrefix(rows, name = JSonSchemaHelper.stripOptionalPrefixFromName(rows, name));
            if (propertyName != null) {
                name = propertyName;
            }
            String prefix = JSonSchemaHelper.getPropertyPrefix(rows, name);
            String kind = JSonSchemaHelper.getPropertyKind(rows, name);
            boolean namePlaceholder = name.startsWith("{{") && name.endsWith("}}");
            boolean valuePlaceholder = value.startsWith("{{") || value.startsWith("${") || value.startsWith("$simple{");
            boolean lookup = value.startsWith("#") && value.length() > 1;
            boolean mulitValue = prefix != null && originalName.startsWith(prefix) && JSonSchemaHelper.isPropertyMultiValue(rows, name);
            Map<String, String> row = JSonSchemaHelper.getRow(rows, name);
            if (row == null) {
                String[] suggestions;
                if (namePlaceholder || lenientProperties || "stub".equals(scheme)) continue;
                result.addUnknown(name);
                if (this.suggestionStrategy == null || (suggestions = this.suggestionStrategy.suggestEndpointOptions(JSonSchemaHelper.getNames(rows), name)) == null) continue;
                result.addUnknownSuggestions(name, suggestions);
                continue;
            }
            String defaultValue = JSonSchemaHelper.getPropertyDefaultValue(rows, name);
            if (defaultValue != null) {
                result.addDefaultValue(name, defaultValue);
            }
            if ((required = JSonSchemaHelper.isPropertyRequired(rows, name)) && URISupport.isEmpty(value)) {
                result.addRequired(name);
            }
            String enums = JSonSchemaHelper.getPropertyEnum(rows, name);
            if (!(mulitValue || valuePlaceholder || lookup || enums == null)) {
                String[] choices = enums.split(",");
                boolean found = false;
                for (String s : choices) {
                    if (!value.equalsIgnoreCase(s)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    result.addInvalidEnum(name, value);
                    result.addInvalidEnumChoices(name, choices);
                    if (this.suggestionStrategy != null) {
                        LinkedHashSet<String> names = new LinkedHashSet<String>();
                        names.addAll(Arrays.asList(choices));
                        String[] suggestions = this.suggestionStrategy.suggestEndpointOptions(names, value);
                        if (suggestions != null) {
                            result.addInvalidEnumSuggestions(name, suggestions);
                        }
                    }
                }
            }
            if (!(mulitValue || "path".equals(kind) || !JSonSchemaHelper.isPropertyObject(rows, name) || value.startsWith("#") && value.length() > 1)) {
                result.addInvalidReference(name, value);
            }
            if (!mulitValue && !valuePlaceholder && !lookup && JSonSchemaHelper.isPropertyBoolean(rows, name)) {
                boolean bool;
                boolean bl = bool = "true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value);
                if (!bool) {
                    result.addInvalidBoolean(name, value);
                }
            }
            if (!(mulitValue || valuePlaceholder || lookup || !JSonSchemaHelper.isPropertyInteger(rows, name) || (valid = DefaultCamelCatalog.validateInteger(value)))) {
                result.addInvalidInteger(name, value);
            }
            if (mulitValue || valuePlaceholder || lookup || !JSonSchemaHelper.isPropertyNumber(rows, name)) continue;
            valid = false;
            try {
                valid = !Double.valueOf(value).isNaN() || !Float.valueOf(value).isNaN();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (valid) continue;
            result.addInvalidNumber(name, value);
        }
        for (Map map : rows) {
            String name = (String)map.get("name");
            boolean required = JSonSchemaHelper.isPropertyRequired(rows, name);
            if (!required) continue;
            String value = properties.get(name);
            if (URISupport.isEmpty(value)) {
                value = JSonSchemaHelper.getPropertyDefaultValue(rows, name);
            }
            if (!URISupport.isEmpty(value)) continue;
            result.addRequired(name);
        }
        return result;
    }

    private static boolean validateInteger(String value) {
        boolean valid = false;
        try {
            valid = Integer.valueOf(value) != null;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!valid) {
            try {
                TimePatternConverter.toMilliSeconds(value);
                valid = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return valid;
    }

    @Override
    public Map<String, String> endpointProperties(String uri) throws URISyntaxException {
        String value;
        int idx;
        URI u = URISupport.normalizeUri(uri);
        String scheme = u.getScheme();
        String json = this.componentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Cannot find endpoint with scheme " + scheme);
        }
        String syntax = null;
        String alternativeSyntax = null;
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
        for (Map<String, String> row : rows) {
            if (row.containsKey("syntax")) {
                syntax = row.get("syntax");
            }
            if (!row.containsKey("alternativeSyntax")) continue;
            alternativeSyntax = row.get("alternativeSyntax");
        }
        if (syntax == null) {
            throw new IllegalArgumentException("Endpoint with scheme " + scheme + " has no syntax defined in the json schema");
        }
        LinkedHashMap<String, String> userInfoOptions = new LinkedHashMap<String, String>();
        if (alternativeSyntax != null && alternativeSyntax.contains("@")) {
            alternativeSyntax = CatalogHelper.after(alternativeSyntax, ":");
            int idx2 = alternativeSyntax.indexOf("@");
            String fields = alternativeSyntax.substring(0, idx2);
            String[] names = fields.split(":");
            String authority = u.getAuthority();
            if (authority != null && authority.contains("@")) {
                String username = null;
                String password = null;
                String userInfo = authority.substring(0, authority.indexOf("@"));
                String[] parts = userInfo.split(":");
                if (parts.length == 2) {
                    username = parts[0];
                    password = parts[1];
                } else {
                    username = userInfo;
                }
                if (names.length == 2) {
                    userInfoOptions.put(names[0], username);
                    if (password != null) {
                        userInfoOptions.put(names[1], password);
                    }
                }
            }
        }
        syntax = CatalogHelper.after(syntax, ":");
        uri = CatalogHelper.after(uri, ":");
        String uriPath = URISupport.stripQuery(uri);
        if (!userInfoOptions.isEmpty() && (idx = uriPath.indexOf(64)) > -1) {
            uriPath = uriPath.substring(idx + 1);
        }
        if (uriPath != null && uriPath.startsWith("//")) {
            uriPath = uriPath.substring(2);
        }
        Matcher matcher = SYNTAX_PATTERN.matcher(syntax);
        ArrayList<String> word = new ArrayList<String>();
        while (matcher.find()) {
            String s = matcher.group(1);
            if (scheme.equals(s)) continue;
            word.add(s);
        }
        String[] tokens = SYNTAX_PATTERN.split(syntax);
        ArrayList<String> word2 = new ArrayList<String>();
        int prev = 0;
        int prevPath = 0;
        if (("activemq".equals(scheme) || "jms".equals(scheme)) && uriPath.startsWith("temp:")) {
            prevPath = 5;
        }
        for (String token : tokens) {
            if (token.isEmpty()) continue;
            int idx3 = -1;
            int len = 0;
            if (":".equals(token)) {
                idx3 = uriPath.indexOf("://", prevPath);
                len = 3;
            }
            if (idx3 == -1) {
                idx3 = uriPath.indexOf(token, prevPath);
                len = token.length();
            }
            if (idx3 <= 0) continue;
            String option = uriPath.substring(prev, idx3);
            word2.add(option);
            prevPath = prev = idx3 + len;
        }
        if (prev > 0 || word2.isEmpty()) {
            String option = uriPath.substring(prev);
            word2.add(option);
        }
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        boolean defaultValueAdded = false;
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        if (!userInfoOptions.isEmpty()) {
            options.putAll(userInfoOptions);
        }
        Iterator it = word2.iterator();
        for (int i = 0; i < word.size(); ++i) {
            String value2;
            String key = (String)word.get(i);
            boolean allOptions = word.size() == word2.size();
            boolean required = JSonSchemaHelper.isPropertyRequired(rows, key);
            String defaultValue = JSonSchemaHelper.getPropertyDefaultValue(rows, key);
            if (allOptions) {
                value2 = (String)it.next();
                options.put(key, value2);
                continue;
            }
            if (!required) {
                boolean last;
                value2 = null;
                boolean bl = last = i == word.size() - 1;
                if (last) {
                    String string = value2 = it.hasNext() ? (String)it.next() : null;
                    if (value2 != null) {
                        options.put(key, value2);
                    } else {
                        value2 = defaultValue;
                    }
                }
                if (value2 == null) continue;
                options.put(key, value2);
                defaultValueAdded = true;
                continue;
            }
            String string = value2 = it.hasNext() ? (String)it.next() : null;
            if (value2 == null) continue;
            options.put(key, value2);
        }
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (Map.Entry entry : options.entrySet()) {
            String key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (defaultValueAdded) {
                boolean required = JSonSchemaHelper.isPropertyRequired(rows, key);
                String defaultValue = JSonSchemaHelper.getPropertyDefaultValue(rows, key);
                if (!required && defaultValue != null && defaultValue.equals(value)) continue;
            }
            answer.put(key, value);
        }
        Map<String, Object> parameters = URISupport.parseParameters(u);
        while (!parameters.isEmpty()) {
            Map.Entry<String, Object> entry = parameters.entrySet().iterator().next();
            String key = entry.getKey();
            value = entry.getValue() != null ? entry.getValue().toString() : "";
            boolean multiValued = JSonSchemaHelper.isPropertyMultiValue(rows, key);
            if (multiValued) {
                String prefix = JSonSchemaHelper.getPropertyPrefix(rows, key);
                Map<String, Object> values = URISupport.extractProperties(parameters, prefix);
                CollectionStringBuffer csb = new CollectionStringBuffer("&");
                for (Map.Entry<String, Object> multi : values.entrySet()) {
                    String line = prefix + multi.getKey() + "=" + (multi.getValue() != null ? multi.getValue().toString() : "");
                    csb.append(line);
                }
                if (!csb.isEmpty()) {
                    value = value + "&" + csb.toString();
                }
            }
            answer.put(key, value);
            parameters.remove(key);
        }
        return answer;
    }

    @Override
    public String endpointComponentName(String uri) {
        int idx;
        if (uri != null && (idx = uri.indexOf(":")) > 0) {
            return uri.substring(0, idx);
        }
        return null;
    }

    @Override
    public String asEndpointUri(String scheme, String json, boolean encode) throws URISyntaxException {
        return this.doAsEndpointUri(scheme, json, "&", encode);
    }

    @Override
    public String asEndpointUriXml(String scheme, String json, boolean encode) throws URISyntaxException {
        return this.doAsEndpointUri(scheme, json, "&amp;", encode);
    }

    private String doAsEndpointUri(String scheme, String json, String ampersand, boolean encode) throws URISyntaxException {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        HashMap<String, String> copy = new HashMap<String, String>();
        for (Map<String, String> row : rows) {
            String name = row.get("name");
            String required = row.get("required");
            String value = row.get("value");
            String defaultValue = row.get("defaultValue");
            String valueToAdd = null;
            if ("true".equals(required)) {
                String string = valueToAdd = value != null ? value : defaultValue;
                if (valueToAdd == null) {
                    valueToAdd = "";
                }
            } else {
                if (value != null && defaultValue == null) {
                    valueToAdd = value;
                }
                if (value != null && defaultValue != null && !value.equals(defaultValue)) {
                    valueToAdd = value;
                }
            }
            if (valueToAdd == null) continue;
            copy.put(name, valueToAdd);
        }
        return this.doAsEndpointUri(scheme, copy, ampersand, encode);
    }

    @Override
    public String asEndpointUri(String scheme, Map<String, String> properties, boolean encode) throws URISyntaxException {
        return this.doAsEndpointUri(scheme, properties, "&", encode);
    }

    @Override
    public String asEndpointUriXml(String scheme, Map<String, String> properties, boolean encode) throws URISyntaxException {
        return this.doAsEndpointUri(scheme, properties, "&amp;", encode);
    }

    private String doAsEndpointUri(String scheme, Map<String, String> properties, String ampersand, boolean encode) throws URISyntaxException {
        String json = this.componentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Cannot find endpoint with scheme " + scheme);
        }
        String syntax = null;
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
        for (Map<String, String> row : rows) {
            if (!row.containsKey("syntax")) continue;
            syntax = row.get("syntax");
            break;
        }
        if (syntax == null) {
            throw new IllegalArgumentException("Endpoint with scheme " + scheme + " has no syntax defined in the json schema");
        }
        properties = this.filterProperties(scheme, properties);
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        String originalSyntax = syntax = CatalogHelper.after(syntax, ":");
        TreeMap<String, String> copy = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String value;
            String key = entry.getKey();
            String string = value = entry.getValue() != null ? entry.getValue() : "";
            if (syntax != null && syntax.contains(key)) {
                syntax = syntax.replace(key, value);
                continue;
            }
            copy.put(key, value);
        }
        String[] tokens = syntax.split("\\w+");
        Matcher matcher = SYNTAX_PATTERN.matcher(originalSyntax);
        ArrayList<String> options = new ArrayList<String>();
        while (matcher.find()) {
            String s = matcher.group(1);
            options.add(s);
        }
        syntax = syntax.replaceAll("\\{\\{", "BEGINCAMELPLACEHOLDER");
        syntax = syntax.replaceAll("\\}\\}", "ENDCAMELPLACEHOLDER");
        Matcher matcher2 = SYNTAX_PATTERN.matcher(syntax);
        ArrayList<String> options2 = new ArrayList<String>();
        while (matcher2.find()) {
            String s = matcher2.group(1);
            s = s.replaceAll("BEGINCAMELPLACEHOLDER", "\\{\\{");
            s = s.replaceAll("ENDCAMELPLACEHOLDER", "\\}\\}");
            options2.add(s);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(scheme);
        sb.append(":");
        int range = 0;
        boolean first = true;
        boolean hasQuestionmark = false;
        for (int i = 0; i < options.size(); ++i) {
            String value;
            boolean contains;
            String key = (String)options.get(i);
            String key2 = (String)options2.get(i);
            String token = null;
            if (tokens.length > i) {
                token = tokens[i];
            }
            if (!(contains = properties.containsKey(key)) && JSonSchemaHelper.isPropertyRequired(rows, key) && (value = JSonSchemaHelper.getPropertyDefaultValue(rows, key)) != null) {
                properties.put(key, value);
                key2 = value;
            }
            if (properties.containsKey(key)) {
                if (!first && token != null) {
                    sb.append(token);
                }
                hasQuestionmark |= key.contains("?") || token != null && token.contains("?");
                sb.append(key2);
                first = false;
            }
            ++range;
        }
        while (range < options2.size()) {
            String token = null;
            if (tokens.length > range) {
                token = tokens[range];
            }
            String key2 = (String)options2.get(range);
            sb.append(token);
            sb.append(key2);
            hasQuestionmark |= key2.contains("?") || token != null && token.contains("?");
            ++range;
        }
        if (!copy.isEmpty()) {
            sb.append(hasQuestionmark ? ampersand : Character.valueOf('?'));
            String query = URISupport.createQueryString(copy, ampersand, encode);
            sb.append(query);
        }
        return sb.toString();
    }

    @Override
    public SimpleValidationResult validateSimpleExpression(String simple) {
        return this.doValidateSimple(simple, false);
    }

    @Override
    public SimpleValidationResult validateSimplePredicate(String simple) {
        return this.doValidateSimple(simple, true);
    }

    private SimpleValidationResult doValidateSimple(String simple, boolean predicate) {
        SimpleValidationResult answer = new SimpleValidationResult(simple);
        Object instance = null;
        Class<?> clazz = null;
        try {
            clazz = DefaultCamelCatalog.class.getClassLoader().loadClass("org.apache.camel.language.simple.SimpleLanguage");
            instance = clazz.newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (clazz != null && instance != null) {
            try {
                if (predicate) {
                    instance.getClass().getMethod("createPredicate", String.class).invoke(instance, simple);
                } else {
                    instance.getClass().getMethod("createExpression", String.class).invoke(instance, simple);
                }
            }
            catch (InvocationTargetException e) {
                answer.setError(e.getTargetException().getMessage());
            }
            catch (Exception e) {
                answer.setError(e.getMessage());
            }
        }
        return answer;
    }

    private Map<String, String> filterProperties(String scheme, Map<String, String> options) {
        String showAll;
        if ("log".equals(scheme) && "true".equals(showAll = options.get("showAll"))) {
            LinkedHashMap<String, String> filtered = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry : options.entrySet()) {
                String key = entry.getKey();
                boolean skip = key.startsWith("show") && !key.equals("showAll");
                if (skip) continue;
                filtered.put(key, entry.getValue());
            }
            return filtered;
        }
        return options;
    }

    @Override
    public String listComponentsAsJson() {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("listComponentsAsJson");
        }
        if (answer == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            List<String> names = this.findComponentNames();
            for (int i = 0; i < names.size(); ++i) {
                String scheme = names.get(i);
                String json = this.componentJSonSchema(scheme);
                String string = json = (json = CatalogHelper.between(json, "\"component\": {", "\"componentProperties\": {")) != null ? json.trim() : "";
                if (i == names.size() - 1) {
                    json = json.substring(0, json.length() - 1);
                }
                sb.append("\n");
                sb.append("  {\n");
                sb.append("    ");
                sb.append(json);
            }
            sb.append("\n]");
            answer = sb.toString();
            if (this.caching) {
                this.cache.put("listComponentsAsJson", answer);
            }
        }
        return answer;
    }

    @Override
    public String listDataFormatsAsJson() {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("listDataFormatsAsJson");
        }
        if (answer == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            List<String> names = this.findDataFormatNames();
            for (int i = 0; i < names.size(); ++i) {
                String scheme = names.get(i);
                String json = this.dataFormatJSonSchema(scheme);
                String string = json = (json = CatalogHelper.between(json, "\"dataformat\": {", "\"properties\": {")) != null ? json.trim() : "";
                if (i == names.size() - 1) {
                    json = json.substring(0, json.length() - 1);
                }
                sb.append("\n");
                sb.append("  {\n");
                sb.append("    ");
                sb.append(json);
            }
            sb.append("\n]");
            answer = sb.toString();
            if (this.caching) {
                this.cache.put("listDataFormatsAsJson", answer);
            }
        }
        return answer;
    }

    @Override
    public String listLanguagesAsJson() {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("listLanguagesAsJson");
        }
        if (answer == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            List<String> names = this.findLanguageNames();
            for (int i = 0; i < names.size(); ++i) {
                String scheme = names.get(i);
                String json = this.languageJSonSchema(scheme);
                String string = json = (json = CatalogHelper.between(json, "\"language\": {", "\"properties\": {")) != null ? json.trim() : "";
                if (i == names.size() - 1) {
                    json = json.substring(0, json.length() - 1);
                }
                sb.append("\n");
                sb.append("  {\n");
                sb.append("    ");
                sb.append(json);
            }
            sb.append("\n]");
            answer = sb.toString();
            if (this.caching) {
                this.cache.put("listLanguagesAsJson", answer);
            }
        }
        return answer;
    }

    @Override
    public String listModelsAsJson() {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("listModelsAsJson");
        }
        if (answer == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            List<String> names = this.findModelNames();
            for (int i = 0; i < names.size(); ++i) {
                String scheme = names.get(i);
                String json = this.modelJSonSchema(scheme);
                String string = json = (json = CatalogHelper.between(json, "\"model\": {", "\"properties\": {")) != null ? json.trim() : "";
                if (i == names.size() - 1) {
                    json = json.substring(0, json.length() - 1);
                }
                sb.append("\n");
                sb.append("  {\n");
                sb.append("    ");
                sb.append(json);
            }
            sb.append("\n]");
            answer = sb.toString();
            if (this.caching) {
                this.cache.put("listModelsAsJson", answer);
            }
        }
        return answer;
    }

    @Override
    public String summaryAsJson() {
        String answer = null;
        if (this.caching) {
            answer = (String)this.cache.get("summaryAsJson");
        }
        if (answer == null) {
            int archetypes = 0;
            try {
                String xml = this.archetypeCatalogAsXml();
                Document dom = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
                Object val = XPathFactory.newInstance().newXPath().evaluate("count(/archetype-catalog/archetypes/archetype)", dom, XPathConstants.NUMBER);
                double num = (Double)val;
                archetypes = (int)num;
            }
            catch (Exception e) {
                // empty catch block
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{\n");
            sb.append("  \"version\": \"").append(this.getCatalogVersion()).append("\",\n");
            sb.append("  \"eips\": ").append(this.findModelNames().size()).append(",\n");
            sb.append("  \"components\": ").append(this.findComponentNames().size()).append(",\n");
            sb.append("  \"dataformats\": ").append(this.findDataFormatNames().size()).append(",\n");
            sb.append("  \"languages\": ").append(this.findLanguageNames().size()).append(",\n");
            sb.append("  \"archetypes\": ").append(archetypes).append("\n");
            sb.append("}");
            answer = sb.toString();
            if (this.caching) {
                this.cache.put("summaryAsJson", answer);
            }
        }
        return answer;
    }
}

