/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

public class HttpHandlerRegistration {
    public static final HttpHandlerRegistration ROOT = HttpHandlerRegistration.builder().contextPath("").urlPattern("/").build();
    private final String contextPath;
    private final String urlPattern;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder bulder() {
        return HttpHandlerRegistration.builder();
    }

    public static HttpHandlerRegistration fromString(String mapping) {
        if (mapping == null) {
            return ROOT;
        }
        String contextPath = HttpHandlerRegistration.getContextPath(mapping);
        return new HttpHandlerRegistration(contextPath, HttpHandlerRegistration.getWrapperPath(contextPath, mapping));
    }

    private HttpHandlerRegistration(String contextPath, String urlPattern) {
        this.contextPath = contextPath;
        this.urlPattern = urlPattern;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + this.contextPath.hashCode();
        hash = 41 * hash + this.urlPattern.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpHandlerRegistration other = (HttpHandlerRegistration)obj;
        return this.contextPath.equals(other.contextPath) && this.urlPattern.equals(other.urlPattern);
    }

    private static String getWrapperPath(String ctx, String mapping) {
        if (mapping.indexOf("*.") > 0) {
            return mapping.substring(mapping.lastIndexOf("/") + 1);
        }
        if (ctx.length() != 0) {
            return mapping.substring(ctx.length());
        }
        if (mapping.startsWith("//")) {
            return mapping.substring(1);
        }
        return mapping;
    }

    private static String getContextPath(String mapping) {
        int slash = mapping.indexOf("/", 1);
        String ctx = slash != -1 ? mapping.substring(0, slash) : mapping;
        if (ctx.startsWith("/*") || ctx.startsWith("*")) {
            ctx = "";
        }
        if (ctx.equals("/")) {
            ctx = "";
        }
        return ctx;
    }

    public static class Builder {
        private String contextPath;
        private String urlPattern;

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder urlPattern(String urlPattern) {
            this.urlPattern = urlPattern;
            return this;
        }

        public HttpHandlerRegistration build() {
            if (this.contextPath == null) {
                this.contextPath = "";
            }
            if (this.urlPattern == null) {
                this.urlPattern = "/";
            }
            return new HttpHandlerRegistration(this.contextPath, this.urlPattern);
        }
    }
}

