/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3.vfs;

import java.util.Collection;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.URLFileName;
import org.jets3t.service.S3Service;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.pentaho.s3.vfs.S3FileObject;
import org.pentaho.s3.vfs.S3FileProvider;

public class S3FileSystem
extends AbstractFileSystem
implements FileSystem {
    private S3Service service;
    public static final String ACCESS_KEY_SYSTEM_PROPERTY = "aws.accessKeyId";
    public static final String SECRET_KEY_SYSTEM_PROPERTY = "aws.secretKey";
    private String awsAccessKeyCache;
    private String awsSecretKeyCache;

    protected S3FileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(S3FileProvider.capabilities);
    }

    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new S3FileObject(name, this);
    }

    public S3Service getS3Service() {
        String awsAccessKeySystemEnvValue = System.getProperty(ACCESS_KEY_SYSTEM_PROPERTY);
        String awsSecretKeySystemEnvValue = System.getProperty(SECRET_KEY_SYSTEM_PROPERTY);
        if (this.service == null || this.service.getProviderCredentials() == null || this.service.getProviderCredentials().getAccessKey() == null || this.service != null && this.hasChanged(this.awsAccessKeyCache, awsAccessKeySystemEnvValue) && this.hasChanged(this.awsSecretKeyCache, awsSecretKeySystemEnvValue)) {
            UserAuthenticator userAuthenticator = DefaultFileSystemConfigBuilder.getInstance().getUserAuthenticator(this.getFileSystemOptions());
            String awsAccessKey = null;
            String awsSecretKey = null;
            if (userAuthenticator != null) {
                UserAuthenticationData data = userAuthenticator.requestAuthentication(S3FileProvider.AUTHENTICATOR_TYPES);
                awsAccessKey = String.valueOf(data.getData(UserAuthenticationData.USERNAME));
                awsSecretKey = String.valueOf(data.getData(UserAuthenticationData.PASSWORD));
            } else if (awsAccessKeySystemEnvValue != null && awsSecretKeySystemEnvValue != null) {
                awsAccessKey = awsAccessKeySystemEnvValue;
                awsSecretKey = awsSecretKeySystemEnvValue;
                this.awsAccessKeyCache = awsAccessKeySystemEnvValue;
                this.awsSecretKeyCache = awsSecretKeySystemEnvValue;
            } else {
                awsAccessKey = ((URLFileName)this.getRootName()).getUserName();
                awsSecretKey = ((URLFileName)this.getRootName()).getPassword();
            }
            AWSCredentials awsCredentials = new AWSCredentials(awsAccessKey, awsSecretKey);
            try {
                this.service = new RestS3Service((ProviderCredentials)awsCredentials);
            }
            catch (Throwable t) {
                System.out.println("Could not getS3Service() for " + awsCredentials.getLogString());
                t.printStackTrace();
            }
        }
        return this.service;
    }

    private boolean isEmpty(String value) {
        return value == null || value.length() <= 0;
    }

    private boolean hasChanged(String previousValue, String currentValue) {
        if (!this.isEmpty(previousValue) && this.isEmpty(currentValue)) {
            return true;
        }
        if (this.isEmpty(previousValue) && !this.isEmpty(currentValue)) {
            return true;
        }
        return !this.isEmpty(previousValue) && !this.isEmpty(currentValue) && !currentValue.equals(previousValue);
    }
}

