/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.automodel;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.metadata.automodel.importing.strategy.DefaultImportStrategy;
import org.pentaho.metadata.model.IPhysicalColumn;
import org.pentaho.metadata.model.SqlPhysicalColumn;
import org.pentaho.metadata.model.SqlPhysicalTable;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.FieldType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.concept.types.TableType;
import org.pentaho.metadata.util.Util;

public class PhysicalTableImporter {
    public static final ImportStrategy defaultImportStrategy = new DefaultImportStrategy();

    public static SqlPhysicalTable importTableDefinition(Database database, String schemaName, String tableName, String locale) throws KettleException {
        return PhysicalTableImporter.importTableDefinition(database, schemaName, tableName, locale, defaultImportStrategy);
    }

    public static SqlPhysicalTable importTableDefinition(Database database, String schemaName, String tableName, String locale, ImportStrategy importStrategy) throws KettleException {
        String upper;
        String id = (Util.getPhysicalTableIdPrefix() + Util.toId(tableName)).toUpperCase();
        SqlPhysicalTable physicalTable = new SqlPhysicalTable();
        physicalTable.setId(id);
        physicalTable.setTargetSchema(schemaName);
        List<IPhysicalColumn> fields = physicalTable.getPhysicalColumns();
        physicalTable.setTargetTable(tableName);
        String niceName = PhysicalTableImporter.beautifyName(tableName);
        physicalTable.setName(new LocalizedString(locale, niceName));
        DatabaseMeta dbMeta = database.getDatabaseMeta();
        String schemaTableCombination = dbMeta.getSchemaTableCombination(dbMeta.quoteField(schemaName), dbMeta.quoteField(tableName));
        RowMetaInterface row = database.getTableFields(schemaTableCombination);
        if (row != null && row.size() > 0) {
            for (int i = 0; i < row.size(); ++i) {
                ValueMetaInterface v = row.getValueMeta(i);
                if (!importStrategy.shouldInclude(v)) continue;
                IPhysicalColumn physicalColumn = PhysicalTableImporter.importPhysicalColumnDefinition(v, physicalTable, locale, importStrategy);
                fields.add(physicalColumn);
            }
        }
        if ((upper = tableName.toUpperCase()).startsWith("D_") || upper.startsWith("DIM") || upper.endsWith("DIM")) {
            physicalTable.setTableType(TableType.DIMENSION);
        }
        if (upper.startsWith("F_") || upper.startsWith("FACT") || upper.endsWith("FACT")) {
            physicalTable.setTableType(TableType.FACT);
        }
        return physicalTable;
    }

    public static String beautifyName(String name) {
        return StringUtils.capitalize((String)name.replaceAll("[\"`'\\\\]", "").replace("_", " "));
    }

    private static IPhysicalColumn importPhysicalColumnDefinition(ValueMetaInterface v, SqlPhysicalTable physicalTable, String locale, ImportStrategy importStrategy) {
        String columnName = v.getName();
        FieldType fieldType = FieldType.guessFieldType(v.getName());
        SqlPhysicalColumn physicalColumn = new SqlPhysicalColumn(physicalTable);
        physicalColumn.setId(v.getName());
        physicalColumn.setTargetColumn(columnName);
        physicalColumn.setFieldType(fieldType);
        physicalColumn.setAggregationType(AggregationType.NONE);
        String niceName = PhysicalTableImporter.beautifyName(importStrategy.displayName(v));
        physicalColumn.setName(new LocalizedString(locale, niceName));
        DataType dataType = PhysicalTableImporter.getDataType(v);
        physicalColumn.setDataType(dataType);
        if (null != v.getConversionMask()) {
            physicalColumn.setProperty("source_mask", v.getConversionMask());
        }
        if (null != v.getDecimalSymbol()) {
            physicalColumn.setProperty("source_decimalSymbol", v.getDecimalSymbol());
        }
        if (null != v.getGroupingSymbol()) {
            physicalColumn.setProperty("source_groupingSymbol", v.getGroupingSymbol());
        }
        if (null != v.getCurrencySymbol()) {
            physicalColumn.setProperty("source_currencySymbol", v.getCurrencySymbol());
        }
        return physicalColumn;
    }

    private static DataType getDataType(ValueMetaInterface v) {
        switch (v.getType()) {
            case 1: 
            case 5: 
            case 6: {
                return DataType.NUMERIC;
            }
            case 8: {
                return DataType.BINARY;
            }
            case 4: {
                return DataType.BOOLEAN;
            }
            case 3: 
            case 9: {
                return DataType.DATE;
            }
            case 2: {
                return DataType.STRING;
            }
        }
        return DataType.UNKNOWN;
    }

    public static interface ImportStrategy {
        public boolean shouldInclude(ValueMetaInterface var1);

        public String displayName(ValueMetaInterface var1);
    }
}

