/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.impl.sql;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.metadata.query.impl.sql.SqlQuery;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.metadata.query.model.util.QueryModelMetaData;

public class MappedQuery
implements SqlQuery {
    protected String query;
    protected Map columnsMap;
    protected List<? extends Selection> selections;
    protected List<String> paramNameList;

    public MappedQuery(String sql, Map columnsMap, List<? extends Selection> selections, List<String> paramNameList) {
        this.query = sql;
        this.selections = selections;
        this.columnsMap = columnsMap;
        this.paramNameList = paramNameList;
    }

    public String getDisplayQuery() {
        String execQuery = new String(this.query);
        for (String element : this.columnsMap.keySet()) {
            String identifier = (String)this.columnsMap.get(element);
            execQuery = this.wholeWordReplaceAll(execQuery, element, identifier);
        }
        return execQuery;
    }

    private String wholeWordReplaceAll(String source, String search, String repl) {
        Pattern p = Pattern.compile("(\\W)" + search + "(\\W)");
        Matcher m = p.matcher(source);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group(1) + repl + m.group(2));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public Map getMap() {
        return this.columnsMap;
    }

    public List<String> getParamList() {
        return this.paramNameList;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public IPentahoMetaData generateMetadata(IPentahoMetaData nativeMetadata) {
        return new QueryModelMetaData(this.columnsMap, nativeMetadata.getColumnHeaders(), nativeMetadata.getRowHeaders(), this.selections);
    }
}

