/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.example;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.example.AdvancedMQLQuery;
import org.pentaho.pms.example.AdvancedSQLGenerator;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.mql.PMSFormula;
import org.pentaho.pms.mql.Selection;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.BusinessTable;

public class AliasAwarePMSFormula
extends PMSFormula {
    private static final Log logger = LogFactory.getLog(AliasAwarePMSFormula.class);
    private List<Selection> selections;
    private String aliasName;
    private Map<String, String> businessTableToAliasMap;
    private Map<String, AdvancedMQLQuery.AliasedSelection> aliasedSelectionMap = new HashMap<String, AdvancedMQLQuery.AliasedSelection>();
    List<AdvancedSQLGenerator.AliasedPathBusinessTable> aliasedTables = new ArrayList<AdvancedSQLGenerator.AliasedPathBusinessTable>();

    public AliasAwarePMSFormula(BusinessModel model, DatabaseMeta databaseMeta, String formulaString, List<Selection> selections, String aliasName) throws PentahoMetadataException {
        super(model, databaseMeta, formulaString, null);
        this.selections = selections;
        this.aliasName = aliasName;
    }

    public AliasAwarePMSFormula(BusinessModel model, BusinessTable table, DatabaseMeta databaseMeta, String formulaString, String aliasName) throws PentahoMetadataException {
        super(model, table, databaseMeta, formulaString, null);
        this.aliasName = aliasName;
    }

    public AliasAwarePMSFormula(BusinessModel model, BusinessTable table, String formulaString, String aliasName) throws PentahoMetadataException {
        super(model, table, formulaString, null);
        this.aliasName = aliasName;
    }

    public void setBusinessTableToAliasMap(Map<String, String> businessTableToAlias) {
        this.businessTableToAliasMap = businessTableToAlias;
    }

    @Override
    protected void addField(String fieldName) throws PentahoMetadataException {
        if (this.selections != null && fieldName != null && fieldName.indexOf(".") >= 0) {
            String[] names = fieldName.split("\\.");
            for (Selection selection : this.selections) {
                AdvancedMQLQuery.AliasedSelection aliasedSelection = (AdvancedMQLQuery.AliasedSelection)selection;
                if (aliasedSelection.getAlias() == null || !aliasedSelection.getAlias().equals(names[0])) continue;
                BusinessColumn column = this.getBusinessModel().findBusinessColumn(names[1]);
                if (column != null) {
                    AdvancedMQLQuery.AliasedSelection sel = new AdvancedMQLQuery.AliasedSelection(column, aliasedSelection.getAlias());
                    this.aliasedSelectionMap.put(fieldName, sel);
                    this.getBusinessColumns().add(sel);
                    return;
                }
                throw new PentahoMetadataException(Messages.getErrorString("PMSFormula.ERROR_0011_INVALID_FIELDNAME", fieldName));
            }
        }
        super.addField(fieldName);
    }

    @Override
    protected void renderContextLookup(StringBuffer sb, String contextName, String locale) {
        AdvancedMQLQuery.AliasedSelection sel = this.aliasedSelectionMap.get(contextName);
        if (sel != null) {
            sb.append(" ");
            AdvancedSQLGenerator.SQLAndAliasedTables sqlAndTables = AdvancedSQLGenerator.getSelectionSQL(this.getBusinessModel(), sel, this.getDatabaseMeta(), locale);
            sb.append(sqlAndTables.getSql());
            sb.append(" ");
            for (AdvancedSQLGenerator.AliasedPathBusinessTable aliasedTable : sqlAndTables.getAliasedBusinessTables()) {
                if (this.aliasedTables.contains(aliasedTable)) continue;
                this.aliasedTables.add(aliasedTable);
            }
            return;
        }
        Selection column = (Selection)this.getBusinessColumnMap().get(contextName);
        if (column == null) {
            String tableColumn = "";
            sb.append(" ");
            BusinessTable businessTable = this.findBusinessTableForContextName(contextName, locale);
            if (businessTable != null) {
                sb.append(this.getDatabaseMeta().quoteField(businessTable.getId()));
                sb.append(".");
            }
            sb.append(this.getDatabaseMeta().quoteField(contextName));
            sb.append(" ");
        } else {
            AdvancedMQLQuery.AliasedSelection selection = null;
            if (this.businessTableToAliasMap != null) {
                String tmpAliasName = this.businessTableToAliasMap.get(column.getBusinessColumn().getBusinessTable().getId());
                if (tmpAliasName == null) {
                    tmpAliasName = this.aliasName;
                }
                selection = new AdvancedMQLQuery.AliasedSelection(column.getBusinessColumn(), tmpAliasName);
            } else {
                selection = new AdvancedMQLQuery.AliasedSelection(column.getBusinessColumn(), this.aliasName);
            }
            sb.append(" ");
            AdvancedSQLGenerator.SQLAndAliasedTables sqlAndTables = AdvancedSQLGenerator.getSelectionSQL(this.getBusinessModel(), selection, this.getDatabaseMeta(), locale);
            sb.append(sqlAndTables.getSql());
            sb.append(" ");
            for (AdvancedSQLGenerator.AliasedPathBusinessTable aliasedTable : sqlAndTables.getAliasedBusinessTables()) {
                if (this.aliasedTables.contains(aliasedTable)) continue;
                this.aliasedTables.add(aliasedTable);
            }
        }
    }

    @Override
    public String[] getBusinessTableIDs() {
        throw new UnsupportedOperationException();
    }

    public String[] getTableAliasNames() {
        String[] tables = new String[this.aliasedTables.size()];
        for (int i = 0; i < this.aliasedTables.size(); ++i) {
            tables[i] = this.aliasedTables.get(i).getAlias();
        }
        return tables;
    }

    public List<AdvancedSQLGenerator.AliasedPathBusinessTable> getUsedAliasedTables() {
        return this.aliasedTables;
    }
}

