/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.factory.CwmSchemaFactoryInterface;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.mql.MQLQuery;

public class MQLQueryFactory {
    private static final Log logger = LogFactory.getLog(MQLQueryFactory.class);

    public static MQLQuery getMQLQuery(String XML, DatabaseMeta meta, String locale, CwmSchemaFactoryInterface factory) throws PentahoMetadataException {
        String mqlQueryClassName = System.getProperty("org.pentaho.pms.mql.MQLQueryClassName", "org.pentaho.pms.mql.MQLQueryImpl");
        return MQLQueryFactory.getMQLQuery(mqlQueryClassName, XML, meta, locale, factory);
    }

    public static MQLQuery getMQLQuery(String mqlQueryClassName, String XML, DatabaseMeta meta, String locale, CwmSchemaFactoryInterface factory) throws PentahoMetadataException {
        try {
            Class<?> claz = Class.forName(mqlQueryClassName);
            Class<MQLQuery> clazz = claz.asSubclass(MQLQuery.class);
            if (MQLQuery.class.isAssignableFrom(clazz)) {
                Class[] argClasses = new Class[]{String.class, DatabaseMeta.class, String.class, CwmSchemaFactoryInterface.class};
                Constructor<MQLQuery> constr = clazz.getConstructor(argClasses);
                Object[] vars = new Object[]{XML, meta, locale, factory};
                return constr.newInstance(vars);
            }
            logger.error((Object)Messages.getErrorString("MQLQueryFactory.ERROR_0001_MQLQUERY_CLASS_NOT_ASSIGNABLE", mqlQueryClassName));
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)Messages.getErrorString("MQLQueryFactory.ERROR_0002_MQLQUERY_CLASS_NOT_FOUND", mqlQueryClassName), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)Messages.getErrorString("MQLQueryFactory.ERROR_0003_MQLQUERY_CLASS_DOES_NOT_CONTAIN_CONSTRUCTOR", mqlQueryClassName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)Messages.getErrorString("MQLQueryFactory.ERROR_0004_MQLQUERY_CLASS_ILLEGAL_ACCESS", mqlQueryClassName), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)Messages.getErrorString("MQLQueryFactory.ERROR_0005_MQLQUERY_CLASS_CANNOT_INSTANTIATE", mqlQueryClassName), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof PentahoMetadataException) {
                throw (PentahoMetadataException)e.getTargetException();
            }
            logger.error((Object)Messages.getErrorString("MQLQueryFactory.ERROR_0006_MQLQUERY_CLASS_CANNOT_INVOKE", mqlQueryClassName), (Throwable)e);
        }
        return null;
    }
}

