/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql.dialect;

import org.pentaho.pms.mql.dialect.DefaultSQLDialect;
import org.pentaho.pms.mql.dialect.SQLQueryModel;

public class GoogleBigQueryDialect
extends DefaultSQLDialect {
    public GoogleBigQueryDialect() {
        super("GOOGLEBIGQUERY");
    }

    protected GoogleBigQueryDialect(String compatibleDialect) {
        super(compatibleDialect);
    }

    @Override
    public String getDateSQL(int year, int month, int day) {
        return "CAST(" + super.getDateSQL(year, month, day) + " AS DATE)";
    }

    @Override
    public String getDateSQL(int year, int month, int day, int hour, int minute, int second, int milli) {
        return "CAST(" + super.getDateSQL(year, month, day, hour, minute, second, milli) + " AS TIMESTAMP)";
    }

    @Override
    public int getMaxTableNameLength() {
        return 1024;
    }

    @Override
    protected String getStringConcatOperator() {
        return null;
    }

    @Override
    protected String generateStringConcat(String ... vals) {
        StringBuilder sb = new StringBuilder();
        sb.append("CONCAT(");
        for (int i = 0; i < vals.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(vals[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    protected void generatePostOrderBy(SQLQueryModel query, StringBuilder sql) {
        this.generateLimit(query, sql);
    }

    @Override
    protected void generateSelectPredicate(SQLQueryModel query, StringBuilder sql) {
        this.generateDistinct(query, sql);
    }
}

