/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept.types.columnwidth;

import java.math.BigDecimal;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.pentaho.pms.messages.Messages;

public class ColumnWidth {
    public static final int TYPE_WIDTH_PIXELS = 0;
    public static final int TYPE_WIDTH_PERCENT = 1;
    public static final int TYPE_WIDTH_INCHES = 2;
    public static final int TYPE_WIDTH_CM = 3;
    public static final int TYPE_WIDTH_POINTS = 4;
    public static final ColumnWidth PIXELS = new ColumnWidth(0, 100);
    public static final ColumnWidth PERCENT = new ColumnWidth(1, 10);
    public static final ColumnWidth INCHES = new ColumnWidth(2, 3);
    public static final ColumnWidth CM = new ColumnWidth(3, 10);
    public static final ColumnWidth POINTS = new ColumnWidth(4, 1);
    private static final String[] typeCodes = new String[]{"pixels", "percent", "inches", "cm", "points"};
    private static final String[] typeDescriptions = new String[]{Messages.getString("ColumnWidth.USER_PIXELS_DESC"), Messages.getString("ColumnWidth.USER_PERCENT_DESC"), Messages.getString("ColumnWidth.USER_INCHES_DESC"), Messages.getString("ColumnWidth.USER_CENTIMETERS_DESC"), Messages.getString("ColumnWidth.USER_POINTS_DESC")};
    public static final ColumnWidth[] types = new ColumnWidth[]{PIXELS, PERCENT, INCHES, CM, POINTS};
    private int type;
    private BigDecimal width;
    private static final String SEPARATOR = ",";

    public ColumnWidth(int type, BigDecimal width) {
        this.type = type;
        this.width = width;
    }

    public ColumnWidth(int type, int width) {
        this.type = type;
        this.width = new BigDecimal(width);
    }

    public ColumnWidth(int type, double width) {
        this.type = type;
        this.width = new BigDecimal(width);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ColumnWidth)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ColumnWidth rhs = (ColumnWidth)obj;
        return new EqualsBuilder().append(this.type, rhs.type).append((Object)this.width, (Object)rhs.width).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(19, 163).append(this.type).append((Object)this.width).toHashCode();
    }

    public String toString() {
        return this.type + SEPARATOR + this.width;
    }

    public static ColumnWidth fromString(String value) {
        String[] parts = value.split(SEPARATOR);
        if (parts.length != 2) {
            return null;
        }
        return new ColumnWidth(Integer.parseInt(parts[0]), new BigDecimal(parts[1]));
    }

    public static ColumnWidth getType(String description) {
        int i;
        for (i = 0; i < typeDescriptions.length; ++i) {
            if (!typeDescriptions[i].equalsIgnoreCase(description)) continue;
            return types[i];
        }
        for (i = 0; i < typeCodes.length; ++i) {
            if (!typeCodes[i].equalsIgnoreCase(description)) continue;
            return types[i];
        }
        return PIXELS;
    }

    public String getCode() {
        return typeCodes[this.type];
    }

    public String getDescription() {
        return typeDescriptions[this.type];
    }

    public BigDecimal getWidth() {
        return this.width;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public static String[] getTypeDescriptions() {
        return (String[])typeDescriptions.clone();
    }
}

