/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.security;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.schema.security.SecurityOwner;
import org.pentaho.pms.util.Const;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Security
implements Cloneable {
    private Map<SecurityOwner, Integer> ownerAclMap;

    public Security() {
        this.ownerAclMap = new Hashtable<SecurityOwner, Integer>();
    }

    public Security(Map<SecurityOwner, Integer> aclSets) {
        this.ownerAclMap = aclSets;
    }

    public String toString() {
        StringBuffer string = new StringBuffer();
        string.append("{");
        List<SecurityOwner> owners = this.getOwners();
        for (int i = 0; i < owners.size(); ++i) {
            SecurityOwner owner = owners.get(i);
            int rights = this.getOwnerRights(owner);
            if (i > 0) {
                string.append(", ");
            }
            string.append(owner.toString() + "(" + rights + ")");
        }
        string.append("}");
        return string.toString();
    }

    public Object clone() {
        Security security = new Security();
        List<SecurityOwner> owners = this.getOwners();
        for (int i = 0; i < owners.size(); ++i) {
            SecurityOwner owner = owners.get(i);
            int rights = this.getOwnerRights(owner);
            security.putOwnerRights((SecurityOwner)owner.clone(), rights);
        }
        return security;
    }

    public String toXML() {
        StringBuffer xml = new StringBuffer();
        xml.append("<security>").append(Const.CR);
        List<SecurityOwner> owners = this.getOwners();
        for (int i = 0; i < owners.size(); ++i) {
            xml.append("  <owner-rights>").append(Const.CR);
            SecurityOwner owner = owners.get(i);
            int rights = this.getOwnerRights(owner);
            xml.append("  " + owner.toXML() + " <rights>" + rights + "</rights>").append(Const.CR);
            xml.append("  </owner-rights>").append(Const.CR);
        }
        xml.append("</security>").append(Const.CR);
        return xml.toString();
    }

    public Security(Node securityNode) throws Exception {
        this();
        try {
            int nrOwnerRights = XMLHandler.countNodes((Node)securityNode, (String)"owner-rights");
            for (int i = 0; i < nrOwnerRights; ++i) {
                Node ownerRightsNode = XMLHandler.getSubNodeByNr((Node)securityNode, (String)"owner-rights", (int)i);
                Node ownerNode = XMLHandler.getSubNode((Node)ownerRightsNode, (String)"owner");
                SecurityOwner owner = new SecurityOwner(ownerNode);
                int rights = Integer.parseInt(XMLHandler.getTagValue((Node)ownerRightsNode, (String)"rights"));
                this.putOwnerRights(owner, rights);
            }
        }
        catch (Exception e) {
            throw new Exception(Messages.getString("Security.ERROR_0001_CANT_CREATE_SECURITY_OBJECT"), e);
        }
    }

    public static Security fromXML(String value) throws Exception {
        try {
            Document doc = XMLHandler.loadXMLString((String)value);
            return new Security(XMLHandler.getSubNode((Node)doc, (String)"security"));
        }
        catch (Exception e) {
            throw new Exception(Messages.getString("Security.ERROR_0001_CANT_CREATE_SECURITY_OBJECT"), e);
        }
    }

    public void putOwnerRights(SecurityOwner owner, int rights) {
        this.ownerAclMap.put(owner, rights);
    }

    public int getOwnerRights(SecurityOwner owner) {
        return this.ownerAclMap.get(owner);
    }

    public void removeOwnerRights(SecurityOwner owner) {
        this.ownerAclMap.remove(owner);
    }

    public List<SecurityOwner> getOwners() {
        return new ArrayList<SecurityOwner>(this.ownerAclMap.keySet());
    }

    public Map getOwnerAclMap() {
        return this.ownerAclMap;
    }

    public void setOwnerAclMap(Map<SecurityOwner, Integer> aclSets) {
        this.ownerAclMap = aclSets;
    }
}

