/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.common.gui;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class CheckBoxCellRenderer
extends AbstractCellEditor
implements TableCellRenderer,
TableCellEditor,
ItemListener {
    protected Border noFocusBorder;
    private JCheckBox checkBox;

    public CheckBoxCellRenderer() {
        if (this.noFocusBorder == null) {
            this.noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }
        this.checkBox = new JCheckBox();
        this.checkBox.addItemListener(this);
        this.checkBox.setOpaque(true);
        this.checkBox.setBorder(this.noFocusBorder);
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        this.fireEditingStopped();
    }

    private Component getCell(JTable table, Object value, boolean isSelected, boolean hasFocus) {
        if (value == null) {
            value = new Boolean(false);
        }
        this.checkBox.setSelected((Boolean)value);
        this.checkBox.setFont(table.getFont());
        if (isSelected) {
            this.checkBox.setBackground(table.getSelectionBackground());
            this.checkBox.setForeground(table.getSelectionForeground());
        } else {
            this.checkBox.setBackground(table.getBackground());
            this.checkBox.setForeground(table.getForeground());
        }
        this.checkBox.setBorder(hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : this.noFocusBorder);
        return this.checkBox;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        return this.getCell(table, value, isSelected, true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.getCell(table, value, isSelected, true);
    }

    @Override
    public Object getCellEditorValue() {
        return new Boolean(this.checkBox.isSelected());
    }
}

