/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.common.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class CustomLineBorder
extends AbstractBorder {
    protected Insets borderInsets = new Insets(2, 2, 2, 2);
    protected int thickness = 1;
    protected Color lineColor = new Color(153, 153, 153, 153);
    protected boolean left;
    protected boolean right;
    protected boolean top;
    protected boolean bottom;

    public CustomLineBorder() {
        this(true, true, true, true);
    }

    public CustomLineBorder(boolean top, boolean left, boolean bottom, boolean right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        for (int i = 0; i < this.thickness; ++i) {
            if (this.top) {
                g.drawLine(x + i, y + i, width - i - i - 1, y + i);
            }
            if (this.bottom) {
                g.drawLine(x + i, y + height - i - i - 1, width - i - i - 1, y + height - i - i - 1);
            }
            if (this.left) {
                g.drawLine(x + i, y + i, x + i, y + height - i - i - 1);
            }
            if (!this.right) continue;
            g.drawLine(x + width - i - i - 1, y + i, x + width - i - i - 1, y + height - i - i - 1);
        }
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.borderInsets;
    }
}

