/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.common.gui;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;

public class TextView
extends BorderLayoutPanel {
    private JTextPane editor = new JTextPane();

    public TextView(StyledDocument doc) {
        this.editor.addMouseListener(new InternalPopup());
        this.editor.setFont(new Font("monospaced", 0, 12));
        this.editor.setDocument(doc);
        this.editor.getInputMap().put(KeyStroke.getKeyStroke(155, 1), "paste-from-clipboard");
        this.editor.getInputMap().put(KeyStroke.getKeyStroke(155, 2), "copy-to-clipboard");
        this.editor.getInputMap().put(KeyStroke.getKeyStroke(127, 1), "cut-to-clipboard");
        BorderLayoutPanel noWrapPanel = new BorderLayoutPanel();
        noWrapPanel.setComponentCenter(this.editor);
        JScrollPane scroll = new JScrollPane(noWrapPanel);
        scroll.getVerticalScrollBar().setUnitIncrement(25);
        this.setComponentCenter(scroll);
        this.setTabSize(4);
    }

    public void setEditable(boolean b) {
        this.editor.setEditable(b);
    }

    public void setTabSize(int size) {
        FontMetrics fm = this.editor.getFontMetrics(this.editor.getFont());
        int charWidth = fm.charWidth('w');
        int tabWidth = charWidth * size;
        TabStop[] tabs = new TabStop[10];
        for (int j = 0; j < tabs.length; ++j) {
            int tab = j + 1;
            tabs[j] = new TabStop(tab * tabWidth);
        }
        TabSet tabSet = new TabSet(tabs);
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setTabSet(attributes, tabSet);
        int length = this.editor.getDocument().getLength();
        this.editor.getStyledDocument().setParagraphAttributes(0, length, attributes, false);
    }

    public void append(String str) {
        StyledDocument doc = this.getDocument();
        if (doc != null) {
            try {
                doc.insertString(doc.getLength(), str, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public String getText() {
        return this.editor.getText();
    }

    public void setText(String s) {
        this.editor.setText(s);
    }

    public int getCaretPosition() {
        return this.editor.getCaretPosition();
    }

    public void setCaretPosition(int position) {
        this.editor.setCaretPosition(position);
    }

    public void setSelectionStart(int start) {
        this.editor.setSelectionStart(start);
    }

    public void setSelectionEnd(int end) {
        this.editor.setSelectionEnd(end);
    }

    public String getSelectedText() {
        return this.editor.getSelectedText();
    }

    public StyledDocument getDocument() {
        return (StyledDocument)this.editor.getDocument();
    }

    public void setDocument(StyledDocument doc) {
        this.editor.setDocument(doc);
    }

    public int getLineCount() {
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementCount();
    }

    public int getLineOfOffset(int offset) throws BadLocationException {
        StyledDocument doc = this.getDocument();
        if (offset < 0) {
            throw new BadLocationException("Can't translate offset to line", -1);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("Can't translate offset to line", doc.getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        return map.getElementIndex(offset);
    }

    public int getLineStartOffset(int line) throws BadLocationException {
        int lineCount = this.getLineCount();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= lineCount) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        Element lineElem = map.getElement(line);
        return lineElem.getStartOffset();
    }

    public int getLineEndOffset(int line) throws BadLocationException {
        int lineCount = this.getLineCount();
        if (line < 0) {
            throw new BadLocationException("Negative line", -1);
        }
        if (line >= lineCount) {
            throw new BadLocationException("No such line", this.getDocument().getLength() + 1);
        }
        Element map = this.getDocument().getDefaultRootElement();
        Element lineElem = map.getElement(line);
        int endOffset = lineElem.getEndOffset();
        return line == lineCount - 1 ? endOffset - 1 : endOffset;
    }

    public Highlighter getHighlighter() {
        return this.editor.getHighlighter();
    }

    public ActionMap getViewActionMap() {
        return this.editor.getActionMap();
    }

    public InputMap getViewInputMap() {
        return this.editor.getInputMap();
    }

    private class InternalPopup
    extends JPopupMenu
    implements MouseListener {
        InternalPopup() {
            DefaultEditorKit kit = new DefaultEditorKit();
            this.add(this.createItem("cut", "cut-to-clipboard", kit.getActions()));
            this.add(this.createItem("copy", "copy-to-clipboard", kit.getActions()));
            this.add(this.createItem("paste", "paste-from-clipboard", kit.getActions()));
            this.add(this.createItem("delete", "delete-previous", kit.getActions()));
            this.addSeparator();
            this.add(this.createItem("select all", "select-all", kit.getActions()));
        }

        private JMenuItem createItem(String text, String key, Action[] actions) {
            JMenuItem item = new JMenuItem();
            for (int i = 0; i < actions.length; ++i) {
                if (!actions[i].getValue("Name").toString().equals(key)) continue;
                item.setAction(actions[i]);
                item.setText(text);
            }
            return item;
        }

        @Override
        public void mousePressed(MouseEvent me) {
            TextView.this.editor.requestFocus();
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (SwingUtilities.isRightMouseButton(me)) {
                boolean selection = TextView.this.editor.getSelectionStart() != TextView.this.editor.getSelectionEnd();
                this.getComponent(0).setEnabled(selection && TextView.this.editor.isEditable());
                this.getComponent(1).setEnabled(selection);
                this.getComponent(2).setEnabled(TextView.this.editor.isEditable());
                this.getComponent(3).setEnabled(selection && TextView.this.editor.isEditable());
                this.show(TextView.this.editor, me.getX(), me.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
        }

        @Override
        public void mouseExited(MouseEvent me) {
        }
    }
}

