/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.common.util;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import nickyb.sqleonardo.common.util.LanguageChangedEvent;
import nickyb.sqleonardo.common.util.LanguageChangedListener;

public class I18n {
    private static String localPackageName = "nickyb/sqleonardo/common/locale/";
    private static String baseName = "sqleonardo";
    private static ResourceBundle oLanguage = null;
    public static Vector languageChangedListeners = null;
    private static Locale currentLocale;

    public static void addOnLanguageChangedListener(LanguageChangedListener listener) {
        languageChangedListeners.add(listener);
    }

    public static List getListOfAvailLanguages() {
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        try {
            Set names = I18n.getResoucesInPackage(I18n.getLocalPackageName());
            for (String n : names) {
                StringTokenizer tokenizer;
                String lang = n.substring(n.lastIndexOf(47) + 1);
                if (lang.indexOf(".properties") < 0 || (tokenizer = new StringTokenizer(lang = lang.substring(0, lang.indexOf(".properties")), "_")).countTokens() <= 1) continue;
                String language = "";
                String country = "";
                String variant = "";
                int i = 0;
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    switch (i) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            language = token;
                            break;
                        }
                        case 2: {
                            country = token;
                            break;
                        }
                        case 3: {
                            variant = token;
                            break;
                        }
                    }
                    ++i;
                }
                Locale model = new Locale(language, country, variant);
                supportedLocales.add(model);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(supportedLocales, new Comparator(){

            public int compare(Object lhs, Object rhs) {
                String ls = ((Locale)lhs).getDisplayLanguage();
                String rs = ((Locale)rhs).getDisplayLanguage();
                return ls.compareTo(rs);
            }
        });
        return supportedLocales;
    }

    public static void setCurrentLocale(String language) {
        I18n.setCurrentLocale(language, null);
    }

    public static void setCurrentLocale(String language, String country) {
        if (language != null && !language.equals("")) {
            if (country != null && !country.equals("")) {
                I18n.setCurrentLocale(new Locale(language, country));
            } else {
                I18n.setCurrentLocale(new Locale(language));
            }
        } else {
            I18n.setCurrentLocale(Locale.getDefault());
        }
    }

    public static void setCurrentLocale(Locale locale) {
        currentLocale = locale;
        oLanguage = null;
        Enumeration enum_listeners = languageChangedListeners.elements();
        while (enum_listeners.hasMoreElements()) {
            try {
                ((LanguageChangedListener)enum_listeners.nextElement()).languageChanged(new LanguageChangedEvent(locale));
            }
            catch (Exception exception) {}
        }
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    public static String getString(String cID) {
        return I18n.getString(cID, currentLocale);
    }

    public static String getString(String cID, String defaultValue) {
        return I18n.getString(cID, currentLocale, defaultValue);
    }

    public static String getFormattedString(String cID, String defaultValue, Object[] args) {
        String pattern = I18n.getString(cID, I18n.getCurrentLocale(), defaultValue);
        MessageFormat mf = new MessageFormat(pattern, I18n.getCurrentLocale());
        return mf.format(args);
    }

    private static String getString(String cID, Locale currentLocale) {
        if (currentLocale == null) {
            currentLocale = Locale.getDefault();
        }
        if (oLanguage == null) {
            oLanguage = ResourceBundle.getBundle(I18n.getLocalPackageName() + I18n.getBaseName(), currentLocale);
        }
        try {
            return oLanguage.getString(cID);
        }
        catch (Exception ex) {
            return cID;
        }
    }

    public static String getString(String cID, Locale currentLocale, String defaultValue) {
        try {
            if (oLanguage == null) {
                oLanguage = ResourceBundle.getBundle(I18n.getLocalPackageName() + I18n.getBaseName(), currentLocale);
            }
            return oLanguage.getString(cID);
        }
        catch (MissingResourceException ex) {
            System.out.println("Can't find the translation for key = " + cID + ": using default (" + defaultValue + ")");
        }
        catch (Exception ex) {
            System.out.println("Exception loading cID = " + cID + ": " + ex.getMessage());
        }
        return defaultValue;
    }

    public static Set getResoucesInPackage(String packageName) throws IOException {
        String localPackageName = packageName.endsWith("/") ? packageName : packageName + '/';
        ClassLoader cl = I18n.class.getClassLoader();
        Enumeration<URL> dirEnum = cl.getResources(localPackageName);
        HashSet<String> names = new HashSet<String>();
        while (dirEnum.hasMoreElements()) {
            URL resUrl = dirEnum.nextElement();
            if (resUrl.getProtocol().equals("file")) {
                try {
                    File dir = new File(resUrl.getFile());
                    File[] files = dir.listFiles();
                    if (files == null) continue;
                    for (int i = 0; i < files.length; ++i) {
                        File file = files[i];
                        if (file.isDirectory()) continue;
                        names.add(localPackageName + file.getName());
                    }
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
            }
            if (!resUrl.getProtocol().equals("jar")) continue;
            JarURLConnection jconn = (JarURLConnection)resUrl.openConnection();
            JarFile jfile = jconn.getJarFile();
            Enumeration<JarEntry> entryEnum = jfile.entries();
            while (entryEnum.hasMoreElements()) {
                String parentDirName;
                JarEntry entry = entryEnum.nextElement();
                String entryName = entry.getName();
                if (entryName.equals(localPackageName) || !(parentDirName = entryName.substring(0, entryName.lastIndexOf(47) + 1)).equals(localPackageName)) continue;
                names.add(entryName);
            }
        }
        return names;
    }

    public static String getLocalPackageName() {
        return localPackageName;
    }

    public static void setLocalPackageName(String aLocalPackageName) {
        localPackageName = aLocalPackageName;
    }

    public static String getBaseName() {
        return baseName;
    }

    public static void setBaseName(String aBaseName) {
        baseName = aBaseName;
    }

    static {
        languageChangedListeners = new Vector();
        currentLocale = Locale.ENGLISH;
    }
}

