/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JWindow;
import javax.swing.UIManager;
import nickyb.sqleonardo.common.util.Appearance;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.common.util.Resources;
import nickyb.sqleonardo.common.util.Store;
import nickyb.sqleonardo.common.util.Text;
import nickyb.sqleonardo.environment.Preferences;
import nickyb.sqleonardo.environment._Constants;
import nickyb.sqleonardo.environment._Version;
import nickyb.sqleonardo.environment.mdi.ClientMetadataExplorer;
import nickyb.sqleonardo.environment.mdi.MDIWindow;

public class Application
extends Appearance
implements _Constants,
_Version {
    public static final ClipboardOwner defaultClipboardOwner = new ClipboardOwner(){

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    };
    public static MDIWindow window = null;
    public static final Store session = new Store();
    public static final Resources resources = new Resources();

    private static void loadIcons() {
        resources.loadIcon("icon.001", "/images/connect.png");
        resources.loadIcon("icon.002", "/images/disconnect.png");
        resources.loadIcon("icon.010", "/images/disk.png");
        resources.loadIcon("icon.011", "/images/stop.png");
        resources.loadIcon("icon.012", "/images/find.png");
        resources.loadIcon("icon.013", "/images/filter.png");
        resources.loadIcon("icon.014", "/images/cross.png");
        resources.loadIcon("icon.015", "/images/arrow_left.png");
        resources.loadIcon("icon.016", "/images/arrow_right.png");
        resources.loadIcon("icon.053", "/images/table_error.png");
        resources.loadIcon("icon.051", "/images/database_lightning.png");
        resources.loadIcon("icon.052", "/images/page_edit.png");
        resources.loadIcon("icon.050", "/images/wrench.png");
        resources.loadIcon("icon.99", "/images/cog.png");
        resources.loadIcon("icon.100", "/images/cog_error.png");
        resources.loadIcon("icon.110", "/images/cog_add.png");
        resources.loadIcon("icon.111", "/images/database_add.png");
        resources.loadIcon("icon.101", "/images/database_connect.png");
        resources.loadIcon("icon.102", "/images/database.png");
        resources.loadIcon("icon.103", "/images/folder_database.png");
        resources.loadIcon("icon.104", "/images/folder_table.png");
        resources.loadIcon("icon.105", "/images/table_multiple.png");
        resources.loadIcon("icon.106", "/images/table_link.png");
        resources.loadIcon("icon.107", "/images/cart_add.png");
        resources.loadIcon("icon.108", "/images/cart_delete.png");
        resources.loadIcon("icon.120", "/images/folder_page.png");
        resources.loadIcon("icon.121", "/images/page_save.png");
        resources.loadIcon("icon.122", "/images/page_gear.png");
        resources.loadIcon("icon.162", "/images/database_save.png");
        resources.loadIcon("icon.161", "/images/table_row_delete.png");
        resources.loadIcon("icon.160", "/images/table_row_insert.png");
        resources.loadIcon("icon.151", "/images/table_gear.png");
        resources.loadIcon("icon.152", "/images/picture_save.png");
    }

    private static void loadSession() {
        try {
            if (new File(Application.sessionFilename()).exists()) {
                session.load(Application.sessionFilename());
            }
            Preferences.loadDefaults();
            if (Preferences.getBoolean("application.trace", false)) {
                String temp = System.getProperty("java.io.tmpdir");
                System.setOut(new PrintStream(new FileOutputStream(new File(temp, "sqleonardo.out"))));
                System.setErr(new PrintStream(new FileOutputStream(new File(temp, "sqleonardo.err"))));
            }
            if (session.canMount("$INFO")) {
                session.mount("$INFO");
                Application.println("version: " + session.jump("version").get(0));
            }
        }
        catch (Exception e) {
            Application.println(e, false);
        }
    }

    public static void shutdown() {
        window.dispose();
        try {
            session.mount("$INFO");
            session.home();
            session.jump("version");
            if (session.jump().size() == 0) {
                session.jump().add(Application.getVersion());
            } else {
                session.jump().set(0, Application.getVersion());
            }
            session.save(Application.sessionFilename());
        }
        catch (IOException e) {
            Application.println(e, false);
        }
        finally {
            System.exit(0);
        }
    }

    private static String sessionFilename() {
        return System.getProperty("user.home") + File.separator + ".sqleonardo";
    }

    public static String getVersion() {
        return "2009.03.rc1";
    }

    public static String getVersion2() {
        return "SQLeonardo." + Application.getVersion();
    }

    public static String getVersion3() {
        return Application.getVersion2() + " [ " + "http://www.nickyb.net" + " ]";
    }

    public static void alert(String title, String message) {
        JOptionPane.showMessageDialog(window, message, title, 2);
    }

    public static boolean confirm(String title, String message) {
        return JOptionPane.showConfirmDialog(window, message, title, 0) == 0;
    }

    public static String input(String title, String message) {
        return JOptionPane.showInputDialog(window, message, title, -1);
    }

    public static void println(Exception e, boolean alert) {
        if (alert) {
            Application.alert(e.getClass().getName(), Text.wrap(e.toString(), 100));
        } else {
            System.out.println(e);
        }
    }

    public static void println(String s) {
        System.out.println(s);
    }

    public static void initI18n() {
        String s = Preferences.getString("app.locale", "en_EN");
        if (s != null && s.length() > 0) {
            String language = s;
            if (s.indexOf("_") > 0) {
                language = s.substring(0, s.indexOf("_"));
                s = s.substring(s.indexOf("_") + 1);
            } else {
                s = "";
            }
            String country = s;
            if (s.indexOf("_") > 0) {
                country = s.substring(0, s.indexOf("_"));
                s = s.substring(s.indexOf("_") + 1);
            } else {
                s = "";
            }
            String variant = s;
            if (language.length() > 0 && country.length() > 0 && variant.length() > 0) {
                I18n.setCurrentLocale(new Locale(language, country, variant));
            } else if (language.length() > 0 && country.length() > 0) {
                I18n.setCurrentLocale(new Locale(language, country));
            } else {
                I18n.setCurrentLocale(new Locale(language));
            }
        }
    }

    public static void main(String[] args) {
        System.setProperty("sun.swing.enableImprovedDragGesture", "");
        if (System.getProperty("nickyb.sqleonardo.laf.class") != null) {
            try {
                UIManager.setLookAndFeel(System.getProperty("nickyb.sqleonardo.laf.class"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("SystemLookAndFeel: " + UIManager.getSystemLookAndFeelClassName());
        Application.loadSession();
        Application.initI18n();
        Application.println("loading resources...");
        Application.loadIcons();
        Application.println("loading window...");
        window = new MDIWindow();
        window.show();
        JWindow wait = new JWindow(window);
        wait.getContentPane().add(new JLabel("wait, auto connections...", 0));
        wait.setSize(250, 40);
        wait.setLocationRelativeTo(window);
        wait.setVisible(true);
        ClientMetadataExplorer cme = (ClientMetadataExplorer)window.getClient("metadata explorer");
        cme.getControl().getNavigator().onFireAutoConnect();
        wait.dispose();
    }
}

