/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nickyb.sqleonardo.common.gui.CommandButton;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.ContentPane;
import nickyb.sqleonardo.environment.ctrl.content.ContentFlag;
import nickyb.sqleonardo.environment.ctrl.content.ContentModel;
import nickyb.sqleonardo.environment.ctrl.content.ContentView;

public class DialogFindReplace
extends JDialog
implements ActionListener {
    private CommandButton btnFind;
    private CommandButton btnReplace;
    private CommandButton btnReplaceAll;
    private JCheckBox chxAll;
    private JCheckBox chxNullFind;
    private JCheckBox chxNullReplace;
    private JCheckBox chxCase;
    private JComboBox cbxColumns;
    private JComboBox cbxOperator;
    private JTextField txtFind;
    private JTextField txtReplace;
    private ContentFlag flag = new ContentFlag();
    private ContentView view;

    public DialogFindReplace(ContentPane content) {
        super((Frame)Application.window, "find/replace");
        this.view = content.getView();
        this.init();
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(Application.window);
        this.setResizable(false);
    }

    @Override
    public void dispose() {
        this.view.mark(null);
        super.dispose();
    }

    private void init() {
        Vector<String> vCols = new Vector<String>();
        for (int i = 0; i < this.view.getColumnCount(); ++i) {
            vCols.addElement(this.view.getColumnName(i));
        }
        JPanel pnlT = new JPanel(new GridLayout(3, 3, 2, 0));
        pnlT.add(new JLabel("find into:"));
        this.cbxColumns = new JComboBox(vCols);
        pnlT.add(this.cbxColumns);
        this.chxAll = new JCheckBox("all columns");
        pnlT.add(this.chxAll);
        this.cbxOperator = new JComboBox<String>(new String[]{"equals", "contains", "starts with", "ends with"});
        pnlT.add(this.cbxOperator);
        this.txtFind = new JTextField();
        pnlT.add(this.txtFind);
        this.chxNullFind = new JCheckBox("null");
        pnlT.add(this.chxNullFind);
        pnlT.add(new JLabel("replace with:"));
        this.txtReplace = new JTextField();
        pnlT.add(this.txtReplace);
        this.chxNullReplace = new JCheckBox("null");
        pnlT.add(this.chxNullReplace);
        JPanel pnlC = new JPanel(new GridLayout(1, 3, 2, 0));
        this.chxCase = new JCheckBox("case sensitive");
        pnlC.add(this.chxCase);
        JPanel pnlB = new JPanel();
        this.btnFind = new CommandButton("find", this);
        pnlB.add(this.btnFind);
        this.btnReplace = new CommandButton("replace", this);
        pnlB.add(this.btnReplace);
        this.btnReplaceAll = new CommandButton("replace all", this);
        pnlB.add(this.btnReplaceAll);
        this.btnReplace.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(8, 10, 0, 10);
        gbc.fill = 2;
        gbc.gridwidth = 0;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)pnlT, gbc);
        this.getContentPane().add((Component)pnlC, gbc);
        this.getContentPane().add((Component)pnlB, gbc);
        this.chxAll.addActionListener(this);
        this.chxNullFind.addActionListener(this);
        this.chxNullReplace.addActionListener(this);
    }

    private void mark(int row, int col) {
        this.flag.block = row / ContentModel.MAX_BLOCK_RECORDS + 1;
        this.flag.row = row - ContentModel.MAX_BLOCK_RECORDS * (this.flag.block - 1);
        this.flag.col = col;
        this.view.getControl().getSlider().setValue(this.flag.block - 1);
        this.view.mark(this.flag);
    }

    private boolean find() {
        int rStart;
        if (this.view.getRowCount() == 0) {
            return false;
        }
        int cStart = this.view.getColumn();
        if (cStart == -1) {
            cStart = 0;
        }
        if ((rStart = this.view.getFlatRow()) == -1) {
            rStart = 0;
        }
        if (!this.chxAll.isSelected()) {
            cStart = this.view.getColumnIndex(this.cbxColumns.getSelectedItem().toString());
        }
        int col = cStart;
        int row = rStart;
        this.view.mark(null);
        do {
            if (this.chxAll.isSelected()) {
                if (++col == this.view.getColumnCount()) {
                    col = 0;
                    if (++row == this.view.getFlatRowCount()) {
                        row = 0;
                    }
                }
            } else if (++row == this.view.getFlatRowCount()) {
                row = 0;
            }
            Object value = this.view.getFlatValueAt(row, col);
            boolean bmark = false;
            if (value != null) {
                String v;
                String f = this.chxCase.isSelected() ? this.txtFind.getText() : this.txtFind.getText().toUpperCase();
                String string = v = this.chxCase.isSelected() ? value.toString() : value.toString().toUpperCase();
                if (this.cbxOperator.getSelectedItem().toString().equals("equals")) {
                    bmark = v.equals(f);
                } else if (this.cbxOperator.getSelectedItem().toString().equals("contains")) {
                    bmark = v.indexOf(f) != -1;
                } else if (this.cbxOperator.getSelectedItem().toString().equals("starts with")) {
                    bmark = v.startsWith(f);
                } else if (this.cbxOperator.getSelectedItem().toString().equals("ends with")) {
                    bmark = v.endsWith(f);
                }
            } else {
                bmark = this.chxNullFind.isSelected();
            }
            if (!bmark) continue;
            this.mark(row, col);
            return true;
        } while (col != cStart || row != rStart);
        Application.alert("SQLeonardo", "Value not found!");
        return false;
    }

    private boolean replace() {
        String value = this.txtReplace.getText();
        if (this.chxNullReplace.isSelected()) {
            value = null;
        }
        this.view.getControl().getSlider().setValue(this.flag.block - 1);
        this.view.setValueAt(value, this.flag.row, this.flag.col);
        this.view.mark(null);
        return this.find();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.cbxColumns.setEnabled(!this.chxAll.isSelected());
        this.cbxOperator.setEnabled(!this.chxNullFind.isSelected());
        this.txtFind.setEnabled(!this.chxNullFind.isSelected());
        this.txtReplace.setEnabled(!this.chxNullReplace.isSelected());
        if (ae.getSource() == this.btnFind) {
            this.btnReplace.setEnabled(this.find());
        } else if (ae.getSource() == this.btnReplace) {
            this.btnReplace.setEnabled(this.replace());
        } else if (ae.getSource() == this.btnReplaceAll) {
            this.btnReplace.setEnabled(false);
            while (this.replace()) {
            }
        }
    }
}

