/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.Component;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import nickyb.sqleonardo.common.gui.AbstractDialogModal;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.ContentPane;
import nickyb.sqleonardo.environment.ctrl.content.ContentChanges;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.querybuilder.syntax.SQLFormatter;

public class DialogPreview
extends AbstractDialogModal {
    private JTextArea syntaxes;
    private ContentPane content;

    public DialogPreview(ContentPane content) {
        super((Component)Application.window, "changes");
        this.content = content;
        this.syntaxes = new JTextArea();
        this.getContentPane().add(new JScrollPane(this.syntaxes));
        this.syntaxes.setEditable(false);
    }

    @Override
    protected void onOpen() {
        ConnectionHandler ch = ConnectionAssistant.getHandler(this.content.getHandlerKey());
        for (int row = 0; row < this.content.getView().getChanges().count(); ++row) {
            Vector<String> columns = new Vector<String>();
            Vector<String> values = new Vector<String>();
            String sql = new String();
            ContentChanges.Handler handler = this.content.getView().getChanges().getHandlerAt(row);
            Object[] rowdata = this.content.getView().getValues(handler.rid);
            if (handler.type.equals(ContentChanges.INSERT)) {
                for (int col = 0; col < rowdata.length; ++col) {
                    QueryTokens._Expression[] e = this.content.getQueryModel().getQueryExpression().getQuerySpecification().getSelectList();
                    if (!this.content.getUpdateModel().isUpdatable(e[col])) continue;
                    Object cell = rowdata[col];
                    if (rowdata[col] instanceof Object[]) {
                        cell = ((Object[])rowdata[col])[0];
                    }
                    values.addElement(this.toJdbcValue(cell, col));
                    String cname = ((QueryTokens.Column)e[col]).getName();
                    columns.addElement(SQLFormatter.ensureQuotes(cname, ch.getObject("$identifierQuoteString").toString(), true));
                }
                sql = this.content.getUpdateModel().getInsertSyntax(columns.toArray(new String[columns.size()]), values.toArray());
            } else {
                Object cell;
                Vector<String> whereValues = new Vector<String>();
                for (int j = 0; j < this.content.getUpdateModel().getRowIdentifierCount(); ++j) {
                    int col = this.content.getView().getColumnIndex(this.content.getUpdateModel().getRowIdentifier(j).getReference());
                    if (col == -1) {
                        col = this.content.getView().getColumnIndex(this.content.getUpdateModel().getRowIdentifier(j).getName());
                    }
                    if ((cell = rowdata[col]) instanceof Object[]) {
                        cell = ((Object[])cell)[1];
                    }
                    whereValues.addElement(this.toJdbcValue(cell, j));
                }
                if (handler.type.equals(ContentChanges.DELETE)) {
                    sql = this.content.getUpdateModel().getDeleteSyntax(whereValues.toArray());
                } else if (handler.type.equals(ContentChanges.UPDATE)) {
                    for (int col = 0; col < rowdata.length; ++col) {
                        if (!(rowdata[col] instanceof Object[])) continue;
                        QueryTokens._Expression[] e = this.content.getQueryModel().getQueryExpression().getQuerySpecification().getSelectList();
                        if (!this.content.getUpdateModel().isUpdatable(e[col])) continue;
                        cell = ((Object[])rowdata[col])[0];
                        values.addElement(this.toJdbcValue(cell, col));
                        String cname = ((QueryTokens.Column)e[col]).getName();
                        columns.addElement(SQLFormatter.ensureQuotes(cname, ch.getObject("$identifierQuoteString").toString(), true));
                    }
                    sql = this.content.getUpdateModel().getUpdateSyntax(columns.toArray(new String[columns.size()]), values.toArray(), whereValues.toArray());
                }
            }
            this.syntaxes.append(sql.trim() + ";\n");
        }
    }

    private String toJdbcValue(Object value, int col) {
        return SQLFormatter.toJdbcValue(value, this.content.getView().getColumnType(col));
    }
}

