/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import nickyb.sqleonardo.common.gui.AbstractDialogConfirm;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.gui.CheckBoxCellRenderer;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.ContentPane;
import nickyb.sqleonardo.environment.ctrl.content.UpdateModel;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class DialogUpdateCriteria
extends AbstractDialogConfirm
implements ItemListener {
    private ContentPane content;
    private JComboBox tables;
    private JTable columns;
    private int[] expressionIndices;

    public DialogUpdateCriteria(ContentPane content) {
        super((Component)Application.window, "define update criteria", 350, 275);
        this.content = content;
        DefaultTableModel model = new DefaultTableModel(0, 2){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }
        };
        this.columns = new JTable(model);
        JScrollPane scroll = new JScrollPane(this.columns);
        scroll.getViewport().setBackground(UIManager.getDefaults().getColor("Table.background"));
        BorderLayoutPanel mask = new BorderLayoutPanel();
        this.tables = new JComboBox();
        mask.setComponentNorth(this.tables);
        mask.setComponentCenter(scroll);
        TableColumn tableColumn = this.columns.getColumn(this.columns.getColumnName(0));
        tableColumn.setCellEditor(new CheckBoxCellRenderer());
        tableColumn.setCellRenderer(new CheckBoxCellRenderer());
        tableColumn.setPreferredWidth(15);
        tableColumn.setMaxWidth(15);
        tableColumn.setResizable(false);
        this.columns.setSelectionMode(0);
        this.columns.setIntercellSpacing(new Dimension(0, 0));
        this.columns.setShowGrid(false);
        this.columns.setColumnSelectionAllowed(false);
        this.columns.setDefaultRenderer(Boolean.class, new CheckBoxCellRenderer());
        this.columns.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.columns.getTableHeader().setVisible(false);
        this.getContentPane().add(mask);
    }

    @Override
    protected boolean onConfirm() {
        if (this.tables.getSelectedItem() == null) {
            return false;
        }
        UpdateModel um = new UpdateModel();
        QueryTokens._TableReference[] r = this.content.getQueryModel().getQueryExpression().getQuerySpecification().getFromClause();
        for (int i = 0; i < r.length; ++i) {
            if (r[i] instanceof QueryTokens.Table) {
                if (!((QueryTokens.Table)r[i]).getReference().equalsIgnoreCase(this.tables.getSelectedItem().toString())) continue;
                um.setTable((QueryTokens.Table)r[i]);
                break;
            }
            if (((QueryTokens.Join)r[i]).getPrimary().getTable().getReference().equalsIgnoreCase(this.tables.getSelectedItem().toString())) {
                um.setTable(((QueryTokens.Join)r[i]).getPrimary().getTable());
                break;
            }
            if (!((QueryTokens.Join)r[i]).getForeign().getTable().getReference().equalsIgnoreCase(this.tables.getSelectedItem().toString())) continue;
            um.setTable(((QueryTokens.Join)r[i]).getForeign().getTable());
            break;
        }
        Vector<QueryTokens.Column> rowid = new Vector<QueryTokens.Column>();
        for (int i = 0; i < this.columns.getRowCount(); ++i) {
            if (!((Boolean)this.columns.getValueAt(i, 0)).booleanValue()) continue;
            QueryTokens._Expression[] e = this.content.getQueryModel().getQueryExpression().getQuerySpecification().getSelectList();
            QueryTokens.Column c = (QueryTokens.Column)e[this.expressionIndices[i]];
            rowid.addElement(c);
        }
        if (rowid.size() == 0) {
            return false;
        }
        QueryTokens.Column[] c = new QueryTokens.Column[rowid.size()];
        um.setRowIdentifier(rowid.toArray(c));
        this.content.setUpdateModel(um);
        return true;
    }

    @Override
    protected void onOpen() {
        QueryTokens._TableReference[] r = this.content.getQueryModel().getQueryExpression().getQuerySpecification().getFromClause();
        for (int i = 0; i < r.length; ++i) {
            if (r[i] instanceof QueryTokens.Table) {
                ((DefaultComboBoxModel)this.tables.getModel()).addElement(((QueryTokens.Table)r[i]).getReference());
                continue;
            }
            ((DefaultComboBoxModel)this.tables.getModel()).addElement(((QueryTokens.Join)r[i]).getPrimary().getTable().getReference());
            ((DefaultComboBoxModel)this.tables.getModel()).addElement(((QueryTokens.Join)r[i]).getForeign().getTable().getReference());
        }
        this.tables.setSelectedItem(null);
        this.tables.addItemListener(this);
        if (!this.content.isReadOnly() && this.content.getUpdateModel().getTable() != null) {
            String reference = this.content.getUpdateModel().getTable().getReference();
            this.tables.setSelectedItem(reference);
            for (int i = 0; i < this.content.getUpdateModel().getRowIdentifierCount(); ++i) {
                QueryTokens.Column cpk = this.content.getUpdateModel().getRowIdentifier(i);
                for (int j = 0; j < this.columns.getRowCount(); ++j) {
                    QueryTokens._Expression[] e = this.content.getQueryModel().getQueryExpression().getQuerySpecification().getSelectList();
                    QueryTokens.Column c = (QueryTokens.Column)e[this.expressionIndices[j]];
                    if (!cpk.getName().equalsIgnoreCase(c.getName())) continue;
                    this.columns.setValueAt(new Boolean(true), j, 0);
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() instanceof JComboBox) {
            ((DefaultTableModel)this.columns.getModel()).setRowCount(0);
            String reference = this.tables.getSelectedItem().toString();
            QueryTokens._Expression[] e = this.content.getQueryModel().getQueryExpression().getQuerySpecification().getSelectList();
            this.expressionIndices = new int[e.length];
            int j = 0;
            for (int i = 0; i < e.length; ++i) {
                String headerLabel;
                if (!(e[i] instanceof QueryTokens.Column)) continue;
                QueryTokens.Column c = (QueryTokens.Column)e[i];
                String string = headerLabel = c.isAliasSet() ? c.getAlias() : c.getName();
                if (this.tables.getItemCount() != 1 && !c.getTable().getReference().equalsIgnoreCase(reference)) continue;
                ((DefaultTableModel)this.columns.getModel()).addRow(new Object[]{new Boolean(false), headerLabel});
                this.expressionIndices[j++] = i;
            }
        }
    }
}

