/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.sql.PreparedStatement;
import java.util.Vector;
import javax.swing.JOptionPane;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.common.util.Text;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.ContentPane;
import nickyb.sqleonardo.environment.ctrl.content.ContentChanges;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;
import nickyb.sqleonardo.querybuilder.syntax.SQLFormatter;

public class TaskUpdate
implements Runnable {
    private ContentPane target = null;
    private PreparedStatement pstmt = null;

    public TaskUpdate(ContentPane target) {
        this.target = target;
    }

    @Override
    public void run() {
        ConnectionHandler ch = ConnectionAssistant.getHandler(this.target.getHandlerKey());
        int exceptions = 0;
        while (this.target.getView().getChanges().count() > exceptions) {
            String cname;
            Object cell;
            int i;
            Vector<String> columns = new Vector<String>();
            Vector<Object[]> params = new Vector<Object[]>();
            String sql = new String();
            ContentChanges.Handler handler = this.target.getView().getChanges().getHandlerAt(exceptions);
            Object[] rowdata = this.target.getView().getValues(handler.rid);
            if (handler.type.equals(ContentChanges.INSERT)) {
                for (i = 0; i < rowdata.length; ++i) {
                    QueryTokens._Expression[] e = this.target.getQueryModel().getQueryExpression().getQuerySpecification().getSelectList();
                    if (!this.target.getUpdateModel().isUpdatable(e[i])) continue;
                    cell = rowdata[i];
                    if (rowdata[i] instanceof Object[]) {
                        cell = ((Object[])rowdata[i])[0];
                    }
                    params.addElement(new Object[]{cell, new Integer(this.target.getView().getColumnType(i))});
                    cname = ((QueryTokens.Column)e[i]).getName();
                    columns.addElement(SQLFormatter.ensureQuotes(cname, ch.getObject("$identifierQuoteString").toString(), true));
                }
                sql = this.target.getUpdateModel().getInsertSyntax(columns.toArray(new String[columns.size()]));
            } else {
                if (handler.type.equals(ContentChanges.DELETE)) {
                    sql = this.target.getUpdateModel().getDeleteSyntax();
                } else if (handler.type.equals(ContentChanges.UPDATE)) {
                    for (int i2 = 0; i2 < rowdata.length; ++i2) {
                        if (!(rowdata[i2] instanceof Object[])) continue;
                        QueryTokens._Expression[] e = this.target.getQueryModel().getQueryExpression().getQuerySpecification().getSelectList();
                        if (!this.target.getUpdateModel().isUpdatable(e[i2])) continue;
                        cell = ((Object[])rowdata[i2])[0];
                        params.addElement(new Object[]{cell, new Integer(this.target.getView().getColumnType(i2))});
                        cname = ((QueryTokens.Column)e[i2]).getName();
                        columns.addElement(SQLFormatter.ensureQuotes(cname, ch.getObject("$identifierQuoteString").toString(), true));
                    }
                    sql = this.target.getUpdateModel().getUpdateSyntax(columns.toArray(new String[columns.size()]));
                }
                for (i = 0; i < this.target.getUpdateModel().getRowIdentifierCount(); ++i) {
                    int col = this.target.getView().getColumnIndex(this.target.getUpdateModel().getRowIdentifier(i).getReference());
                    if (col == -1) {
                        col = this.target.getView().getColumnIndex(this.target.getUpdateModel().getRowIdentifier(i).getName());
                    }
                    if ((cell = rowdata[col]) instanceof Object[]) {
                        cell = ((Object[])cell)[1];
                    }
                    params.addElement(new Object[]{cell, new Integer(this.target.getView().getColumnType(i))});
                }
            }
            try {
                this.close();
            }
            catch (Exception e) {
                Application.println(e, true);
            }
            try {
                this.execute(sql.toString(), params);
                for (int i3 = 0; i3 < rowdata.length; ++i3) {
                    Object cell2;
                    if (!(rowdata[i3] instanceof Object[])) continue;
                    rowdata[i3] = cell2 = ((Object[])rowdata[i3])[0];
                }
                this.target.getView().getChanges().removeHandlerAt(exceptions);
            }
            catch (Exception e) {
                if (!this.alert(e)) break;
                ++exceptions;
            }
        }
        this.target.getView().onTableChanged(true);
        this.target.doStop();
    }

    private boolean alert(Exception e) {
        String title = e.getClass().getName();
        String message = Text.wrap(e.toString(), 75);
        return JOptionPane.showConfirmDialog(Application.window, message = message + "\ndo you want continue?", title, 0) == 0;
    }

    private void close() throws Exception {
        if (this.pstmt != null) {
            this.pstmt.close();
            this.pstmt = null;
        }
    }

    private void execute(String sql, Vector values) throws Exception {
        ConnectionHandler ch = ConnectionAssistant.getHandler(this.target.getHandlerKey());
        this.pstmt = ch.get().prepareStatement(sql);
        block7: for (int i = 0; i < values.size(); ++i) {
            Object[] param = (Object[])values.elementAt(i);
            if (param[0] == null) {
                this.pstmt.setNull(i + 1, (Integer)param[1]);
                continue;
            }
            switch ((Integer)param[1]) {
                case -1: 
                case 1: 
                case 12: {
                    this.pstmt.setString(i + 1, (String)param[0]);
                    continue block7;
                }
                case 3: 
                case 8: {
                    this.pstmt.setDouble(i + 1, new Double(param[0].toString()));
                    continue block7;
                }
                case 6: {
                    this.pstmt.setFloat(i + 1, new Float(param[0].toString()).floatValue());
                    continue block7;
                }
                case 4: {
                    this.pstmt.setInt(i + 1, new Integer(param[0].toString()));
                }
                case 2: {
                    this.pstmt.setLong(i + 1, new Long(param[0].toString()));
                    continue block7;
                }
                default: {
                    this.pstmt.setObject(i + 1, param[0], (Integer)param[1]);
                }
            }
        }
        this.pstmt.executeUpdate();
        this.close();
    }
}

