/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.editor;

import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import nickyb.sqleonardo.environment.ctrl.editor.BaseDynamicTable;
import nickyb.sqleonardo.environment.ctrl.editor._ClauseOwner;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class ClauseCondition
extends BaseDynamicTable {
    protected Vector querytokens;
    protected JComboBox cbxCols;

    public ClauseCondition(_ClauseOwner owner) {
        super(owner, 4);
    }

    @Override
    void initTableModel(int col) {
        super.initTableModel(col);
        String[] operation = new String[]{"=", "<", ">", "<=", ">=", "<>", "like", "not like", "is", "is not", "in", "not in"};
        TableColumn tableColumn = this.getColumn(1);
        this.cbxCols = new JComboBox();
        tableColumn.setCellEditor(new DefaultCellEditor(this.cbxCols));
        tableColumn = this.getColumn(2);
        tableColumn.setPreferredWidth(60);
        tableColumn.setMaxWidth(60);
        tableColumn.setResizable(false);
        tableColumn.setCellEditor(new DefaultCellEditor(new JComboBox<String>(operation)));
        tableColumn = this.getColumn(4);
        tableColumn.setPreferredWidth(55);
        tableColumn.setMaxWidth(55);
        tableColumn.setResizable(false);
        tableColumn.setCellEditor(new DefaultCellEditor(new JComboBox<String>(new String[]{"AND", "OR"})));
        this.querytokens = new Vector();
        this.cbxCols.setEditable(true);
        this.getModel().addTableModelListener(new ChangeHandler());
    }

    public void addColumn(String text) {
        this.cbxCols.addItem(text);
    }

    public void removeColumn(String text) {
        this.cbxCols.removeItem(text);
    }

    private void onDelete(int row) {
        QueryTokens.Condition token = (QueryTokens.Condition)this.querytokens.elementAt(row);
        this.querytokens.removeElementAt(row);
        if (this.querytokens.size() > 0 && row < this.querytokens.size()) {
            QueryTokens.Condition next = (QueryTokens.Condition)this.querytokens.get(row);
            next.setAppend(token.getAppend());
        }
    }

    private void onInsert(int row) {
        QueryTokens.Condition token = new QueryTokens.Condition(null, "=", null);
        this.querytokens.addElement(token);
        this.setValueAt("=", row, 2);
        if (row > 0) {
            Object append = this.getValueAt(row - 1, 4);
            if (append == null) {
                append = "AND";
                this.setValueAt(append, row - 1, 4);
            }
            token.setAppend(append.toString());
        }
    }

    private void onUpdate(int row, int col) {
        if (col > 0) {
            Object value = this.getValueAt(row, col);
            if (value == null) {
                value = "";
            }
            QueryTokens.Condition cond = (QueryTokens.Condition)this.querytokens.elementAt(row);
            if (col == 1) {
                cond.setLeft(new QueryTokens.DefaultExpression(value.toString()));
            } else if (col == 2) {
                cond.setOperator(value.toString());
            } else if (col == 3) {
                cond.setRight(new QueryTokens.DefaultExpression(value.toString()));
            } else if (col == 4 && row + 2 < this.getRowCount()) {
                cond = (QueryTokens.Condition)this.querytokens.elementAt(row + 1);
                cond.setAppend(value.toString());
            }
        }
    }

    class ChangeHandler
    implements TableModelListener {
        ChangeHandler() {
        }

        @Override
        public void tableChanged(TableModelEvent tme) {
            switch (tme.getType()) {
                case -1: {
                    ClauseCondition.this.onDelete(tme.getFirstRow());
                    break;
                }
                case 1: {
                    ClauseCondition.this.onInsert(tme.getFirstRow());
                    break;
                }
                case 0: {
                    ClauseCondition.this.onUpdate(tme.getFirstRow(), tme.getColumn());
                }
            }
            ClauseCondition.this.owner.fireQueryChanged();
        }
    }
}

