/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.util.Classpath;
import nickyb.sqleonardo.common.util.Text;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDriver;

public class MaskDriver
extends JPanel {
    private JTextField txtName;
    private JTextField txtFile;
    private JTextField txtExample;
    private JComboBox cbxDriver;

    MaskDriver() {
        this.setBorder(LineBorder.createGrayLineBorder());
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.txtName = new JTextField();
        this.addField(gbl, "name:", this.txtName, 0);
        this.txtFile = new JTextField();
        this.addField(gbl, "file:", this.txtFile, 25);
        this.cbxDriver = new JComboBox();
        this.addField(gbl, "driver:", this.cbxDriver, 5);
        this.txtExample = new JTextField();
        this.addField(gbl, "example:", this.txtExample, 5);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(25, 8, 0, 8);
        this.txtFile.setEditable(false);
        this.cbxDriver.setEditable(true);
        this.cbxDriver.setPreferredSize(this.txtFile.getPreferredSize());
    }

    private void addField(GridBagLayout gbl, String text, JComponent txt, int top) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(top, 8, 1, 8);
        JLabel lbl = new JLabel(text);
        gbl.setConstraints(lbl, gbc);
        this.add(lbl);
        gbc.fill = 2;
        gbc.insets = new Insets(0, 8, 0, 8);
        gbc.weightx = 1.0;
        gbl.setConstraints(txt, gbc);
        this.add(txt);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).setEnabled(b);
        }
    }

    void addDriver(String classname) {
        this.cbxDriver.addItem(classname);
    }

    void clearDrivers() {
        this.cbxDriver.removeAllItems();
    }

    void load(UoDriver uoDv) {
        this.txtName.setText(uoDv.name);
        this.txtFile.setText(uoDv.library);
        this.txtExample.setText(uoDv.example);
        this.cbxDriver.setSelectedItem(uoDv.classname);
        if (this.cbxDriver.getSelectedIndex() == -1 && !Text.isEmpty(uoDv.classname)) {
            this.cbxDriver.addItem(uoDv.classname);
        }
    }

    boolean unload(UoDriver uoDv) {
        if (Text.isEmpty(this.txtName.getText()) || this.cbxDriver.getSelectedItem() == null || Text.isEmpty(this.cbxDriver.getSelectedItem().toString())) {
            Application.alert("SQLeonardo", "the values aren't complete!");
            return false;
        }
        if (this.txtName.getText().indexOf(46) != -1 || this.txtName.getText().indexOf(44) != -1 || this.txtName.getText().indexOf(59) != -1 || this.txtName.getText().indexOf(58) != -1 || this.txtName.getText().indexOf(124) != -1 || this.txtName.getText().indexOf(47) != -1 || this.txtName.getText().indexOf(60) != -1 || this.txtName.getText().indexOf(62) != -1 || this.txtName.getText().indexOf(64) != -1 || this.txtName.getText().indexOf(92) != -1) {
            Application.alert("SQLeonardo", "characters \\.|,/;<:>@ aren't allowed!\nplease, enter a valid name.");
            return false;
        }
        try {
            String name = this.txtName.getText().trim();
            String file = this.txtFile.getText().trim();
            String classname = this.cbxDriver.getSelectedItem().toString().trim();
            ConnectionAssistant.declare(file, classname, !Classpath.isRuntime(file));
            if (uoDv.name != null && !name.equals(uoDv.name)) {
                Application.session.mount("$PREFERENCES");
                Application.session.home();
                Application.session.jump("metaview." + uoDv.name);
                Enumeration e = Application.session.jumps();
                while (e.hasMoreElements()) {
                    String metaview = e.nextElement().toString();
                    Iterator i = Application.session.jump(metaview).iterator();
                    Application.session.home();
                    Application.session.jump("metaview." + name);
                    Application.session.jump(metaview);
                    while (i.hasNext()) {
                        Application.session.jump().add(i.next());
                    }
                    Application.session.home();
                    Application.session.jump("metaview." + uoDv.name);
                }
                Application.session.home();
                Application.session.ujump("metaview." + uoDv.name);
            }
            uoDv.name = name;
            uoDv.library = file;
            uoDv.classname = classname;
            uoDv.example = this.txtExample.getText().trim();
            return true;
        }
        catch (Exception e) {
            Application.println(e, true);
            return false;
        }
    }
}

