/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import nickyb.sqleonardo.common.gui.TreeView;
import nickyb.sqleonardo.common.util.Classpath;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDriver;

class MaskLibraries
extends TreeView
implements TreeWillExpandListener {
    MaskLibraries() {
        this.addTreeWillExpandListener(this);
        this.loadLibraries();
    }

    void addLibrary(String filename, boolean reload) {
        DefaultMutableTreeNode root = this.getRootNode();
        root.add(new DefaultMutableTreeNode(filename, true));
        if (reload) {
            this.reloadRoot();
        }
    }

    void loadLibraries() {
        Iterator i = Classpath.getLibraries().iterator();
        while (i.hasNext()) {
            this.addLibrary(i.next().toString(), false);
        }
        this.reloadRoot();
    }

    void setLibrary(String filename) {
        DefaultMutableTreeNode root = this.getRootNode();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
            if (!node.toString().equals(filename)) continue;
            this.setSelectionNode(node);
        }
    }

    String getLibrary() {
        if (!this.isSelectionEmpty()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getSelectionPath().getPathComponent(1);
            return node.toString();
        }
        return null;
    }

    private String getClassName() {
        if (!this.isSelectionEmpty() && this.getSelectionPath().getPathCount() == 3) {
            String classname = this.getSelectionPath().getLastPathComponent().toString();
            return classname.substring(0, classname.indexOf(".class"));
        }
        return null;
    }

    boolean unload(UoDriver uoDv) {
        String classname = this.getClassName();
        if (classname != null) {
            uoDv.classname = classname;
        }
        return true;
    }

    private void onLibraryExpand(DefaultMutableTreeNode node) {
        if (node.getChildCount() > 0) {
            return;
        }
        try {
            ZipFile zf = new ZipFile(node.toString());
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.endsWith(".class") || name.indexOf("$") != -1) continue;
                name = name.replace('/', '.');
                node.add(new DefaultMutableTreeNode(name, false));
            }
            this.reload(node);
        }
        catch (IOException e) {
            Application.println(e, true);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent tee) throws ExpandVetoException {
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent tee) throws ExpandVetoException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tee.getPath().getLastPathComponent();
        this.onLibraryExpand(node);
    }
}

