/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.explorer.DialogDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.DialogDriver;
import nickyb.sqleonardo.environment.ctrl.explorer.SideNavigator;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDatasource;
import nickyb.sqleonardo.environment.ctrl.explorer.UoDriver;

public class SideNavigatorMouse
extends MouseAdapter {
    private SideNavigator navigator;
    private JPopupMenu popup;

    SideNavigatorMouse(SideNavigator navigator) {
        this.navigator = navigator;
        this.popup = new JPopupMenu();
        this.popup.add(new ActionConnect());
        this.popup.add(new ActionNewDriver());
        this.popup.add(new ActionNewDatasource());
        this.popup.addSeparator();
        this.popup.add(new ActionSchemaFilter("set as default schema"));
        this.popup.add(new ActionSchemaFilter("remove schema filter"));
        this.popup.addSeparator();
        this.popup.add(new ActionDelete());
        this.popup.add(new ActionDuplicate());
        this.popup.addSeparator();
        this.popup.add(new ActionProperties());
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (SwingUtilities.isRightMouseButton(me)) {
            this.popup.getComponent(0).setVisible(false);
            this.popup.getComponent(1).setVisible(false);
            this.popup.getComponent(2).setVisible(false);
            this.popup.getComponent(3).setVisible(false);
            this.popup.getComponent(4).setVisible(false);
            this.popup.getComponent(5).setVisible(false);
            for (int i = 0; i < this.popup.getComponentCount(); ++i) {
                this.popup.getComponent(i).setEnabled(false);
            }
            this.navigator.setSelectionForLocation(me.getPoint());
            if (!this.navigator.isSelectionEmpty()) {
                if (this.navigator.getSelectionPath().getPathCount() == 3) {
                    ConnectionHandler ch;
                    UoDatasource uoDs = (UoDatasource)this.navigator.getSelectionNode().getUserObject();
                    ((JCheckBoxMenuItem)this.popup.getComponent(0)).setSelected(uoDs.isConnected());
                    this.popup.getComponent(0).setVisible(true);
                    this.popup.getComponent(0).setEnabled(true);
                    ConnectionHandler connectionHandler = ch = uoDs.isConnected() ? ConnectionAssistant.getHandler(uoDs.getKey()) : null;
                    if (uoDs.schema != null || ch != null && ((Boolean)ch.getObject("$supportsSchema")).booleanValue()) {
                        this.popup.getComponent(3).setVisible(true);
                        this.popup.getComponent(5).setVisible(true);
                        this.popup.getComponent(5).setEnabled(uoDs.schema != null);
                    }
                } else if (this.navigator.getSelectionPath().getPathCount() == 4) {
                    if (this.navigator.getSelectionNode().getAllowsChildren()) {
                        this.popup.getComponent(4).setVisible(true);
                        this.popup.getComponent(4).setEnabled(true);
                    }
                } else {
                    this.popup.getComponent(2).setVisible(this.navigator.getSelectionPath().getPathCount() == 2);
                    this.popup.getComponent(2).setEnabled(this.navigator.getSelectionPath().getPathCount() == 2);
                }
                this.popup.getComponent(7).setEnabled(this.navigator.getSelectionPath().getPathCount() == 2 || this.navigator.getSelectionPath().getPathCount() == 3);
                this.popup.getComponent(8).setEnabled(this.navigator.getSelectionPath().getPathCount() == 2 || this.navigator.getSelectionPath().getPathCount() == 3);
                this.popup.getComponent(10).setEnabled(this.navigator.getSelectionPath().getPathCount() == 2 || this.navigator.getSelectionPath().getPathCount() == 3);
            } else {
                this.popup.getComponent(1).setEnabled(true);
                this.popup.getComponent(1).setVisible(true);
            }
            if (this.navigator.isSelectionEmpty() || this.navigator.getSelectionNode().getAllowsChildren()) {
                this.popup.show((JTree)me.getSource(), me.getX(), me.getY());
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (me.getModifiers() == 17) {
            this.doSchemaFilter();
        }
    }

    private void doSchemaFilter() {
        if (!this.navigator.isSelectionEmpty()) {
            DefaultMutableTreeNode node = this.navigator.getSelectionNode();
            if (node.getUserObject() instanceof UoDatasource) {
                UoDatasource uoDs = (UoDatasource)node.getUserObject();
                if (uoDs.schema != null) {
                    uoDs.schema = null;
                    this.navigator.reload(node);
                }
            } else {
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
                if (parent.getUserObject() instanceof UoDatasource && node.getAllowsChildren()) {
                    UoDatasource uoDs = (UoDatasource)parent.getUserObject();
                    uoDs.schema = node.toString();
                    this.navigator.reload(parent);
                }
            }
        }
    }

    private class ActionSchemaFilter
    extends AbstractAction {
        private ActionSchemaFilter(String label) {
            this.putValue("Name", label);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            SideNavigatorMouse.this.doSchemaFilter();
        }
    }

    private class ActionConnect
    extends JCheckBoxMenuItem
    implements ActionListener {
        ActionConnect() {
            super("connect");
            this.addActionListener(this);
            this.setSelected(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            UoDatasource uoDs = (UoDatasource)SideNavigatorMouse.this.navigator.getSelectionNode().getUserObject();
            try {
                if (this.isSelected() && !uoDs.isConnected()) {
                    uoDs.connect();
                    Application.window.connectionOpened(uoDs.getKey());
                } else if (!this.isSelected() && uoDs.isConnected()) {
                    uoDs.disconnect();
                    Application.window.connectionClosed(uoDs.getKey());
                }
                SideNavigatorMouse.this.navigator.reloadSelection();
            }
            catch (Exception e) {
                Application.println(e, true);
            }
            finally {
                this.setSelected(uoDs.isConnected());
            }
        }
    }

    private class ActionProperties
    extends AbstractAction {
        private ActionProperties() {
            this.putValue("Name", "properties...");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (SideNavigatorMouse.this.navigator.isSelectionEmpty()) {
                return;
            }
            DefaultMutableTreeNode node = SideNavigatorMouse.this.navigator.getSelectionNode();
            if (node.getUserObject() instanceof UoDriver) {
                DialogDriver dlg = new DialogDriver(SideNavigatorMouse.this.navigator, 1);
                dlg.setVisible(true);
            } else if (node.getUserObject() instanceof UoDatasource) {
                DialogDatasource dlg = new DialogDatasource(SideNavigatorMouse.this.navigator, 1);
                dlg.setVisible(true);
            }
        }
    }

    private class ActionDuplicate
    extends AbstractAction {
        private ActionDuplicate() {
            this.putValue("Name", "duplicate...");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (SideNavigatorMouse.this.navigator.isSelectionEmpty()) {
                return;
            }
            DefaultMutableTreeNode node = SideNavigatorMouse.this.navigator.getSelectionNode();
            if (node.getUserObject() instanceof UoDriver) {
                DialogDriver dlg = new DialogDriver(SideNavigatorMouse.this.navigator, 2);
                dlg.setVisible(true);
            } else if (node.getUserObject() instanceof UoDatasource) {
                DialogDatasource dlg = new DialogDatasource(SideNavigatorMouse.this.navigator, 2);
                dlg.setVisible(true);
            }
        }
    }

    private class ActionDelete
    extends AbstractAction {
        private ActionDelete() {
            this.putValue("Name", "delete");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            SideNavigatorMouse.this.navigator.remove();
        }
    }

    private class ActionNewDatasource
    extends AbstractAction {
        private ActionNewDatasource() {
            this.putValue("Name", "new datasource...");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (SideNavigatorMouse.this.navigator.isSelectionEmpty()) {
                Application.alert("SQLeonardo", "select one driver!");
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)SideNavigatorMouse.this.navigator.getSelectionPath().getPathComponent(1);
            SideNavigatorMouse.this.navigator.setSelectionNode(node);
            DialogDatasource dlg = new DialogDatasource(SideNavigatorMouse.this.navigator, 0);
            dlg.setVisible(true);
        }
    }

    private class ActionNewDriver
    extends AbstractAction {
        private ActionNewDriver() {
            this.putValue("Name", "new driver...");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DialogDriver dlg = new DialogDriver(SideNavigatorMouse.this.navigator, 0);
            dlg.setVisible(true);
        }
    }
}

