/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.explorer;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import nickyb.sqleonardo.common.gui.CommandButton;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.explorer.ViewSearchResult;
import nickyb.sqleonardo.environment.mdi._ConnectionListener;

public class SideSearchCriteria
extends JPanel
implements ActionListener,
_ConnectionListener {
    private String[] operators = new String[]{"equals", "contains", "starts with", "ends with"};
    private ViewSearchResult rView;
    private JComboBox cbxConnections;
    private CommandButton cbStart;
    private CommandButton cbReset;
    private JComboBox[] cbx;
    private JTextField[] txt;

    public SideSearchCriteria() {
        Application.window.addListener(this);
        this.setBackground(Color.white);
        this.setBorder(LineBorder.createGrayLineBorder());
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        this.cbx = new JComboBox[3];
        this.txt = new JTextField[3];
        this.addCriteria(0, gbl, "schema", 25);
        this.addCriteria(1, gbl, "table", 5);
        this.addCriteria(2, gbl, "column", 5);
        this.addConnection(gbl);
        this.addButtons(gbl);
        this.rView = new ViewSearchResult();
    }

    private void addCriteria(int idx, GridBagLayout gbl, String where, int top_gap) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(top_gap, 5, 1, 5);
        JLabel lbl = new JLabel(where + ":");
        gbl.setConstraints(lbl, gbc);
        this.add(lbl);
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.cbx[idx] = new JComboBox<String>(this.operators);
        gbl.setConstraints(this.cbx[idx], gbc);
        this.add(this.cbx[idx]);
        gbc.insets = new Insets(0, 5, 0, 5);
        this.txt[idx] = new JTextField();
        this.txt[idx].addActionListener(this);
        gbl.setConstraints(this.txt[idx], gbc);
        this.add(this.txt[idx]);
        this.cbx[idx].setPreferredSize(this.txt[idx].getPreferredSize());
    }

    private void addConnection(GridBagLayout gbl) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 5, 1, 5);
        JLabel lbl = new JLabel("use connection:");
        gbl.setConstraints(lbl, gbc);
        this.add(lbl);
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 8, 5);
        this.cbxConnections = new JComboBox();
        gbl.setConstraints(this.cbxConnections, gbc);
        this.add(this.cbxConnections);
    }

    private void addButtons(GridBagLayout gbl) {
        JPanel pnl = new JPanel();
        this.cbStart = new CommandButton("start", this);
        pnl.add(this.cbStart);
        this.cbReset = new CommandButton("reset", this);
        pnl.add(this.cbReset);
        pnl.setOpaque(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.gridwidth = 2;
        gbc.weighty = 1.0;
        gbl.setConstraints(pnl, gbc);
        this.add(pnl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.cbReset) {
            this.rView.reset();
            this.rView.setInfo("...");
            this.cbxConnections.setSelectedItem(null);
            for (int i = 0; i < this.cbx.length; ++i) {
                this.cbx[i].setSelectedIndex(0);
                this.txt[i].setText(null);
            }
        } else {
            if (this.cbxConnections.getSelectedIndex() == -1) {
                return;
            }
            String schema = this.getSearchString(0);
            String table = this.getSearchString(1);
            String column = this.getSearchString(2);
            try {
                this.cbStart.setEnabled(false);
                this.cbReset.setEnabled(false);
                this.rView.list(this.cbxConnections.getSelectedItem().toString(), schema, table, column);
                this.rView.setInfo("schema:" + schema + " table:" + table + " column:" + column + " on " + this.cbxConnections.getSelectedItem().toString());
            }
            catch (SQLException e) {
                Application.println(e, true);
            }
            finally {
                this.cbStart.setEnabled(true);
                this.cbReset.setEnabled(true);
            }
        }
    }

    private String getSearchString(int idx) {
        String operator = this.cbx[idx].getSelectedItem().toString();
        String value = this.txt[idx].getText();
        if (value == null || value.length() == 0) {
            return null;
        }
        if (operator.toString().equals(this.operators[1])) {
            if (!value.toString().startsWith("%")) {
                value = "%" + value.toString();
            }
            if (!value.toString().endsWith("%")) {
                value = value.toString() + "%";
            }
        } else if (operator.toString().equals(this.operators[2])) {
            if (!value.toString().endsWith("%")) {
                value = value.toString() + "%";
            }
        } else if (operator.toString().equals(this.operators[3]) && !value.toString().startsWith("%")) {
            value = "%" + value.toString();
        }
        return value.toString().toUpperCase();
    }

    public JComponent getRightView() {
        return this.rView;
    }

    public void setPreferences() {
    }

    @Override
    public void onConnectionClosed(String keycah) {
        this.cbxConnections.removeItem(keycah);
    }

    @Override
    public void onConnectionOpened(String keycah) {
        this.cbxConnections.addItem(keycah);
    }
}

