/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.mdi;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EtchedBorder;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.gui.Toolbar;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.mdi.MDIClient;

public class MDIToolbar
extends BorderLayoutPanel {
    public MDIToolbar() {
        Toolbar toolbar = new Toolbar(0);
        toolbar.add(Application.window.getAction("action.113"));
        toolbar.add(Application.window.getAction("action.114"));
        toolbar.addSeparator();
        toolbar.add(Application.window.getAction("action.101"));
        toolbar.add(Application.window.getAction("action.102"));
        toolbar.add(Application.window.getAction("action.103"));
        toolbar.addSeparator();
        toolbar.add(Application.window.getAction("action.100"));
        toolbar.addSeparator();
        JPanel east = new JPanel();
        east.add(new MemoryBar());
        this.setComponentWest(toolbar);
        this.setComponentEast(east);
    }

    void onMDIClientActivated(MDIClient client) {
        if (this.getComponentCount() == 3) {
            this.remove(2);
        }
        if (client.getSubToolbar() != null) {
            this.setComponentCenter(client.getSubToolbar());
        }
        this.repaint();
    }

    class MemoryBar
    extends JProgressBar
    implements Runnable {
        private Thread me;

        public MemoryBar() {
            this.setBorder(new EtchedBorder(1));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (Application.confirm("SQLeonardo", "run the garbage collector?")) {
                        System.gc();
                    }
                }
            });
            this.me = new Thread(this);
            this.me.start();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width = 100;
            return dim;
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public void run() {
            while (true) {
                Runtime r = Runtime.getRuntime();
                float freeMemory = r.freeMemory();
                float totalMemory = r.totalMemory();
                int allocated = (int)(totalMemory / 1024.0f);
                int used = (int)((totalMemory - freeMemory) / 1024.0f);
                this.setMaximum(allocated);
                this.setValue(used);
                String toolTip = NumberFormat.getInstance().format(used) + "K used";
                toolTip = toolTip + " / " + NumberFormat.getInstance().format(allocated) + "K allocated ";
                this.setToolTipText(toolTip);
                try {
                    if (Thread.currentThread() != this.me) continue;
                    Thread.sleep(1975L);
                    continue;
                }
                catch (InterruptedException e) {
                    Application.println(e, false);
                    continue;
                }
                break;
            }
        }
    }
}

