/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.querybuilder.BrowserItems;
import nickyb.sqleonardo.querybuilder.DiagramField;
import nickyb.sqleonardo.querybuilder.DiagramQuery;
import nickyb.sqleonardo.querybuilder.QueryBuilder;
import nickyb.sqleonardo.querybuilder.ViewDiagram;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public abstract class DiagramAbstractEntity
extends JInternalFrame {
    BrowserItems.AbstractQueryTreeItem queryItem;
    QueryBuilder builder;
    private JMenu header;
    private JPanel fields;
    private Vector filterdFields = new Vector();

    DiagramAbstractEntity(QueryBuilder builder) {
        super("DiagramAbstractEntity", false, true);
        this.queryItem = builder.browser.getQueryItem();
        this.builder = builder;
        this.setLayer(JDesktopPane.PALETTE_LAYER);
        this.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        this.fields = new JPanel(new GridLayout(0, 1, 0, 0));
        this.getContentPane().add(this.fields);
        this.setJMenuBar(new JMenuBar());
        this.header = new JMenu();
        this.getJMenuBar().add(this.header);
        this.header.add(new MenuItemSortByName());
        this.header.add(new MenuItemPack());
        this.header.addSeparator();
        this.header.add(new ActionSelectAll());
        this.header.add(new ActionDeselectAll());
    }

    abstract void onCreate();

    abstract void onDestroy();

    public abstract QueryTokens.Table getQueryToken();

    JMenu getHeaderMenu() {
        return this.header;
    }

    void addField(DiagramField field) {
        if (QueryBuilder.autoAlias || this.queryItem instanceof BrowserItems.DiagramQueryTreeItem) {
            String alias = this.getQueryToken().getReference() + "." + field.querytoken.getName();
            if (alias.length() > QueryBuilder.maxColumnNameLength && QueryBuilder.maxColumnNameLength > 0) {
                alias = alias.substring(0, QueryBuilder.maxColumnNameLength);
            }
            field.querytoken.setAlias(alias);
        }
        this.fields.add(field);
    }

    void removeField(DiagramField field) {
        this.fields.remove(field);
    }

    private int findField(String label, boolean unpack) {
        DiagramField field;
        int i;
        if (unpack) {
            for (i = 0; i < this.filterdFields.size(); ++i) {
                field = (DiagramField)this.filterdFields.get(i);
                if (!field.getLabel().equalsIgnoreCase(label)) continue;
                this.fields.add(field);
                this.filterdFields.remove(field);
                this.doSort();
                this.pack();
                break;
            }
        }
        for (i = 0; i < this.fields.getComponentCount(); ++i) {
            field = (DiagramField)this.fields.getComponent(i);
            if (!field.getLabel().equalsIgnoreCase(label)) continue;
            return i;
        }
        return -1;
    }

    public DiagramField getField(String label) {
        return this.getField(label, false);
    }

    DiagramField getField(String label, boolean unpack) {
        int index = this.findField(label, unpack);
        return index != -1 ? (DiagramField)this.fields.getComponent(index) : null;
    }

    void setDragAndDropEnabled(boolean b) {
        for (int i = 0; i < this.fields.getComponentCount(); ++i) {
            DiagramField field = (DiagramField)this.fields.getComponent(i);
            field.setDragAndDropEnabled(b);
        }
    }

    void onSelectionChanged(DiagramField field) {
        if (field.isSelected()) {
            this.builder.browser.addSelectList(field.querytoken);
        } else {
            this.builder.browser.removeSelectList(field.querytoken);
        }
        this.doPack();
        if (this.queryItem instanceof BrowserItems.DiagramQueryTreeItem) {
            DiagramQuery entityUp = ((BrowserItems.DiagramQueryTreeItem)this.queryItem).getDiagramObject();
            if (field.isSelected()) {
                entityUp.addField(field.querytoken.getAlias());
            } else {
                entityUp.removeField(field.querytoken.getAlias());
            }
            entityUp.pack();
        }
    }

    void fireDeselectAll() {
        ((JMenuItem)this.getHeaderMenu().getMenuComponent(4)).getAction().actionPerformed(null);
    }

    void setColumnSelections(boolean selected) {
        this.setPack(false);
        for (int i = 0; i < this.fields.getComponentCount(); ++i) {
            ((DiagramField)this.fields.getComponent(i)).setSelected(selected);
        }
    }

    protected Color getDefaultBackground() {
        return ViewDiagram.BGCOLOR_DEFAULT;
    }

    void doFlush() {
        for (int i = 0; i < this.fields.getComponentCount(); ++i) {
            DiagramField field;
            field.setBackground((field = (DiagramField)this.fields.getComponent(i)).isJoined() ? ViewDiagram.BGCOLOR_JOINED : ViewDiagram.BGCOLOR_DEFAULT);
        }
    }

    void doSort() {
        JCheckBoxMenuItem mItem = (JCheckBoxMenuItem)this.header.getMenuComponent(0);
        if (mItem.isSelected()) {
            for (int i = 0; i < this.fields.getComponentCount() - 1; ++i) {
                String master = ((DiagramField)this.fields.getComponent(i)).getName();
                for (int j = i + 1; j < this.fields.getComponentCount(); ++j) {
                    String slave = ((DiagramField)this.fields.getComponent(j)).getName();
                    if (master.compareTo(slave) <= 0) continue;
                    DiagramField field = (DiagramField)this.fields.getComponent(j);
                    this.fields.remove(field);
                    this.fields.add((Component)field, i);
                    master = slave;
                }
            }
        } else {
            for (int i = 0; i < this.fields.getComponentCount() - 1; ++i) {
                int master = ((DiagramField)this.fields.getComponent((int)i)).position;
                for (int j = i + 1; j < this.fields.getComponentCount(); ++j) {
                    int slave = ((DiagramField)this.fields.getComponent((int)j)).position;
                    if (master <= slave) continue;
                    DiagramField field = (DiagramField)this.fields.getComponent(j);
                    this.fields.remove(field);
                    this.fields.add((Component)field, i);
                    master = slave;
                }
            }
        }
        this.builder.diagram.repaint();
        this.builder.diagram.validate();
        this.builder.diagram.doResize();
    }

    void setSort(boolean b) {
        JCheckBoxMenuItem mItem = (JCheckBoxMenuItem)this.header.getMenuComponent(0);
        mItem.setSelected(b);
        this.doSort();
    }

    void doPack() {
        boolean changed = false;
        if (this.isPack()) {
            for (int i = 0; i < this.fields.getComponentCount(); ++i) {
                DiagramField field = (DiagramField)this.fields.getComponent(i);
                if (field.isSelected() || field.isJoined()) continue;
                this.filterdFields.add(field);
                this.fields.remove(field);
                --i;
                changed = true;
            }
        } else {
            while (this.filterdFields.size() > 0) {
                this.fields.add((DiagramField)this.filterdFields.get(0));
                this.filterdFields.remove(0);
                changed = true;
            }
            this.doSort();
        }
        if (changed) {
            this.pack();
            this.builder.diagram.doResize();
        }
    }

    boolean isPack() {
        JCheckBoxMenuItem mItem = (JCheckBoxMenuItem)this.header.getMenuComponent(1);
        return mItem.isSelected();
    }

    void setPack(boolean b) {
        JCheckBoxMenuItem mItem = (JCheckBoxMenuItem)this.header.getMenuComponent(1);
        mItem.setSelected(b);
        this.doPack();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.header.setEnabled(b);
    }

    private class ActionDeselectAll
    extends AbstractAction {
        private ActionDeselectAll() {
            super(I18n.getString("querybuilder.menu.deselectAll", "deselect all"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DiagramAbstractEntity.this.setColumnSelections(false);
        }
    }

    private class ActionSelectAll
    extends AbstractAction {
        private ActionSelectAll() {
            super(I18n.getString("querybuilder.menu.selectAll", "select all"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DiagramAbstractEntity.this.setColumnSelections(true);
        }
    }

    private class MenuItemPack
    extends JCheckBoxMenuItem
    implements ActionListener {
        private MenuItemPack() {
            super(I18n.getString("querybuilder.menu.pack", "pack"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DiagramAbstractEntity.this.doPack();
        }
    }

    private class MenuItemSortByName
    extends JCheckBoxMenuItem
    implements ActionListener {
        private MenuItemSortByName() {
            super(I18n.getString("querybuilder.menu.sortByName", "sort by name"));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DiagramAbstractEntity.this.doSort();
        }
    }
}

