/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.querybuilder.BrowserItems;
import nickyb.sqleonardo.querybuilder.DiagramAbstractEntity;
import nickyb.sqleonardo.querybuilder.DiagramQuery;
import nickyb.sqleonardo.querybuilder.MaskCondition;
import nickyb.sqleonardo.querybuilder.ViewDiagram;
import nickyb.sqleonardo.querybuilder.dnd.DragMouseAdapter;
import nickyb.sqleonardo.querybuilder.dnd.RelationDropTargetListener;
import nickyb.sqleonardo.querybuilder.dnd.RelationTransferHandler;
import nickyb.sqleonardo.querybuilder.syntax.QueryTokens;

public class DiagramField
extends JPanel
implements ItemListener,
MouseListener,
PopupMenuListener {
    private static long expr_counter = 0L;
    int position;
    static ImageIcon keyIcon = null;
    QueryTokens.Column querytoken;
    private DiagramAbstractEntity owner;
    private JCheckBox checkboxComponent = null;
    private JLabel labelComponent = null;
    private MouseListener listener;
    private int joins;

    DiagramField(DiagramAbstractEntity entity, String label) {
        this(entity, label, false);
    }

    DiagramField(DiagramAbstractEntity entity, String label, boolean iskey) {
        this.setOwner(entity);
        this.setName(label);
        if (keyIcon == null) {
            keyIcon = new ImageIcon(this.getClass().getResource("/images/bullet_key.png"));
        }
        this.setLayout(new BorderLayout());
        this.checkboxComponent = new JCheckBox();
        this.labelComponent = new JLabel(label);
        this.labelComponent.setHorizontalTextPosition(2);
        Font f = this.labelComponent.getFont();
        if (!iskey) {
            f = new Font(f.getName(), 0, f.getSize());
        } else {
            f = new Font(f.getName(), 1, f.getSize());
            this.labelComponent.setIcon(keyIcon);
        }
        this.labelComponent.setFont(f);
        this.add((Component)this.getCheckboxComponent(), "West");
        this.add((Component)this.labelComponent, "Center");
        this.getLabelComponent().addMouseListener(this);
        this.listener = new DragMouseAdapter();
        this.getLabelComponent().addMouseListener(this.listener);
        this.getLabelComponent().setTransferHandler(new RelationTransferHandler());
        this.getLabelComponent().setDropTarget(new DropTarget(this, new RelationDropTargetListener(this.getOwner().builder.diagram)));
        this.getCheckboxComponent().addItemListener(this);
        this.getCheckboxComponent().addMouseListener(this);
        this.getCheckboxComponent().setPreferredSize(new Dimension(20, 8));
        this.getCheckboxComponent().setBorderPainted(false);
        this.getCheckboxComponent().setFocusPainted(false);
        this.getCheckboxComponent().setOpaque(false);
        this.setOpaque(true);
        this.setBackground(ViewDiagram.BGCOLOR_DEFAULT);
        this.setBorder(new LineBorder(UIManager.getColor("List.background")));
    }

    public String getLabel() {
        return this.getName();
    }

    @Override
    public void setToolTipText(String text) {
        this.getLabelComponent().setToolTipText(text);
    }

    QueryTokens.Column getQueryToken() {
        return this.querytoken;
    }

    void setQueryToken(QueryTokens.Column token) {
        this.querytoken = token;
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        this.getOwner().onSelectionChanged(this);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (SwingUtilities.isRightMouseButton(me)) {
            JPopupMenu popup = new JPopupMenu(this.getName());
            popup.addPopupMenuListener(this);
            popup.add(new MenuItemSelect());
            popup.addSeparator();
            popup.add(new ActionAddWhere());
            popup.add(new ActionAddHaving());
            popup.addSeparator();
            popup.add(new ActionAddExpression());
            popup.show(this, me.getX(), me.getY());
        } else if (!this.getOwner().builder.isDragAndDropEnabled()) {
            this.getOwner().builder.diagram.join(this.getOwner(), this);
        }
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pme) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
        this.setBorder(new LineBorder(UIManager.getColor("List.background")));
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
        this.setBorder(new LineBorder(UIManager.getColor("List.selectionBackground")));
    }

    boolean isJoined() {
        return this.joins > 0;
    }

    void joined() {
        ++this.joins;
    }

    void unjoined() {
        --this.joins;
    }

    void setDragAndDropEnabled(boolean b) {
        if (b) {
            this.getLabelComponent().addMouseListener(this.listener);
        } else {
            this.getLabelComponent().removeMouseListener(this.listener);
        }
    }

    public JCheckBox getCheckboxComponent() {
        return this.checkboxComponent;
    }

    public void setCheckboxComponent(JCheckBox checkboxComponent) {
        this.checkboxComponent = checkboxComponent;
    }

    public JLabel getLabelComponent() {
        return this.labelComponent;
    }

    public void setLabelComponent(JLabel labelComponent) {
        this.labelComponent = labelComponent;
    }

    public boolean isSelected() {
        return this.getCheckboxComponent().isSelected();
    }

    public void setSelected(boolean b) {
        this.getCheckboxComponent().setSelected(b);
    }

    public DiagramAbstractEntity getOwner() {
        return this.owner;
    }

    public void setOwner(DiagramAbstractEntity owner) {
        this.owner = owner;
    }

    private class ActionAddHaving
    extends ActionAddCondition {
        private ActionAddHaving() {
            this.putValue("Name", I18n.getString("querybuilder.menu.addHavingCondition", "add having condition..."));
        }

        @Override
        void add(QueryTokens.Condition token) {
            DiagramField.this.getOwner().builder.browser.addHavingClause(token);
        }

        @Override
        boolean isFirst() {
            return DiagramField.this.getOwner().builder.browser.getQuerySpecification().getHavingClause().length == 0;
        }
    }

    private class ActionAddWhere
    extends ActionAddCondition {
        private ActionAddWhere() {
            this.putValue("Name", I18n.getString("querybuilder.menu.addWhereCondition", "add where condition..."));
        }

        @Override
        void add(QueryTokens.Condition token) {
            DiagramField.this.getOwner().builder.browser.addWhereClause(token);
        }

        @Override
        boolean isFirst() {
            return DiagramField.this.getOwner().builder.browser.getQuerySpecification().getWhereClause().length == 0;
        }
    }

    private abstract class ActionAddCondition
    extends AbstractAction {
        private ActionAddCondition() {
        }

        abstract void add(QueryTokens.Condition var1);

        abstract boolean isFirst();

        @Override
        public void actionPerformed(ActionEvent e) {
            QueryTokens.Condition token = new QueryTokens.Condition();
            token.setLeft(new QueryTokens.DefaultExpression(DiagramField.this.querytoken.getIdentifier()));
            if (!this.isFirst()) {
                token.setAppend("AND");
            }
            if (new MaskCondition(token, ((DiagramField)DiagramField.this).owner.builder).showDialog()) {
                this.add(token);
            }
        }
    }

    private class ActionAddExpression
    extends AbstractAction {
        private ActionAddExpression() {
            super(I18n.getString("querybuilder.menu.addExpression", "add expression..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] functions = new String[]{"count", "max", "min", "sum"};
            Object choose = JOptionPane.showInputDialog(DiagramField.this.getOwner().builder, I18n.getString("querybuilder.message.chooseFunction", "choose function:"), I18n.getString("querybuilder.menu.addExpression", "add expression..."), -1, null, functions, null);
            if (choose != null) {
                String expr = choose.toString() + "(" + DiagramField.this.querytoken.getIdentifier() + ")";
                QueryTokens.DefaultExpression token = new QueryTokens.DefaultExpression(expr);
                BrowserItems.AbstractQueryTreeItem qti = DiagramField.this.getOwner().builder.browser.getQueryItem();
                if (qti instanceof BrowserItems.DiagramQueryTreeItem) {
                    token.setAlias("EXPR_" + ++expr_counter);
                    DiagramQuery entityUp = ((BrowserItems.DiagramQueryTreeItem)qti).getDiagramObject();
                    entityUp.addField(token.getAlias());
                    entityUp.pack();
                }
                DiagramField.this.getOwner().builder.browser.addSelectList(token);
            }
        }
    }

    private class MenuItemSelect
    extends JCheckBoxMenuItem
    implements ActionListener {
        private MenuItemSelect() {
            super("select");
            this.addActionListener(this);
            this.setState(DiagramField.this.isSelected());
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            DiagramField.this.setSelected(this.getState());
        }
    }
}

